/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.ls_client;

import com.lightstreamer.ls_client.ConnectionListener;
import com.lightstreamer.ls_client.ExtendedConnectionListener;
import com.lightstreamer.ls_client.MyServerListener;
import com.lightstreamer.ls_client.PushConnException;
import com.lightstreamer.ls_client.PushServerException;
import com.lightstreamer.ls_client.PushUserException;
import com.lightstreamer.ls_client.ServerManager;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;

class ExtConnectionListener
implements ExtendedConnectionListener {
    private final ConnectionListener target;
    private boolean streamingAppended = false;
    private Exception incapsulatedConnFailure = null;
    private final Semaphore streamingLock = new Semaphore(0);
    private final Semaphore flushLock = new Semaphore(0);
    private final ExecutorService myCallbackSender = ServerManager.createSingleThreadExecutor("Stream-sense queue");

    public ExtConnectionListener(ConnectionListener target) {
        this.target = target;
        this.myCallbackSender.execute(new Runnable(){

            public void run() {
                try {
                    ExtConnectionListener.this.flushLock.acquire();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
    }

    public void flushAndStart() {
        this.flushLock.release();
    }

    public void abort() {
        this.myCallbackSender.shutdownNow();
        this.flushLock.release();
    }

    public boolean waitStreamingTimeoutAnswer() throws PushConnException, PushServerException, PushUserException {
        try {
            this.streamingLock.acquire();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (this.incapsulatedConnFailure != null) {
            this.abort();
            Throwable e = this.incapsulatedConnFailure.getCause();
            if (e instanceof PushConnException) {
                throw (PushConnException)e;
            }
            if (e instanceof PushServerException) {
                throw (PushServerException)e;
            }
            if (e instanceof PushUserException) {
                throw (PushUserException)e;
            }
            throw new RuntimeException(e);
        }
        return this.streamingAppended;
    }

    public void onConnectionEstablished() {
        this.myCallbackSender.execute(new Runnable(){

            public void run() {
                ExtConnectionListener.this.target.onConnectionEstablished();
            }
        });
    }

    public void onSessionStartedExt(final String sessionID, final boolean isPolling) {
        this.myCallbackSender.execute(new Runnable(){

            public void run() {
                MyServerListener.sendExtendedSessionInfo(ExtConnectionListener.this.target, sessionID, isPolling, null);
            }
        });
    }

    public void onSessionStarted(boolean isPolling) {
    }

    public void onSessionStarted(final boolean isPolling, final String controlLink) {
        this.myCallbackSender.execute(new Runnable(){

            public void run() {
                MyServerListener.sendSessionInfo(ExtConnectionListener.this.target, isPolling, controlLink);
            }
        });
    }

    public void onStreamingReturned() {
        this.streamingLock.release();
    }

    public void onNewBytes(final long bytes) {
        this.myCallbackSender.execute(new Runnable(){

            public void run() {
                ExtConnectionListener.this.target.onNewBytes(bytes);
            }
        });
    }

    public void onDataError(final PushServerException e) {
        this.myCallbackSender.execute(new Runnable(){

            public void run() {
                ExtConnectionListener.this.target.onDataError(e);
            }
        });
    }

    public void onActivityWarning(final boolean warningOn) {
        this.myCallbackSender.execute(new Runnable(){

            public void run() {
                ExtConnectionListener.this.target.onActivityWarning(warningOn);
            }
        });
    }

    public void onClose() {
        this.myCallbackSender.execute(new Runnable(){

            public void run() {
                ExtConnectionListener.this.target.onClose();
            }
        });
        this.myCallbackSender.shutdown();
    }

    public void onEnd(final int cause) {
        this.myCallbackSender.execute(new Runnable(){

            public void run() {
                ExtConnectionListener.this.target.onEnd(cause);
            }
        });
        this.streamingLock.release();
    }

    public void onConnectTimeout(PushServerException e) {
        this.streamingAppended = true;
        this.onFailure(e);
    }

    public void onConnectException(Exception incapsulatingExc) {
        this.incapsulatedConnFailure = incapsulatingExc;
        this.streamingLock.release();
    }

    public void onFailure(final PushServerException e) {
        try {
            this.myCallbackSender.execute(new Runnable(){

                public void run() {
                    ExtConnectionListener.this.target.onFailure(e);
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
        this.streamingLock.release();
    }

    public void onFailure(final PushConnException e) {
        try {
            this.myCallbackSender.execute(new Runnable(){

                public void run() {
                    ExtConnectionListener.this.target.onFailure(e);
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
        this.streamingLock.release();
    }
}

