/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.ls_client;

import com.lightstreamer.ls_client.ConnectionConstraints;

public class ConnectionInfo
implements Cloneable {
    public long probeTimeoutMillis = 3000L;
    public long probeWarningMillis = 2000L;
    public long keepaliveMillis = 0L;
    public long reconnectionTimeoutMillis = 5000L;
    public boolean enableStreamSense = true;
    public boolean enableControlLinkHandling = true;
    public long streamingTimeoutMillis = 5000L;
    public long contentLength = 50000000L;
    public String pushServerUrl = null;
    public String pushServerControlUrl = null;
    public String user = null;
    public String password = null;
    public String adapter = null;
    public boolean isPolling = false;
    public long pollingMillis = 0L;
    public long pollingIdleMillis = 30000L;
    public ConnectionConstraints constraints = new ConnectionConstraints();

    String getAdapterSet() {
        if (this.adapter != null) {
            return this.adapter;
        }
        return "DEFAULT";
    }

    public String toString() {
        return this.pushServerUrl + " - " + this.constraints.toString();
    }

    public Object clone() {
        try {
            ConnectionInfo info = (ConnectionInfo)super.clone();
            info.constraints = (ConnectionConstraints)info.constraints.clone();
            return info;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        ConnectionInfo otherInfo = (ConnectionInfo)other;
        if (otherInfo.probeTimeoutMillis != this.probeTimeoutMillis) {
            return false;
        }
        if (otherInfo.probeWarningMillis != this.probeWarningMillis) {
            return false;
        }
        if (otherInfo.keepaliveMillis != this.keepaliveMillis) {
            return false;
        }
        if (otherInfo.reconnectionTimeoutMillis != this.reconnectionTimeoutMillis) {
            return false;
        }
        if (otherInfo.enableStreamSense != this.enableStreamSense) {
            return false;
        }
        if (otherInfo.streamingTimeoutMillis != this.streamingTimeoutMillis) {
            return false;
        }
        if (otherInfo.contentLength != this.contentLength) {
            return false;
        }
        if (otherInfo.isPolling != this.isPolling) {
            return false;
        }
        if (otherInfo.pollingMillis != this.pollingMillis) {
            return false;
        }
        if (otherInfo.pollingIdleMillis != this.pollingIdleMillis) {
            return false;
        }
        if (!this.equals(otherInfo.pushServerUrl, this.pushServerUrl)) {
            return false;
        }
        if (!this.equals(otherInfo.pushServerControlUrl, this.pushServerControlUrl)) {
            return false;
        }
        if (!this.equals(otherInfo.user, this.user)) {
            return false;
        }
        if (!this.equals(otherInfo.password, this.password)) {
            return false;
        }
        if (!this.equals(otherInfo.getAdapterSet(), this.getAdapterSet())) {
            return false;
        }
        return this.equals(otherInfo.constraints, this.constraints);
    }

    private boolean equals(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }
}

