/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.ls_client;

import com.lightstreamer.ls_client.HttpProvider;
import com.lightstreamer.ls_client.MyLineReader;
import com.lightstreamer.ls_client.PushConnException;
import com.lightstreamer.ls_client.SubscrException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BatchingHttpProvider
extends HttpProvider {
    private LineReaderMonitor firstReader;
    private LineReaderMonitor lastReader;
    private boolean consumed = false;
    private final int limit;
    private static Logger streamLogger = Logger.getLogger("com.lightstreamer.ls_client.stream");

    public BatchingHttpProvider(String address, int limit) {
        super(address);
        this.limit = limit;
    }

    public synchronized LineReaderMonitor addCall(HashMap<String, String> params) throws PushConnException, SubscrException {
        if (this.consumed) {
            throw new SubscrException("Illegal use of a batch");
        }
        if (!this.addLine(params, this.limit)) {
            return null;
        }
        LineReaderMonitor newReader = new LineReaderMonitor();
        if (this.lastReader == null) {
            this.firstReader = newReader;
        } else {
            this.lastReader.setNext(newReader);
        }
        this.lastReader = newReader;
        return newReader;
    }

    public synchronized boolean isEmpty() {
        return this.firstReader == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPosts() {
        InputStream input;
        LineReaderMonitor myReaders;
        BatchingHttpProvider batchingHttpProvider = this;
        synchronized (batchingHttpProvider) {
            if (this.consumed) {
                return;
            }
            this.consumed = true;
            myReaders = this.firstReader;
        }
        if (myReaders == null) {
            return;
        }
        try {
            input = this.connectAndGetAnswer(false);
        }
        catch (PushConnException e) {
            streamLogger.severe("Error in batch operation: " + e.getMessage());
            this.abort(e);
            return;
        }
        BatchedLineReader answers = new BatchedLineReader(new InputStreamReader(input), 1024);
        myReaders.setReader(answers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort(Throwable error) {
        LineReaderMonitor myReaders;
        BatchingHttpProvider batchingHttpProvider = this;
        synchronized (batchingHttpProvider) {
            if (this.consumed) {
                // empty if block
            }
            this.consumed = true;
            myReaders = this.firstReader;
        }
        if (myReaders == null) {
            return;
        }
        myReaders.setError(error);
    }

    public static class LineReaderMonitor {
        private Throwable error;
        private BatchedLineReader answer;
        private LineReaderMonitor next;

        private void setNext(LineReaderMonitor nextReader) {
            this.next = nextReader;
        }

        private synchronized void setReader(BatchedLineReader answer) {
            this.answer = answer;
            answer.setMaster(this);
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setError(Throwable error) {
            LineReaderMonitor lineReaderMonitor = this;
            synchronized (lineReaderMonitor) {
                this.error = error;
                this.notify();
            }
            if (this.next != null) {
                this.next.setError(error);
            }
        }

        public synchronized MyLineReader getReader() throws PushConnException, SubscrException {
            while (this.answer == null && this.error == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.error != null) {
                if (this.error instanceof PushConnException) {
                    throw (PushConnException)this.error;
                }
                if (this.error instanceof SubscrException) {
                    throw (SubscrException)this.error;
                }
                throw new PushConnException("Unexpected error", this.error);
            }
            return this.answer;
        }

        private boolean onReaderClose() {
            if (this.next != null) {
                this.next.setReader(this.answer);
                return true;
            }
            return false;
        }
    }

    static class BatchedLineReader
    extends MyLineReader {
        private LineReaderMonitor master;

        public BatchedLineReader(InputStreamReader reader, int suggestedBufferSize) {
            super(reader, suggestedBufferSize);
        }

        public void setMaster(LineReaderMonitor master) {
            this.master = master;
        }

        public void close() throws Throwable {
            if (!this.master.onReaderClose()) {
                streamLogger.finer("Closing control connection");
                super.close();
            }
        }
    }
}

