/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.ls_client;

import com.lightstreamer.ls_client.BatchListener;

class BatchMonitor {
    private boolean unlimitedBatch = false;
    private int pendingCalls = 0;
    private boolean empty = true;
    private BatchListener listener = null;

    BatchMonitor() {
    }

    synchronized void expand(int batchSize) {
        if (batchSize <= 0) {
            this.unlimitedBatch = true;
        } else if (!this.unlimitedBatch) {
            this.pendingCalls += batchSize;
        }
    }

    synchronized void useOne() {
        this.empty = false;
        if (!this.unlimitedBatch && this.pendingCalls > 0) {
            --this.pendingCalls;
        }
    }

    synchronized void batchedOne() {
        if (this.listener != null) {
            this.listener.onMessageBatched();
        }
    }

    synchronized boolean isEmpty() {
        return this.empty;
    }

    synchronized boolean isUnlimited() {
        return this.unlimitedBatch;
    }

    synchronized boolean isFilled() {
        if (this.unlimitedBatch) {
            return false;
        }
        return this.pendingCalls == 0;
    }

    synchronized void clear() {
        this.unlimitedBatch = false;
        this.pendingCalls = 0;
        this.empty = true;
    }

    public synchronized void setListener(BatchListener listener) {
        this.listener = listener;
    }

    public synchronized boolean hasListener() {
        return this.listener != null;
    }
}

