/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.ls_client;

import com.lightstreamer.ls_client.BatchMonitor;
import com.lightstreamer.ls_client.BatchingHttpProvider;
import com.lightstreamer.ls_client.HttpProvider;
import com.lightstreamer.ls_client.MyLineReader;
import com.lightstreamer.ls_client.PushConnException;
import com.lightstreamer.ls_client.SubscrException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BatchManager {
    private BatchingHttpProvider batchingProvider;
    private int limit = 0;
    private static Logger protLogger = Logger.getLogger("com.lightstreamer.ls_client.protocol");

    BatchManager() {
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MyLineReader getAnswer(String controlUrl, HashMap<String, String> params, BatchMonitor batch) throws SubscrException, PushConnException {
        BatchingHttpProvider batchToClose = null;
        BatchingHttpProvider.LineReaderMonitor answerMonitor = null;
        boolean retry = false;
        BatchMonitor batchMonitor = batch;
        synchronized (batchMonitor) {
            BatchManager batchManager = this;
            synchronized (batchManager) {
                if (!batch.isFilled()) {
                    batch.useOne();
                    if (this.batchingProvider != null) {
                        protLogger.fine("Batching control request");
                        if (protLogger.isLoggable(Level.FINER)) {
                            protLogger.finer("Control params: " + params);
                        }
                        if ((answerMonitor = this.batchingProvider.addCall(params)) != null) {
                            if (batch.isFilled()) {
                                batchToClose = this.batchingProvider;
                                this.batchingProvider = null;
                            }
                        } else if (this.batchingProvider.isEmpty()) {
                            protLogger.fine("Batching failed; trying without batch");
                            if (batch.isFilled()) {
                                this.batchingProvider = null;
                            }
                        } else {
                            protLogger.fine("Batching failed; trying a new batch");
                            batchToClose = this.batchingProvider;
                            batch.expand(1);
                            this.batchingProvider = new BatchingHttpProvider(controlUrl, this.limit);
                            retry = true;
                        }
                    }
                } else if (this.batchingProvider != null) {
                    this.batchingProvider.abort(new SubscrException("wrong requests batch"));
                    this.batchingProvider = null;
                }
            }
        }
        if (batchToClose != null) {
            BatchManager.doAsyncPost(batchToClose);
        }
        if (answerMonitor != null) {
            batch.batchedOne();
            return answerMonitor.getReader();
        }
        if (retry) {
            return this.getAnswer(controlUrl, params, batch);
        }
        return this.getNotBatchedAnswer(controlUrl, params);
    }

    MyLineReader getNotBatchedAnswer(String controlUrl, HashMap<String, String> params) throws PushConnException {
        HttpProvider pendingCall = new HttpProvider(controlUrl);
        protLogger.fine("Opening control connection");
        if (protLogger.isLoggable(Level.FINER)) {
            protLogger.finer("Control params: " + params);
        }
        InputStream input = pendingCall.doPost(params, false);
        return new MyLineReader(input, 1024);
    }

    synchronized void startBatch(String controlUrl) {
        if (this.batchingProvider != null) {
            this.batchingProvider.abort(new SubscrException("requests batch discarded"));
        }
        this.batchingProvider = new BatchingHttpProvider(controlUrl, this.limit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeBatch() {
        BatchingHttpProvider batchToClose;
        BatchManager batchManager = this;
        synchronized (batchManager) {
            batchToClose = this.batchingProvider;
            this.batchingProvider = null;
        }
        if (batchToClose != null) {
            BatchManager.doAsyncPost(batchToClose);
        }
    }

    private static void doAsyncPost(final BatchingHttpProvider batchToClose) {
        new Thread("Batch closing activity"){

            public void run() {
                try {
                    protLogger.fine("Opening control connection to send batched requests");
                    batchToClose.doPosts();
                }
                catch (Throwable t) {
                    protLogger.severe("Error in batch operation: " + t.getMessage());
                    batchToClose.abort(t);
                }
            }
        }.start();
    }

    synchronized void abortBatch() {
        if (this.batchingProvider != null) {
            this.batchingProvider.abort(new SubscrException("requests batch aborted"));
            this.batchingProvider = null;
        }
    }
}

