/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.util;

import java.util.Arrays;

public final class WideDecimal
extends Number
implements Comparable<WideDecimal> {
    private static final long serialVersionUID = 0L;
    public static final long NaN = 0L;
    public static final long POSITIVE_INFINITY = 256L;
    public static final long NEGATIVE_INFINITY = -256L;
    public static final long ZERO;
    public static final String NAN_STRING = "NaN";
    public static final String POSITIVE_INFINITY_STRING = "Infinity";
    public static final String NEGATIVE_INFINITY_STRING = "-Infinity";
    public static final String ZERO_STRING = "0";
    private final long wide;
    private static final long MAX_DOUBLE_SIGNIFICAND = 0x1FFFFFFFFFFFFFL;
    private static final long MAX_DOUBLE_VALUE = 0x8000000000000L;
    private static final long MAX_SIGNIFICAND = 0x7FFFFFFFFFFFFFL;
    private static final long MIN_SIGNIFICAND = -36028797018963968L;
    private static final int BIAS = 128;
    private static final char EXPONENT_CHAR = 'E';
    private static final int MAX_LEADING_ZEROES = 6;
    private static final int MAX_TRAILING_ZEROES = 6;
    private static final int MAX_STRING_LENGTH;
    private static final long SCIENTIFIC_MODULO;
    private static final char[] ZERO_CHARS;
    private static final int EXACT_LONG_POWERS = 18;
    private static final int EXACT_DOUBLE_POWERS = 22;
    private static final long[] LONG_POWERS;
    private static final double[] MULTIPLIERS;
    private static final double[] DIVISORS;
    private static final long[] LONG_MULTIPLIERS;
    private static final long[] LONG_DIVISORS;
    private static final double[] MAX_DOUBLES;
    private static final String[] NF_STRING;
    private static final double[] NF_DOUBLE;
    private static final long[] NF_LONG;
    private static final long[] NF_WIDE;

    public static String toString(long wide) {
        long significand = wide >> 8;
        int rank = (int)wide & 0xFF;
        if (rank == 0) {
            return NF_STRING[Long.signum(significand) & 3];
        }
        if (significand == 0L) {
            return ZERO_STRING;
        }
        long integerString = WideDecimal.toIntegerString(significand, rank);
        if (integerString != 0L) {
            return Long.toString(integerString);
        }
        return WideDecimal.appendFractionalOrScientific(new StringBuilder(MAX_STRING_LENGTH), significand, rank).toString();
    }

    public static StringBuilder appendTo(StringBuilder sb, long wide) {
        long significand = wide >> 8;
        int rank = (int)wide & 0xFF;
        if (rank == 0) {
            return sb.append(NF_STRING[Long.signum(significand) & 3]);
        }
        if (significand == 0L) {
            return sb.append(ZERO_STRING);
        }
        long integerString = WideDecimal.toIntegerString(significand, rank);
        if (integerString != 0L) {
            return sb.append(integerString);
        }
        return WideDecimal.appendFractionalOrScientific(sb, significand, rank);
    }

    private static long toIntegerString(long significand, int rank) {
        assert (significand != 0L && rank != 0);
        if (rank > 128) {
            long pow10;
            long result;
            if (rank - 128 <= 18 && (result = significand / (pow10 = LONG_POWERS[rank - 128])) * pow10 == significand && result % SCIENTIFIC_MODULO != 0L) {
                return result;
            }
        } else {
            long pow10;
            long result;
            if (rank == 128) {
                return significand % SCIENTIFIC_MODULO == 0L ? 0L : significand;
            }
            if (128 - rank <= 18 && 128 - rank <= 6 && (result = significand * (pow10 = LONG_POWERS[128 - rank])) / pow10 == significand && result % SCIENTIFIC_MODULO != 0L) {
                return result;
            }
        }
        return 0L;
    }

    private static StringBuilder appendFractionalOrScientific(StringBuilder sb, long significand, int rank) {
        int digits;
        assert (significand != 0L && rank != 0);
        while (significand % 10L == 0L) {
            significand /= 10L;
            --rank;
        }
        int firstDigit = sb.length() + (int)(significand >>> 63);
        sb.append(significand);
        if (rank > 128) {
            int dotPosition = sb.length() - (rank - 128);
            if (dotPosition > firstDigit) {
                return sb.insert(dotPosition, '.');
            }
            if (firstDigit - dotPosition <= 6) {
                return sb.insert(firstDigit, ZERO_CHARS, 0, 2 + (firstDigit - dotPosition));
            }
        } else if (128 - rank <= 6) {
            return sb.append(ZERO_CHARS, 2, 128 - rank);
        }
        if ((digits = sb.length() - firstDigit) != 1) {
            sb.insert(firstDigit + 1, '.');
        }
        return sb.append('E').append(128 - rank + digits - 1);
    }

    public static long parseWide(String s) throws NumberFormatException {
        return WideDecimal.parseToScale(s, 128);
    }

    public static long parseToScale(String s, int targetScale) throws NumberFormatException {
        int n = (s = s.trim()).length();
        if (n == 0) {
            throw new NumberFormatException("Empty string");
        }
        boolean negative = false;
        int i = 0;
        char c = s.charAt(i);
        if (c == '+' || c == '-') {
            boolean bl = negative = c == '-';
            if (++i >= n) {
                throw new NumberFormatException("No digits in '" + s + "'");
            }
            c = s.charAt(i);
        }
        if (c == 'N' || c == 'I') {
            return WideDecimal.parseLiteral(s);
        }
        long significand = 0L;
        int scale = 0;
        int dotSeen = 0;
        while (true) {
            if (c >= '0' && c <= '9') {
                if (significand <= 0xCCCCCCCCCCCCCCBL) {
                    significand = significand * 10L + (long)c - 48L;
                    scale += dotSeen;
                } else {
                    scale += dotSeen - 1;
                }
            } else if (c == '.') {
                if (dotSeen != 0) {
                    throw new NumberFormatException("Second dot in '" + s + "'");
                }
                dotSeen = 1;
            } else {
                if (c == 'e' || c == 'E') {
                    scale -= WideDecimal.parseExponent(s, i + 1, n);
                    break;
                }
                throw new NumberFormatException("Illegal character in '" + s + "'");
            }
            if (++i >= n) break;
            c = s.charAt(i);
        }
        if (significand == 0L) {
            return WideDecimal.targetRank(targetScale);
        }
        while (scale <= -128 && significand <= 0xCCCCCCCCCCCCCCCL) {
            significand *= 10L;
            ++scale;
        }
        return WideDecimal.composeToScale(negative ? -significand : significand, scale, targetScale);
    }

    private static long parseLiteral(String s) {
        if (NAN_STRING.equals(s)) {
            return 0L;
        }
        if (POSITIVE_INFINITY_STRING.equals(s)) {
            return 256L;
        }
        if (NEGATIVE_INFINITY_STRING.equals(s)) {
            return -256L;
        }
        throw new NumberFormatException("Illegal literal in '" + s + "'");
    }

    private static int parseExponent(String s, int i, int n) {
        if (i >= n) {
            throw new NumberFormatException("Empty exponent in '" + s + "'");
        }
        boolean negative = false;
        char c = s.charAt(i);
        if (c == '+' || c == '-') {
            boolean bl = negative = c == '-';
            if (++i >= n) {
                throw new NumberFormatException("No digits in exponent in '" + s + "'");
            }
            c = s.charAt(i);
        }
        int exponent = 0;
        while (true) {
            if (c < '0' || c > '9') {
                throw new NumberFormatException("Illegal character in exponent in '" + s + "'");
            }
            exponent = Math.min(exponent * 10 + c - 48, 1000);
            if (++i >= n) break;
            c = s.charAt(i);
        }
        return negative ? -exponent : exponent;
    }

    public static double toDouble(long wide) {
        long significand = wide >> 8;
        int rank = (int)wide & 0xFF;
        if (significand <= 0x1FFFFFFFFFFFFFL && -significand <= 0x1FFFFFFFFFFFFFL) {
            if (rank > 128) {
                if (rank <= 150) {
                    return (double)significand / DIVISORS[rank];
                }
            } else {
                if (rank == 128) {
                    return significand;
                }
                if (rank >= 106) {
                    return (double)significand * MULTIPLIERS[rank];
                }
                if (rank == 0) {
                    return NF_DOUBLE[Long.signum(significand) & 3];
                }
            }
        }
        return Double.parseDouble(WideDecimal.toString(wide));
    }

    public static long toLong(long wide) {
        long pow10;
        long result;
        long significand = wide >> 8;
        int rank = (int)wide & 0xFF;
        if (rank > 128) {
            if (rank <= 146) {
                return WideDecimal.div10(significand, LONG_DIVISORS[rank]);
            }
            return 0L;
        }
        if (rank == 128) {
            return significand;
        }
        if (rank >= 110 && (result = significand * (pow10 = LONG_MULTIPLIERS[rank])) / pow10 == significand) {
            return result;
        }
        return NF_LONG[Long.signum(significand) & 3];
    }

    public static long composeWide(double value) {
        if (value == (double)((long)value)) {
            return WideDecimal.composeWide((long)value);
        }
        return value >= 0.0 ? WideDecimal.composeNonNegative(value, 128) : (value < 0.0 ? WideDecimal.neg(WideDecimal.composeNonNegative(-value, 128)) : 0L);
    }

    public static long composeToScale(double value, int targetScale) {
        int targetRank = WideDecimal.targetRank(targetScale);
        return value >= 0.0 ? WideDecimal.composeNonNegative(value, targetRank) : (value < 0.0 ? WideDecimal.neg(WideDecimal.composeNonNegative(-value, targetRank)) : 0L);
    }

    private static long composeNonNegative(double value, int targetRank) {
        assert (value >= 0.0);
        int rank = WideDecimal.findRank(value);
        if (rank <= 0) {
            return 256L;
        }
        long significand = (long)(value * DIVISORS[rank] + 0.5);
        return WideDecimal.composeFitting(significand, rank, targetRank);
    }

    private static int findRank(double value) {
        int rank = value > MAX_DOUBLES[128] ? 0 : 128;
        return rank += value > MAX_DOUBLES[(rank += value > MAX_DOUBLES[(rank += value > MAX_DOUBLES[(rank += value > MAX_DOUBLES[(rank += value > MAX_DOUBLES[(rank += value > MAX_DOUBLES[(rank += value > MAX_DOUBLES[rank + 64] ? 0 : 64) + 32] ? 0 : 32) + 16] ? 0 : 16) + 8] ? 0 : 8) + 4] ? 0 : 4) + 2] ? 0 : 2) + 1] ? 0 : 1;
    }

    public static long composeWide(long value) {
        return -36028797018963968L <= value && value <= 0x7FFFFFFFFFFFFFL ? value << 8 | 0x80L : WideDecimal.composeNonFitting(value, 128, 128);
    }

    public static long composeToScale(long value, int targetScale) {
        int targetRank = WideDecimal.targetRank(targetScale);
        return -36028797018963968L <= value && value <= 0x7FFFFFFFFFFFFFL ? WideDecimal.composeFitting(value, 128, targetRank) : WideDecimal.composeNonFitting(value, 128, targetRank);
    }

    public static long composeWide(long significand, int scale) {
        if (scale > 145) {
            return 128L;
        }
        return WideDecimal.composeNonFitting(significand, scale + 128, 128);
    }

    public static long composeToScale(long significand, int scale, int targetScale) {
        int targetRank = WideDecimal.targetRank(targetScale);
        if (scale > 145) {
            return targetRank;
        }
        return WideDecimal.composeNonFitting(significand, scale + 128, targetRank);
    }

    private static long composeNonFitting(long significand, int rank, int targetRank) {
        assert (1 <= targetRank && targetRank <= 255);
        if (rank <= 0) {
            return NF_WIDE[Long.signum(significand) & 3];
        }
        if (rank > 273) {
            return targetRank;
        }
        int reduction = -36028797018963968L <= significand && significand <= 0x7FFFFFFFFFFFFFL ? 0 : (-360287970189639685L <= significand && significand < 0x4FFFFFFFFFFFFFBL ? 1 : (-3602879701896396850L <= significand && significand < 3602879701896396750L ? 2 : 3));
        if (rank <= reduction) {
            return NF_WIDE[Long.signum(significand) & 3];
        }
        if ((reduction = Math.max(reduction, rank - 255)) > 0) {
            significand = WideDecimal.div10(significand, LONG_POWERS[reduction]);
            rank -= reduction;
        }
        return WideDecimal.composeFitting(significand, rank, targetRank);
    }

    private static long composeFitting(long significand, int rank, int targetRank) {
        assert (-36028797018963968L <= significand && significand <= 0x7FFFFFFFFFFFFFL && 1 <= rank && rank <= 255 && 1 <= targetRank && targetRank <= 255);
        if (significand == 0L) {
            return targetRank;
        }
        while (rank > targetRank && significand % 10L == 0L) {
            significand /= 10L;
            --rank;
        }
        while (rank < targetRank && -3602879701896396L <= significand && significand <= 0xCCCCCCCCCCCCCL) {
            significand *= 10L;
            ++rank;
        }
        if (rank == 129 && targetRank == 128 && -3602879701896396L <= significand && significand <= 0xCCCCCCCCCCCCCL) {
            significand *= 10L;
            ++rank;
        }
        return significand << 8 | (long)rank;
    }

    public static long getSignificand(long wide) {
        return wide >> 8;
    }

    public static int getScale(long wide) {
        return ((int)wide & 0xFF) - 128;
    }

    public static boolean isNaN(long wide) {
        return wide == 0L;
    }

    public static boolean isDefined(long wide) {
        return wide != 0L;
    }

    public static boolean isInfinite(long wide) {
        return (wide & 0xFFL) == 0L && wide != 0L;
    }

    public static boolean isFinite(long wide) {
        return (wide & 0xFFL) != 0L;
    }

    public static int signum(long wide) {
        return Long.signum(wide >> 8);
    }

    public static long neg(long wide) {
        return (wide ^ 0xFFFFFFFFFFFFFF00L) + 256L;
    }

    public static long abs(long wide) {
        return wide >= 0L ? wide : WideDecimal.neg(wide);
    }

    public static long round(long wide) {
        return WideDecimal.round(wide, 0);
    }

    public static long round(long wide, int scale) {
        int rank = (int)wide & 0xFF;
        if (rank == 0 || rank - 128 <= scale) {
            return wide;
        }
        if (rank - 128 - 18 > scale) {
            return rank;
        }
        long pow10 = LONG_POWERS[rank - 128 - scale];
        long significand = wide >> 8;
        significand = WideDecimal.div10(significand, pow10) * pow10;
        return significand << 8 | (long)rank;
    }

    public static long toScale(long wide, int targetScale) {
        int rank = (int)wide & 0xFF;
        if (rank == 0) {
            return wide;
        }
        long significand = wide >> 8;
        int targetRank = WideDecimal.targetRank(targetScale);
        return WideDecimal.composeFitting(significand, rank, targetRank);
    }

    public static long zeroToScale(int targetScale) {
        return WideDecimal.targetRank(targetScale);
    }

    public static long selectDefined(long w1, long w2) {
        return WideDecimal.isNaN(w1) ? w2 : w1;
    }

    public static long sum(long w1, long w2) {
        int r1 = (int)w1 & 0xFF;
        int r2 = (int)w2 & 0xFF;
        if (r1 > 0 && r2 > 0) {
            long s1 = w1 >> 8;
            long s2 = w2 >> 8;
            if (s1 == 0L) {
                return w2;
            }
            if (s2 == 0L) {
                return w1;
            }
            if (r1 == r2) {
                return WideDecimal.composeNonFitting(s1 + s2, r1, r1);
            }
            if (r1 > r2) {
                if (r1 - r2 <= 18) {
                    long pow10 = LONG_POWERS[r1 - r2];
                    long scaled = s2 * pow10;
                    long result = s1 + scaled;
                    if (scaled / pow10 == s2 && ((s1 ^ result) & (scaled ^ result)) >= 0L) {
                        return WideDecimal.composeNonFitting(result, r1, r1);
                    }
                }
            } else if (r2 - r1 <= 18) {
                long pow10 = LONG_POWERS[r2 - r1];
                long scaled = s1 * pow10;
                long result = scaled + s2;
                if (scaled / pow10 == s1 && ((scaled ^ result) & (s2 ^ result)) >= 0L) {
                    return WideDecimal.composeNonFitting(result, r2, r2);
                }
            }
        }
        if (WideDecimal.isNaN(w1) || WideDecimal.isNaN(w2)) {
            return 0L;
        }
        return WideDecimal.composeWide(WideDecimal.toDouble(w1) + WideDecimal.toDouble(w2));
    }

    public static long sumDefined(long w1, long w2) {
        return WideDecimal.isNaN(w1) ? w2 : (WideDecimal.isNaN(w2) ? w1 : WideDecimal.sum(w1, w2));
    }

    public static long subtract(long w1, long w2) {
        return WideDecimal.sum(w1, WideDecimal.neg(w2));
    }

    public static long subtractDefined(long w1, long w2) {
        return WideDecimal.sumDefined(w1, WideDecimal.neg(w2));
    }

    public static long average(long w1, long w2) {
        long wide = WideDecimal.sum(w1, w2);
        long significand = wide >> 8;
        int rank = (int)wide & 0xFF;
        if (significand == 0L || rank == 0) {
            return wide;
        }
        return WideDecimal.composeNonFitting(significand * 5L, rank + 1, rank);
    }

    public static long averageDefined(long w1, long w2) {
        return WideDecimal.isNaN(w1) ? w2 : (WideDecimal.isNaN(w2) ? w1 : WideDecimal.average(w1, w2));
    }

    public static long multiply(long w1, long w2) {
        int r1 = (int)w1 & 0xFF;
        int r2 = (int)w2 & 0xFF;
        if (r1 > 0 && r2 > 0) {
            int targetRank = Math.max(r1, r2);
            long s1 = w1 >> 8;
            long s2 = w2 >> 8;
            if (s1 == 0L || s2 == 0L) {
                return targetRank;
            }
            int rank = r1 + r2 - 128;
            while (s1 % 10L == 0L) {
                s1 /= 10L;
                --rank;
            }
            while (s2 % 10L == 0L) {
                s2 /= 10L;
                --rank;
            }
            long result = s1 * s2;
            if (result / s2 == s1) {
                while (rank < 1 && -922337203685477580L <= result && result <= 0xCCCCCCCCCCCCCCCL) {
                    result *= 10L;
                    ++rank;
                }
                return WideDecimal.composeNonFitting(result, rank, targetRank);
            }
        }
        if (WideDecimal.isNaN(w1) || WideDecimal.isNaN(w2)) {
            return 0L;
        }
        return WideDecimal.composeWide(WideDecimal.toDouble(w1) * WideDecimal.toDouble(w2));
    }

    public static long divide(long w1, long w2) {
        int r1 = (int)w1 & 0xFF;
        int r2 = (int)w2 & 0xFF;
        if (r1 > 0 && r2 > 0) {
            long s1 = w1 >> 8;
            long s2 = w2 >> 8;
            if (s2 == 0L) {
                return NF_WIDE[Long.signum(s1) & 3];
            }
            if (s1 == 0L) {
                return r1;
            }
            int rank = r1 - r2 + 128;
            while (-922337203685477580L <= s1 && s1 <= 0xCCCCCCCCCCCCCCCL) {
                s1 *= 10L;
                ++rank;
            }
            while (s2 % 10L == 0L) {
                s2 /= 10L;
                ++rank;
            }
            long result = s1 / s2;
            if (result * s2 == s1) {
                while (rank < 1 && -922337203685477580L <= result && result <= 0xCCCCCCCCCCCCCCCL) {
                    result *= 10L;
                    ++rank;
                }
                return WideDecimal.composeNonFitting(result, rank, r1);
            }
        }
        if (WideDecimal.isNaN(w1) || WideDecimal.isNaN(w2)) {
            return 0L;
        }
        return WideDecimal.composeWide(WideDecimal.toDouble(w1) / WideDecimal.toDouble(w2));
    }

    public static long max(long w1, long w2) {
        return WideDecimal.compare(w1, w2) >= 0 ? w1 : w2;
    }

    public static long maxDefined(long w1, long w2) {
        return WideDecimal.isNaN(w1) ? w2 : (WideDecimal.isNaN(w2) ? w1 : WideDecimal.max(w1, w2));
    }

    public static long min(long w1, long w2) {
        return WideDecimal.compare(w1, w2) <= 0 ? w1 : w2;
    }

    public static long minDefined(long w1, long w2) {
        return WideDecimal.isNaN(w1) ? w2 : (WideDecimal.isNaN(w2) ? w1 : WideDecimal.min(w1, w2));
    }

    public static int compare(long w1, long w2) {
        if (w1 == w2) {
            return 0;
        }
        if ((w1 ^ w2) < 0L) {
            return w1 > w2 ? 1 : -1;
        }
        int r1 = (int)w1 & 0xFF;
        int r2 = (int)w2 & 0xFF;
        if (r1 > 0 && r2 > 0) {
            long pow10;
            long scaled;
            if (r1 == r2) {
                return w1 > w2 ? 1 : -1;
            }
            long s1 = w1 >> 8;
            long s2 = w2 >> 8;
            if (s1 == 0L) {
                return Long.signum(-s2);
            }
            if (s2 == 0L) {
                return Long.signum(s1);
            }
            if (r1 > r2) {
                long pow102;
                long scaled2;
                if (r1 - r2 <= 18 && (scaled2 = s2 * (pow102 = LONG_POWERS[r1 - r2])) / pow102 == s2) {
                    return Long.compare(s1, scaled2);
                }
            } else if (r2 - r1 <= 18 && (scaled = s1 * (pow10 = LONG_POWERS[r2 - r1])) / pow10 == s1) {
                return Long.compare(scaled, s2);
            }
        }
        if (WideDecimal.isNaN(w1)) {
            return 1;
        }
        if (WideDecimal.isNaN(w2)) {
            return -1;
        }
        return Double.compare(WideDecimal.toDouble(w1), WideDecimal.toDouble(w2));
    }

    public WideDecimal(long wide) {
        this.wide = wide;
    }

    public WideDecimal(String s) throws NumberFormatException {
        this.wide = WideDecimal.parseWide(s);
    }

    public boolean isNaN() {
        return WideDecimal.isNaN(this.wide);
    }

    public boolean isInfinite() {
        return WideDecimal.isInfinite(this.wide);
    }

    @Override
    public byte byteValue() {
        return (byte)WideDecimal.toLong(this.wide);
    }

    @Override
    public short shortValue() {
        return (short)WideDecimal.toLong(this.wide);
    }

    @Override
    public int intValue() {
        return (int)WideDecimal.toLong(this.wide);
    }

    @Override
    public long longValue() {
        return WideDecimal.toLong(this.wide);
    }

    @Override
    public float floatValue() {
        return (float)WideDecimal.toDouble(this.wide);
    }

    @Override
    public double doubleValue() {
        return WideDecimal.toDouble(this.wide);
    }

    public String toString() {
        return WideDecimal.toString(this.wide);
    }

    public int hashCode() {
        return Long.hashCode(this.wide);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof WideDecimal && this.wide == ((WideDecimal)obj).wide;
    }

    @Override
    public int compareTo(WideDecimal other) {
        return WideDecimal.compare(this.wide, other.wide);
    }

    private static long div10(long significand, long pow10) {
        return significand >= 0L ? significand / (pow10 >> 1) + 1L >> 1 : (significand + 1L) / (pow10 >> 1) >> 1;
    }

    private static int targetRank(int targetScale) {
        return 128 + Math.min(Math.max(targetScale, -127), 127);
    }

    static {
        int rank;
        MAX_STRING_LENGTH = 18 + Math.max(6, Math.max(8, 6));
        ZERO_CHARS = new char[130];
        LONG_POWERS = new long[19];
        MULTIPLIERS = new double[256];
        DIVISORS = new double[256];
        LONG_MULTIPLIERS = new long[256];
        LONG_DIVISORS = new long[256];
        MAX_DOUBLES = new double[256];
        NF_STRING = new String[]{NAN_STRING, POSITIVE_INFINITY_STRING, NAN_STRING, NEGATIVE_INFINITY_STRING};
        NF_DOUBLE = new double[]{Double.NaN, Double.POSITIVE_INFINITY, Double.NaN, Double.NEGATIVE_INFINITY};
        NF_LONG = new long[]{0L, Long.MAX_VALUE, 0L, Long.MIN_VALUE};
        NF_WIDE = new long[]{0L, 256L, 0L, -256L};
        ZERO = 128L;
        long pow10 = 1L;
        for (int i = 0; i <= 18; ++i) {
            WideDecimal.LONG_POWERS[i] = pow10;
            WideDecimal.LONG_MULTIPLIERS[128 - i] = pow10;
            WideDecimal.LONG_DIVISORS[128 + i] = pow10;
            pow10 *= 10L;
        }
        SCIENTIFIC_MODULO = LONG_POWERS[7];
        Arrays.fill(ZERO_CHARS, '0');
        WideDecimal.ZERO_CHARS[1] = 46;
        WideDecimal.MULTIPLIERS[0] = Double.POSITIVE_INFINITY;
        for (rank = 1; rank < MULTIPLIERS.length; ++rank) {
            WideDecimal.MULTIPLIERS[rank] = Double.parseDouble("1E" + (128 - rank));
        }
        WideDecimal.DIVISORS[0] = 0.0;
        for (rank = 1; rank < DIVISORS.length; ++rank) {
            WideDecimal.DIVISORS[rank] = Double.parseDouble("1E" + (rank - 128));
        }
        for (rank = 0; rank < MAX_DOUBLES.length; ++rank) {
            WideDecimal.MAX_DOUBLES[rank] = 2.251799813685248E15 * MULTIPLIERS[rank];
        }
    }
}

