/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.util;

import com.devexperts.util.SystemProperties;
import java.util.TimeZone;

public class TimeUtil {
    public static final long SECOND = 1000L;
    public static final long MINUTE = 60000L;
    public static final long HOUR = 3600000L;
    public static final long DAY = 86400000L;
    private static final boolean SKIP_TIME_ZONE_VALIDATION = SystemProperties.getBooleanProperty(TimeUtil.class, "skipTimeZoneValidation", false);

    private TimeUtil() {
    }

    public static int getSecondsFromTime(long timeMillis) {
        return timeMillis >= 0L ? (int)Math.min(timeMillis / 1000L, Integer.MAX_VALUE) : (int)Math.max((timeMillis + 1L) / 1000L - 1L, Integer.MIN_VALUE);
    }

    public static int getMillisFromTime(long timeMillis) {
        return (int)Math.floorMod(timeMillis, 1000L);
    }

    public static TimeZone getTimeZoneGmt() {
        return TimeZone.getTimeZone("GMT");
    }

    public static TimeZone getTimeZone(String tz) {
        TimeZone timeZone = TimeZone.getTimeZone(tz);
        if (!SKIP_TIME_ZONE_VALIDATION && !timeZone.getID().equals(tz)) {
            throw new IllegalArgumentException("Unknown time-zone: " + tz);
        }
        return timeZone;
    }
}

