/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.util;

import com.devexperts.util.InvalidFormatException;
import java.io.Serializable;

public class TimePeriod
implements Serializable {
    private static final long serialVersionUID = 0L;
    public static final TimePeriod ZERO = new TimePeriod(0L);
    public static final TimePeriod UNLIMITED = new TimePeriod(Long.MAX_VALUE);
    private static final String UNLIMITED_STR = "inf";
    private final long value;

    public static TimePeriod valueOf(long value) {
        return value == 0L ? ZERO : (value == Long.MAX_VALUE ? UNLIMITED : new TimePeriod(value));
    }

    public static TimePeriod valueOf(String value) throws InvalidFormatException {
        return TimePeriod.valueOf(TimePeriod.parse(value));
    }

    protected TimePeriod(long value) {
        this.value = value;
    }

    protected static long parse(String value) {
        try {
            boolean good;
            if (UNLIMITED_STR.equalsIgnoreCase(value)) {
                return UNLIMITED.getTime();
            }
            boolean metAnyPart = false;
            value = value.toUpperCase() + '#';
            long res = 0L;
            int i = 0;
            if (value.charAt(i) == 'P') {
                ++i;
            }
            int j = i;
            while (Character.isDigit(value.charAt(j))) {
                ++j;
            }
            if (value.charAt(j) == 'D') {
                res += (long)Integer.parseInt(value.substring(i, j));
                metAnyPart = true;
                i = ++j;
                while (Character.isDigit(value.charAt(j))) {
                    ++j;
                }
            }
            res *= 24L;
            if (value.charAt(j) == 'T') {
                if (i != j) {
                    throw new InvalidFormatException("Wrong time period format.");
                }
                i = ++j;
                while (Character.isDigit(value.charAt(j))) {
                    ++j;
                }
            }
            if (value.charAt(j) == 'H') {
                res += (long)Integer.parseInt(value.substring(i, j));
                metAnyPart = true;
                i = ++j;
                while (Character.isDigit(value.charAt(j))) {
                    ++j;
                }
            }
            res *= 60L;
            if (value.charAt(j) == 'M') {
                res += (long)Integer.parseInt(value.substring(i, j));
                metAnyPart = true;
                i = ++j;
                while (Character.isDigit(value.charAt(j))) {
                    ++j;
                }
            }
            res *= 60000L;
            if (value.charAt(j) == '.') {
                ++j;
                while (Character.isDigit(value.charAt(j))) {
                    ++j;
                }
            }
            if (i != j) {
                res += Math.round(Double.parseDouble(value.substring(i, j)) * 1000.0);
                metAnyPart = true;
            }
            boolean bl = good = value.charAt(j) == 'S' && j == value.length() - 2 && i != j || value.charAt(j) == '#' && j == value.length() - 1;
            if (!(good &= metAnyPart)) {
                throw new InvalidFormatException("Wrong time period format.");
            }
            return res;
        }
        catch (NumberFormatException e) {
            throw new InvalidFormatException("Wrong time period format.");
        }
    }

    public String toString() {
        long v = this.value;
        long millis = v % 1000L;
        long secs = (v /= 1000L) % 60L;
        long mins = (v /= 60L) % 60L;
        long hours = (v /= 60L) % 24L;
        long days = v /= 24L;
        StringBuilder result = new StringBuilder();
        result.append('P');
        if (days > 0L) {
            result.append(days).append("D");
        }
        result.append('T');
        if (hours > 0L) {
            result.append(hours).append("H");
        }
        if (mins > 0L) {
            result.append(mins).append("M");
        }
        if (millis > 0L) {
            result.append((double)(secs * 1000L + millis) / 1000.0);
        } else {
            result.append(secs);
        }
        result.append("S");
        return result.toString();
    }

    public long getTime() {
        return this.value;
    }

    public int getSeconds() {
        return (int)Math.floorDiv(this.value, 1000L);
    }

    public long getNanos() {
        return 1000000L * this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimePeriod that = (TimePeriod)o;
        return this.value == that.value;
    }

    public int hashCode() {
        return (int)this.value;
    }
}

