/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.util;

import com.devexperts.logging.Logging;
import com.devexperts.util.DayUtil;
import com.devexperts.util.InvalidFormatException;
import com.devexperts.util.MathUtil;
import com.devexperts.util.TimePeriod;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.TimeZone;
import javax.annotation.concurrent.ThreadSafe;

public class TimeFormat {
    public static final TimeFormat DEFAULT = TimeFormat.getInstance(TimeZone.getDefault());
    public static final TimeFormat GMT = TimeFormat.getInstance(TimeZone.getTimeZone("GMT"));
    private static final long MIN_TIME = (long)(DayUtil.getDayIdByYearMonthDay(10101) - 1) * 86400000L;
    private static final long MAX_TIME = (long)(DayUtil.getDayIdByYearMonthDay(99991231) + 2) * 86400000L;
    private static final char END_CHAR = '$';
    private static final char DATE_SEPARATOR = '-';
    private static final char TIME_SEPARATOR = ':';
    private static final char[] DATE_TIME_SEPARATORS;
    private TimeZone timezone;
    private final Formats formats;
    private final Format format;
    private final TimeFormat withTimeZone;
    private final TimeFormat withMillis;
    private final TimeFormat asFullIso;

    public static TimeFormat getInstance(TimeZone timezone) {
        timezone = (TimeZone)timezone.clone();
        Formats formats = new Formats(timezone);
        TimeFormat fullIsoTF = new TimeFormat(timezone, formats, formats.fullIsoFmt, null, null, null);
        TimeFormat millisTimezoneTF = new TimeFormat(timezone, formats, formats.millisTimezoneFmt, null, null, fullIsoTF);
        TimeFormat timezoneTF = new TimeFormat(timezone, formats, formats.timezoneFmt, null, millisTimezoneTF, fullIsoTF);
        TimeFormat millisTF = new TimeFormat(timezone, formats, formats.millisFmt, millisTimezoneTF, null, fullIsoTF);
        return new TimeFormat(timezone, formats, formats.defaultFmt, timezoneTF, millisTF, fullIsoTF);
    }

    @Deprecated
    public static void setDefaultTimeZone(TimeZone timezone) {
        Logging.getLogging(TimeFormat.class).warn("Changing DEFAULT time zone to " + timezone.getID() + ". Do not use in production code.");
        TimeFormat.DEFAULT.timezone = (TimeZone)timezone.clone();
        TimeFormat.DEFAULT.formats.setTimeZone(TimeFormat.DEFAULT.timezone);
    }

    private TimeFormat(TimeZone timezone, Formats formats, Format format, TimeFormat withTimeZone, TimeFormat withMillis, TimeFormat asFullIso) {
        this.timezone = timezone;
        this.formats = formats;
        this.format = format;
        this.withTimeZone = withTimeZone == null ? this : withTimeZone;
        this.withMillis = withMillis == null ? this : withMillis;
        this.asFullIso = asFullIso == null ? this : asFullIso;
    }

    public TimeFormat withTimeZone() {
        return this.withTimeZone;
    }

    public TimeFormat withMillis() {
        return this.withMillis;
    }

    public TimeFormat asFullIso() {
        return this.asFullIso;
    }

    public Date parse(String value) throws InvalidFormatException, NullPointerException {
        if (value == null) {
            throw new NullPointerException("Value is null");
        }
        String v = value.trim();
        if (v.isEmpty()) {
            throw new InvalidFormatException("Cannot parse date-time from empty string");
        }
        if (v.equals("0")) {
            return new Date(0L);
        }
        if (TimeFormat.hasStandardDate(v) && TimeFormat.hasStandardTime(v) && TimeFormat.hasStandardZone(v)) {
            Format fmt;
            boolean stdMillis = TimeFormat.hasStandardMillis(v);
            Format format = fmt = stdMillis ? this.formats.millisTimezoneFmt : this.formats.timezoneFmt;
            if (v.length() == fmt.standardLength) {
                long time = 86400000L * (long)DayUtil.getDayIdByYearMonthDay(TimeFormat.getNum2(v, 0) * 100 + TimeFormat.getNum2(v, 2), TimeFormat.getNum2(v, 4), TimeFormat.getNum2(v, 6)) + 3600000L * (long)TimeFormat.getNum2(v, 9) + 60000L * (long)TimeFormat.getNum2(v, 11) + 1000L * (long)TimeFormat.getNum2(v, 13);
                if (stdMillis) {
                    time += (long)TimeFormat.getNum3(v, 16);
                }
                int n = v.length();
                long offset = 3600000L * (long)TimeFormat.getNum2(v, n - 4) + 60000L * (long)TimeFormat.getNum2(v, n - 2);
                time = v.charAt(n - 5) == '+' ? (time -= offset) : (time += offset);
                return new Date(time);
            }
        }
        return this.parseSlowImpl(v);
    }

    private Date parseSlowImpl(String original) throws InvalidFormatException {
        Format fmt;
        int pos;
        if (original.charAt(0) == '-') {
            String v = original.substring(1);
            TimePeriod p = TimePeriod.valueOf(v);
            return new Date(System.currentTimeMillis() - p.getTime());
        }
        if (TimeFormat.longValueInMillis(original)) {
            try {
                return new Date(Long.parseLong(original));
            }
            catch (NumberFormatException e) {
                TimeFormat.badDateTime(original);
            }
        }
        String v = original + '$';
        StringBuilder buffer = new StringBuilder();
        boolean timeShouldFollow = true;
        boolean parsedDate = false;
        if (Character.toUpperCase(v.charAt(0)) != 'T') {
            pos = this.tryParseDate(v, buffer);
            if (pos > 0) {
                parsedDate = true;
                if (Arrays.binarySearch(DATE_TIME_SEPARATORS, v.charAt(pos)) < 0) {
                    timeShouldFollow = false;
                } else {
                    ++pos;
                }
            }
        } else {
            pos = 1;
        }
        if (!parsedDate) {
            buffer.append(this.formats.dateFmt.get().format(new Date()));
        }
        buffer.append('-');
        boolean millis = false;
        if (timeShouldFollow) {
            boolean separator;
            boolean bl = separator = v.charAt(pos = this.copyDigits(buffer, v, pos, 2, v)) == ':';
            if (separator) {
                ++pos;
            }
            if (!TimeFormat.isDigit(v.charAt(pos))) {
                if (separator) {
                    TimeFormat.badDateTime(original);
                }
                buffer.append("0000");
            } else {
                pos = this.copyDigits(buffer, v, pos, 2, v);
                boolean secondsShouldFollow = false;
                char c = v.charAt(pos);
                if (c == ':') {
                    if (!separator) {
                        TimeFormat.badDateTime(original);
                    }
                    secondsShouldFollow = true;
                    c = v.charAt(++pos);
                } else if (separator && TimeFormat.isDigit(c)) {
                    TimeFormat.badDateTime(original);
                }
                if (!TimeFormat.isDigit(c)) {
                    if (secondsShouldFollow) {
                        TimeFormat.badDateTime(original);
                    }
                    buffer.append("00");
                } else if (v.charAt(pos = this.copyDigits(buffer, v, pos, 2, v)) == '.') {
                    ++pos;
                    buffer.append('.');
                    pos = this.copyDigits(buffer, v, pos, 3, v);
                    millis = true;
                }
            }
        } else {
            buffer.append("000000");
        }
        if (v.charAt(pos) == '$') {
            fmt = millis ? this.formats.millisFmt : this.formats.defaultFmt;
        } else {
            String tz = v.substring(pos, v.length() - 1);
            if (tz.equals("Z")) {
                buffer.append("+0000");
            } else if (tz.length() == 3 && (tz.charAt(0) == '+' || tz.charAt(0) == '-')) {
                buffer.append(tz).append("00");
            } else if (tz.length() == 6 && (tz.charAt(0) == '+' || tz.charAt(0) == '-') && tz.charAt(3) == ':') {
                buffer.append(tz.substring(0, 3)).append(tz.substring(4, 6));
            } else {
                buffer.append(tz);
            }
            fmt = millis ? this.formats.millisTimezoneFmt : this.formats.timezoneFmt;
        }
        ParsePosition parsePos = new ParsePosition(0);
        String goodValue = buffer.toString();
        DateFormat dateFormat = fmt.get();
        Date res = dateFormat.parse(goodValue, parsePos);
        dateFormat.setTimeZone(fmt.getTimeZone());
        if (parsePos.getIndex() != goodValue.length()) {
            TimeFormat.badDateTime(original);
        }
        if (parsePos.getErrorIndex() != -1) {
            TimeFormat.badDateTime(original);
        }
        return res;
    }

    private int copyDigits(StringBuilder buffer, String v, int pos, int n, String value) {
        for (int i = 0; i < n; ++i) {
            char c = v.charAt(pos);
            if (!TimeFormat.isDigit(c)) {
                TimeFormat.badDateTime(value);
            }
            buffer.append(c);
            ++pos;
        }
        return pos;
    }

    private static boolean hasStandardDate(String v) {
        if (v.length() < 8) {
            return false;
        }
        for (int i = 0; i < 8; ++i) {
            if (TimeFormat.isDigit(v.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean hasStandardTime(String v) {
        if (v.length() < 15 || v.charAt(8) != '-') {
            return false;
        }
        for (int i = 9; i < 15; ++i) {
            if (TimeFormat.isDigit(v.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean hasStandardMillis(String v) {
        if (v.length() < 19 || v.charAt(15) != '.') {
            return false;
        }
        for (int i = 16; i < 19; ++i) {
            if (TimeFormat.isDigit(v.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean hasStandardZone(String v) {
        int n = v.length();
        if (n < 5) {
            return false;
        }
        char c = v.charAt(n - 5);
        if (c != '+' && c != '-') {
            return false;
        }
        for (int i = n - 4; i < n; ++i) {
            if (TimeFormat.isDigit(v.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static int getNum2(String v, int i) {
        return (v.charAt(i) - 48) * 10 + v.charAt(i + 1) - 48;
    }

    private static int getNum3(String v, int i) {
        return (v.charAt(i) - 48) * 100 + TimeFormat.getNum2(v, i + 1);
    }

    private static boolean longValueInMillis(String v) {
        if (v.length() < 9) {
            return false;
        }
        for (int i = 0; i < v.length(); ++i) {
            if (TimeFormat.isDigit(v.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static void badDateTime(String value) throws InvalidFormatException {
        throw new InvalidFormatException("Cannot parse date-time from string \"" + value + "\"");
    }

    private int tryParseDate(String value, StringBuilder buffer) {
        char c;
        int i;
        boolean separator;
        int pos = 0;
        StringBuilder date = new StringBuilder(8);
        for (int i2 = 0; i2 < 4; ++i2) {
            char c2;
            if (!TimeFormat.isDigit(c2 = value.charAt(pos++))) {
                return 0;
            }
            date.append(c2);
        }
        boolean bl = separator = value.charAt(pos) == '-';
        if (separator) {
            ++pos;
        }
        for (i = 0; i < 2; ++i) {
            if (!TimeFormat.isDigit(c = value.charAt(pos++))) {
                return 0;
            }
            date.append(c);
        }
        if (separator) {
            if (value.charAt(pos) != '-') {
                return 0;
            }
            ++pos;
        }
        for (i = 0; i < 2; ++i) {
            if (!TimeFormat.isDigit(c = value.charAt(pos++))) {
                return 0;
            }
            date.append(c);
        }
        buffer.append((CharSequence)date);
        return pos;
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public String format(Date time) throws NullPointerException {
        return this.format(time.getTime());
    }

    public String format(long time) {
        if (time == 0L) {
            return "0";
        }
        return this.formatFast(time);
    }

    private String formatFast(long time) {
        if (time < MIN_TIME || time > MAX_TIME) {
            return Long.toString(time);
        }
        long key = this.format.withMillis ? time : MathUtil.div(time, 1000L);
        String cached = this.format.getCachedResult(key);
        if (cached != null) {
            return cached;
        }
        long minute = MathUtil.div(time, 60000L);
        char[] cachedMinute = this.format.getCachedMinute(minute);
        if (cachedMinute != null) {
            int secondsAndMillis = (int)(time - minute * 60000L);
            char[] chars = (char[])cachedMinute.clone();
            int offset = this.format.secondsPos;
            offset = TimeFormat.putNum2(chars, offset, secondsAndMillis / 1000);
            if (this.format.withMillis) {
                TimeFormat.putNum3(chars, ++offset, secondsAndMillis % 1000);
            }
            String s = new String(chars);
            this.format.setCachedResult(key, s);
            return s;
        }
        int timeOffset = this.format.getTimeZone().getOffset(time);
        int ymd = DayUtil.getYearMonthDayByDayId((int)MathUtil.div(time + (long)timeOffset, 86400000L));
        int dayTime = (int)MathUtil.rem(time + (long)timeOffset, 86400000L);
        if (ymd < 10101 || ymd > 99991231) {
            return Long.toString(time);
        }
        char[] chars = new char[this.format.standardLength];
        int offset = 0;
        offset = TimeFormat.putNum2(chars, offset, ymd / 1000000 % 100);
        offset = TimeFormat.putNum2(chars, offset, ymd / 10000 % 100);
        if (this.format.withIso) {
            chars[offset++] = 45;
        }
        offset = TimeFormat.putNum2(chars, offset, ymd / 100 % 100);
        if (this.format.withIso) {
            chars[offset++] = 45;
        }
        offset = TimeFormat.putNum2(chars, offset, ymd % 100);
        chars[offset++] = this.format.withIso ? 84 : 45;
        offset = TimeFormat.putNum2(chars, offset, dayTime / 3600000 % 24);
        if (this.format.withIso) {
            chars[offset++] = 58;
        }
        offset = TimeFormat.putNum2(chars, offset, dayTime / 60000 % 60);
        if (this.format.withIso) {
            chars[offset++] = 58;
        }
        offset = TimeFormat.putNum2(chars, offset, dayTime / 1000 % 60);
        if (this.format.withMillis) {
            chars[offset++] = 46;
            offset = TimeFormat.putNum3(chars, offset, dayTime % 1000);
        }
        if (this.format.withZone) {
            if (this.format.withIso && timeOffset == 0) {
                chars[offset++] = 90;
            } else {
                chars[offset++] = timeOffset >= 0 ? 43 : 45;
                offset = TimeFormat.putNum2(chars, offset, Math.abs(timeOffset) / 3600000 % 24);
                if (this.format.withIso) {
                    chars[offset++] = 58;
                }
                offset = TimeFormat.putNum2(chars, offset, Math.abs(timeOffset) / 60000 % 60);
            }
        }
        String s = new String(chars, 0, offset);
        this.format.setCachedResult(key, s);
        if ((long)timeOffset % 60000L == 0L) {
            this.format.setCachedMinute(minute, chars.length == offset ? chars : Arrays.copyOf(chars, offset));
        }
        return s;
    }

    private static int putNum2(char[] chars, int offset, int v) {
        chars[offset] = (char)(48 + v / 10);
        chars[offset + 1] = (char)(48 + v % 10);
        return offset + 2;
    }

    private static int putNum3(char[] chars, int offset, int v) {
        chars[offset] = (char)(48 + v / 100);
        return TimeFormat.putNum2(chars, offset + 1, v % 100);
    }

    public TimeZone getTimeZone() {
        return (TimeZone)this.timezone.clone();
    }

    static {
        char[] dateTimeSeparators = new char[]{'-', ' ', 't', 'T'};
        Arrays.sort(dateTimeSeparators);
        DATE_TIME_SEPARATORS = dateTimeSeparators;
    }

    @ThreadSafe
    static class CacheEntry {
        private final long key;
        private final String value;

        public CacheEntry(long key, String value) {
            this.key = key;
            this.value = value;
        }

        public long getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }

    @ThreadSafe
    static class MinuteCacheEntry {
        private final long minute;
        private final char[] template;

        public MinuteCacheEntry(long minute, char[] template) {
            this.minute = minute;
            this.template = template;
        }

        public long getMinute() {
            return this.minute;
        }

        public char[] getTemplate() {
            return this.template;
        }
    }

    private static class Formats {
        private static int SECS_POS_NOISO = "yyyyMMdd-HHmm".length();
        private static int SECS_POS_ISO = "yyyy-MM-ddTHH:mm:".length();
        final Format dateFmt;
        final Format defaultFmt;
        final Format timezoneFmt;
        final Format millisFmt;
        final Format millisTimezoneFmt;
        final Format fullIsoFmt;

        Formats(TimeZone timezone) {
            this.dateFmt = new Format("yyyyMMdd", 0, -1, timezone, false, false, false);
            this.defaultFmt = new Format("yyyyMMdd-HHmmss", 0, SECS_POS_NOISO, timezone, false, false, false);
            this.timezoneFmt = new Format("yyyyMMdd-HHmmssZ", 4, SECS_POS_NOISO, timezone, false, true, false);
            this.millisFmt = new Format("yyyyMMdd-HHmmss.SSS", 0, SECS_POS_NOISO, timezone, true, false, false);
            this.millisTimezoneFmt = new Format("yyyyMMdd-HHmmss.SSSZ", 4, SECS_POS_NOISO, timezone, true, true, false);
            this.fullIsoFmt = new Format("yyyy-MM-dd'T'HH:mm:ss.SSSXXX", 1, SECS_POS_ISO, timezone, true, true, true);
        }

        void setTimeZone(TimeZone timezone) {
            this.dateFmt.setTimeZone(timezone);
            this.defaultFmt.setTimeZone(timezone);
            this.timezoneFmt.setTimeZone(timezone);
            this.millisFmt.setTimeZone(timezone);
            this.millisTimezoneFmt.setTimeZone(timezone);
            this.fullIsoFmt.setTimeZone(timezone);
        }
    }

    private static class Format {
        private static final int CACHE_SIZE = 256;
        private static final CacheEntry RESULT_STUB = new CacheEntry(Long.MIN_VALUE, null);
        private static final int MINUTES_CACHE_SIZE = 256;
        private static final MinuteCacheEntry MINUTE_STUB = new MinuteCacheEntry(Long.MIN_VALUE, null);
        final int standardLength;
        final int secondsPos;
        final ThreadLocal<DateFormat> threadLocal = new ThreadLocal();
        final DateFormat masterFormat;
        final boolean withMillis;
        final boolean withZone;
        final boolean withIso;
        final CacheEntry[] cache;
        final MinuteCacheEntry[] minutesCache;

        Format(String format, int extraLength, int secondsPos, TimeZone timezone, boolean withMillis, boolean withZone, boolean withIso) {
            this.standardLength = format.length() + extraLength;
            this.secondsPos = secondsPos;
            this.masterFormat = new SimpleDateFormat(format);
            this.masterFormat.setTimeZone(timezone);
            this.withMillis = withMillis;
            this.withZone = withZone;
            this.withIso = withIso;
            this.cache = new CacheEntry[256];
            this.minutesCache = new MinuteCacheEntry[256];
            this.clearCache();
        }

        DateFormat get() {
            DateFormat format = this.threadLocal.get();
            if (format == null) {
                format = (DateFormat)this.masterFormat.clone();
                this.threadLocal.set(format);
            }
            return format;
        }

        TimeZone getTimeZone() {
            return this.masterFormat.getTimeZone();
        }

        void setTimeZone(TimeZone timezone) {
            this.masterFormat.setTimeZone(timezone);
            this.threadLocal.set(null);
            this.clearCache();
        }

        void clearCache() {
            Arrays.fill(this.cache, RESULT_STUB);
            Arrays.fill(this.minutesCache, MINUTE_STUB);
        }

        public String getCachedResult(long key) {
            int bucket = (int)key & 0xFF;
            CacheEntry entry = this.cache[bucket];
            if (entry.getKey() == key) {
                return entry.getValue();
            }
            return null;
        }

        public void setCachedResult(long key, String value) {
            int bucket = (int)key & 0xFF;
            this.cache[bucket] = new CacheEntry(key, value);
        }

        public char[] getCachedMinute(long minute) {
            int bucket = (int)minute & 0xFF;
            MinuteCacheEntry cachedMinute = this.minutesCache[bucket];
            if (cachedMinute.getMinute() == minute) {
                return cachedMinute.getTemplate();
            }
            return null;
        }

        public void setCachedMinute(long minute, char[] template) {
            int bucket = (int)minute & 0xFF;
            this.minutesCache[bucket] = new MinuteCacheEntry(minute, template);
        }
    }
}

