/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.util;

import com.devexperts.util.LockFreePool;
import com.devexperts.util.SystemProperties;

public class ThreadLocalPool<E> {
    public static final int MAX_THREAD_LOCAL_CAPACITY = 1024;
    private final int threadLocalCapacity;
    private final ThreadLocal<Entry<E>> local = new ThreadLocal();
    private final LockFreePool<E> global;

    public ThreadLocalPool(int threadLocalCapacity, int poolCapacity) {
        if (threadLocalCapacity < 1 || threadLocalCapacity > 1024) {
            throw new IllegalArgumentException("Thread local capacity is out of range");
        }
        this.threadLocalCapacity = threadLocalCapacity;
        this.global = new LockFreePool(poolCapacity);
    }

    public ThreadLocalPool(String poolName, int defaultThreadLocalCapacity, int defaultPoolCapacity) {
        this(SystemProperties.getIntProperty(poolName + ".threadLocalCapacity", defaultThreadLocalCapacity), SystemProperties.getIntProperty(poolName + ".poolCapacity", defaultPoolCapacity));
    }

    public int size() {
        Entry<E> entry = this.local.get();
        return entry == null ? this.global.size() : this.global.size() + entry.top;
    }

    public E poll() {
        Entry<E> entry = this.local.get();
        if (entry != null && entry.top > 0) {
            return entry.pop();
        }
        return this.global.poll();
    }

    public boolean offer(E o) {
        if (o == null) {
            throw new NullPointerException();
        }
        Entry<E> entry = this.local.get();
        if (entry == null) {
            entry = new Entry(this.threadLocalCapacity);
            this.local.set(entry);
        }
        if ((o = entry.push(o)) != null) {
            this.global.offer(o);
        }
        return true;
    }

    private static class Entry<E> {
        final E[] stack;
        int top;

        Entry(int threadLocalCapacity) {
            this.stack = new Object[threadLocalCapacity];
        }

        E pop() {
            return this.stack[--this.top];
        }

        E push(E o) {
            if (this.top < this.stack.length) {
                this.stack[this.top++] = o;
                return null;
            }
            E result = this.stack[0];
            System.arraycopy(this.stack, 1, this.stack, 0, this.stack.length - 1);
            this.stack[this.stack.length - 1] = o;
            return result;
        }
    }
}

