/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.util;

import com.devexperts.logging.Logging;

public final class SystemProperties {
    private static Logging log() {
        return Logging.getLogging(SystemProperties.class);
    }

    public static String getProperty(String key, String defValue) {
        try {
            return System.getProperty(key, defValue);
        }
        catch (Throwable t) {
            SystemProperties.log().error("Failed to acquire correct value for \"" + key + "\" system property", t);
            return defValue;
        }
    }

    public static String getProperty(Class<?> c, String propName, String defValue) {
        return SystemProperties.getProperty(SystemProperties.key(c, propName), defValue);
    }

    public static int getIntProperty(String key, int defValue) {
        try {
            String propStr = System.getProperty(key);
            return propStr == null ? defValue : Integer.decode(propStr);
        }
        catch (Throwable t) {
            SystemProperties.log().error("Failed to acquire correct value for \"" + key + "\" integer system property", t);
            return defValue;
        }
    }

    public static int getIntProperty(Class<?> c, String propName, int defValue) {
        return SystemProperties.getIntProperty(SystemProperties.key(c, propName), defValue);
    }

    public static int getIntProperty(String key, int defValue, int minValue, int maxValue) {
        if (minValue > defValue || defValue > maxValue) {
            throw new IllegalArgumentException();
        }
        int result = SystemProperties.getIntProperty(key, defValue);
        if (result > maxValue) {
            SystemProperties.log().warn(result + " exceeds maximum allowed value for \"" + key + "\" integer system property; " + maxValue + " value will be used.");
            return maxValue;
        }
        if (result < minValue) {
            SystemProperties.log().warn(result + " is less than minimum allowed value for \"" + key + "\" integer system property; " + minValue + " value will be used.");
            return minValue;
        }
        return result;
    }

    public static int getIntProperty(Class<?> c, String propName, int defValue, int minValue, int maxValue) {
        return SystemProperties.getIntProperty(SystemProperties.key(c, propName), defValue, minValue, maxValue);
    }

    public static long getLongProperty(String key, long defValue) {
        try {
            String propStr = System.getProperty(key);
            return propStr == null ? defValue : Long.decode(propStr);
        }
        catch (Throwable t) {
            SystemProperties.log().error("Failed to acquire correct value for \"" + key + "\" long system property", t);
            return defValue;
        }
    }

    public static long getLongProperty(Class<?> c, String propName, long defValue) {
        return SystemProperties.getLongProperty(SystemProperties.key(c, propName), defValue);
    }

    public static long getLongProperty(String key, long defValue, long minValue, long maxValue) {
        if (minValue > defValue || defValue > maxValue) {
            throw new IllegalArgumentException();
        }
        long result = SystemProperties.getLongProperty(key, defValue);
        if (result > maxValue) {
            SystemProperties.log().warn(result + " exceeds maximum allowed value for \"" + key + "\" long system property; " + maxValue + " value will be used.");
            return maxValue;
        }
        if (result < minValue) {
            SystemProperties.log().warn(result + " is less than minimum allowed value for \"" + key + "\" long system property; " + minValue + " value will be used.");
            return minValue;
        }
        return result;
    }

    public static long getLongProperty(Class<?> c, String propName, long defValue, long minValue, long maxValue) {
        return SystemProperties.getLongProperty(SystemProperties.key(c, propName), defValue, minValue, maxValue);
    }

    public static boolean getBooleanProperty(String key, boolean defValue) {
        try {
            String propStr = System.getProperty(key);
            return propStr == null ? defValue : SystemProperties.parseBooleanValue(propStr);
        }
        catch (Throwable t) {
            SystemProperties.log().error("Failed to acquire correct value for \"" + key + "\" boolean system property", t);
            return defValue;
        }
    }

    public static boolean getBooleanProperty(Class<?> c, String propName, boolean defValue) {
        return SystemProperties.getBooleanProperty(SystemProperties.key(c, propName), defValue);
    }

    public static boolean parseBooleanValue(String value) throws IllegalArgumentException {
        if (value.equalsIgnoreCase("") || value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        throw new IllegalArgumentException(value + " is not a valid boolean value");
    }

    private static String key(Class<?> c, String propName) {
        return c.getName() + "." + propName;
    }

    private SystemProperties() {
    }
}

