/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.util;

public class StringCache {
    private final int bucketNumber;
    private final int bucketSize;
    private final String[] cache;
    private long requestCount;
    private long compareCount;
    private long missCount;

    public StringCache() {
        this(997, 4);
    }

    public StringCache(int size) {
        this((size + 3) / 4, 4);
    }

    public StringCache(int bucketNumber, int bucketSize) {
        if (bucketNumber <= 0 || bucketSize <= 0 || bucketSize >= 0x3FFFFFFF / bucketNumber) {
            throw new IllegalArgumentException();
        }
        this.bucketNumber = bucketNumber;
        this.bucketSize = bucketSize;
        this.cache = new String[bucketNumber * bucketSize];
    }

    public String get(String s) {
        return this.get(s, false);
    }

    public String get(String s, boolean copy) {
        if (s == null) {
            return null;
        }
        if (s.isEmpty()) {
            return "";
        }
        ++this.requestCount;
        int hash = s.hashCode();
        int n = Math.abs(hash % this.bucketNumber) * this.bucketSize;
        String cached = this.cache[n];
        if (StringCache.eq(cached, s, hash)) {
            return cached;
        }
        for (int k = 1; k < this.bucketSize; ++k) {
            cached = this.cache[n + k];
            if (!StringCache.eq(cached, s, hash)) continue;
            return this.finish(cached, n, k);
        }
        ++this.missCount;
        return this.finish(copy ? new String(s) : s, n, this.bucketSize - 1);
    }

    public String get(String s, int offset, int length) {
        if (length == 0) {
            return "";
        }
        if (offset == 0 && length == s.length()) {
            return this.get(s, false);
        }
        ++this.requestCount;
        int hash = 0;
        for (int i = 0; i < length; ++i) {
            hash = 31 * hash + s.charAt(offset + i);
        }
        int n = Math.abs(hash % this.bucketNumber) * this.bucketSize;
        String cached = this.cache[n];
        if (StringCache.eq(cached, s, offset, length, hash)) {
            return cached;
        }
        for (int k = 1; k < this.bucketSize; ++k) {
            cached = this.cache[n + k];
            if (!StringCache.eq(cached, s, offset, length, hash)) continue;
            return this.finish(cached, n, k);
        }
        ++this.missCount;
        return this.finish(s.substring(offset, offset + length), n, this.bucketSize - 1);
    }

    public String get(CharSequence cs) {
        if (cs instanceof String) {
            return this.get((String)cs, false);
        }
        if (cs == null) {
            return null;
        }
        int length = cs.length();
        if (length == 0) {
            return "";
        }
        ++this.requestCount;
        int hash = 0;
        for (int i = 0; i < length; ++i) {
            hash = 31 * hash + cs.charAt(i);
        }
        int n = Math.abs(hash % this.bucketNumber) * this.bucketSize;
        String cached = this.cache[n];
        if (StringCache.eq(cached, cs, hash)) {
            return cached;
        }
        for (int k = 1; k < this.bucketSize; ++k) {
            cached = this.cache[n + k];
            if (!StringCache.eq(cached, cs, hash)) continue;
            return this.finish(cached, n, k);
        }
        ++this.missCount;
        return this.finish(cs.toString(), n, this.bucketSize - 1);
    }

    public String get(CharSequence cs, int offset, int length) {
        if (length == 0) {
            return "";
        }
        if (offset == 0 && length == cs.length()) {
            return this.get(cs);
        }
        ++this.requestCount;
        int hash = 0;
        for (int i = 0; i < length; ++i) {
            hash = 31 * hash + cs.charAt(offset + i);
        }
        int n = Math.abs(hash % this.bucketNumber) * this.bucketSize;
        String cached = this.cache[n];
        if (StringCache.eq(cached, cs, offset, length, hash)) {
            return cached;
        }
        for (int k = 1; k < this.bucketSize; ++k) {
            cached = this.cache[n + k];
            if (!StringCache.eq(cached, cs, offset, length, hash)) continue;
            return this.finish(cached, n, k);
        }
        ++this.missCount;
        return this.finish(cs.subSequence(offset, offset + length).toString(), n, this.bucketSize - 1);
    }

    public String get(char[] c) {
        if (c == null) {
            return null;
        }
        return this.get(c, 0, c.length);
    }

    public String get(char[] c, int offset, int length) {
        if (length == 0) {
            return "";
        }
        ++this.requestCount;
        int hash = 0;
        for (int i = 0; i < length; ++i) {
            hash = 31 * hash + c[offset + i];
        }
        int n = Math.abs(hash % this.bucketNumber) * this.bucketSize;
        String cached = this.cache[n];
        if (StringCache.eq(cached, c, offset, length, hash)) {
            return cached;
        }
        for (int k = 1; k < this.bucketSize; ++k) {
            cached = this.cache[n + k];
            if (!StringCache.eq(cached, c, offset, length, hash)) continue;
            return this.finish(cached, n, k);
        }
        ++this.missCount;
        return this.finish(new String(c, offset, length), n, this.bucketSize - 1);
    }

    public String getASCII(byte[] b) {
        if (b == null) {
            return null;
        }
        return this.getASCII(b, 0, b.length);
    }

    public String getASCII(byte[] b, int offset, int length) {
        if (length == 0) {
            return "";
        }
        ++this.requestCount;
        int hash = 0;
        for (int i = 0; i < length; ++i) {
            hash = 31 * hash + (b[offset + i] & 0x7F);
        }
        int n = Math.abs(hash % this.bucketNumber) * this.bucketSize;
        String cached = this.cache[n];
        if (StringCache.eqASCII(cached, b, offset, length, hash)) {
            return cached;
        }
        for (int k = 1; k < this.bucketSize; ++k) {
            cached = this.cache[n + k];
            if (!StringCache.eqASCII(cached, b, offset, length, hash)) continue;
            return this.finish(cached, n, k);
        }
        ++this.missCount;
        char[] c = new char[length];
        for (int i = 0; i < length; ++i) {
            c[i] = (char)(b[offset + i] & 0x7F);
        }
        return this.finish(new String(c), n, this.bucketSize - 1);
    }

    public String getShortString(long code) {
        if (code == 0L) {
            return null;
        }
        ++this.requestCount;
        long reverse = 0L;
        int length = 0;
        do {
            byte c;
            if ((c = (byte)code) == 0) continue;
            reverse = reverse << 8 | (long)(c & 0xFF);
            ++length;
        } while ((code >>>= 8) != 0L);
        int hash = 0;
        for (int i = 0; i < length; ++i) {
            hash = 31 * hash + ((int)(reverse >>> (i << 3)) & 0xFF);
        }
        int n = Math.abs(hash % this.bucketNumber) * this.bucketSize;
        String cached = this.cache[n];
        if (StringCache.eqShortString(cached, reverse, length, hash)) {
            return cached;
        }
        for (int k = 1; k < this.bucketSize; ++k) {
            cached = this.cache[n + k];
            if (!StringCache.eqShortString(cached, reverse, length, hash)) continue;
            return this.finish(cached, n, k);
        }
        ++this.missCount;
        char[] c = new char[length];
        for (int i = 0; i < length; ++i) {
            c[i] = (char)((int)(reverse >>> (i << 3)) & 0xFF);
        }
        return this.finish(new String(c, 0, length), n, this.bucketSize - 1);
    }

    public String toString() {
        long rc = this.requestCount;
        return "StringCache(" + this.bucketNumber + "x" + this.bucketSize + ", " + rc + " requests, " + (double)(Math.max(rc - this.missCount, 0L) * 10000L / Math.max(rc, 1L)) / 100.0 + "% hits, " + (rc + this.compareCount) * 100L / Math.max(rc, 1L) + "% compares)";
    }

    private String finish(String cached, int n, int k) {
        this.compareCount += (long)k;
        while (k > 0) {
            this.cache[n + k] = this.cache[n + --k];
        }
        this.cache[n] = cached;
        return this.cache[n];
    }

    private static boolean eq(String cached, String s, int hash) {
        if (cached == null || cached.hashCode() != hash) {
            return false;
        }
        return cached.equals(s);
    }

    private static boolean eq(String cached, String s, int offset, int length, int hash) {
        if (cached == null || cached.hashCode() != hash || cached.length() != length) {
            return false;
        }
        return cached.regionMatches(0, s, offset, length);
    }

    private static boolean eq(String cached, CharSequence cs, int hash) {
        if (cached == null || cached.hashCode() != hash) {
            return false;
        }
        return cached.contentEquals(cs);
    }

    private static boolean eq(String cached, CharSequence cs, int offset, int length, int hash) {
        if (cached == null || cached.hashCode() != hash || cached.length() != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (cached.charAt(i) == cs.charAt(offset + i)) continue;
            return false;
        }
        return true;
    }

    private static boolean eq(String cached, char[] c, int offset, int length, int hash) {
        if (cached == null || cached.hashCode() != hash || cached.length() != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (cached.charAt(i) == c[offset + i]) continue;
            return false;
        }
        return true;
    }

    private static boolean eqASCII(String cached, byte[] b, int offset, int length, int hash) {
        if (cached == null || cached.hashCode() != hash || cached.length() != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (cached.charAt(i) == (b[offset + i] & 0x7F)) continue;
            return false;
        }
        return true;
    }

    private static boolean eqShortString(String cached, long reverse, int length, int hash) {
        if (cached == null || cached.hashCode() != hash || cached.length() != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (cached.charAt(i) == ((int)(reverse >>> (i << 3)) & 0xFF)) continue;
            return false;
        }
        return true;
    }
}

