/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.util;

public class MathUtil {
    private static final int MAX_DECIMAL_DIGITS = 14;
    private static final long[] POW10 = new long[15];

    private MathUtil() {
    }

    public static double roundDecimal(double x) {
        int pow;
        if (Double.isNaN(x) || x == Math.floor(x)) {
            return x;
        }
        double signum = Math.signum(x);
        double abs = Math.abs(x);
        for (int i = pow = Math.min(14, 13 - (int)Math.floor(Math.log10(abs))); i >= 0; --i) {
            long mantissa = (long)((double)POW10[i] * abs + 0.5);
            if (mantissa >= POW10[14]) continue;
            return signum * (double)mantissa / (double)POW10[i];
        }
        return Math.round(x);
    }

    public static int div(int a, int b) {
        return a >= 0 ? a / b : (b >= 0 ? (a + 1) / b - 1 : (a + 1) / b + 1);
    }

    public static long div(long a, long b) {
        return a >= 0L ? a / b : (b >= 0L ? (a + 1L) / b - 1L : (a + 1L) / b + 1L);
    }

    public static int rem(int a, int b) {
        int r = a % b;
        return r >= 0 ? r : (b >= 0 ? r + b : r - b);
    }

    public static long rem(long a, long b) {
        long r = a % b;
        return r >= 0L ? r : (b >= 0L ? r + b : r - b);
    }

    static {
        MathUtil.POW10[0] = 1L;
        for (int i = 1; i < POW10.length; ++i) {
            MathUtil.POW10[i] = POW10[i - 1] * 10L;
        }
    }
}

