/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.util;

import com.devexperts.util.LongSet;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;

public interface LongMap<V>
extends Map<Long, V> {
    public boolean containsKey(long var1);

    public V get(long var1);

    @Override
    public V put(long var1, V var3);

    public V remove(long var1);

    public LongSet longKeySet();

    default public V getOrDefault(long key, V defaultValue) {
        V v = this.get(key);
        return v != null || this.containsKey(key) ? v : defaultValue;
    }

    @Override
    default public V putIfAbsent(long key, V value) {
        V result = this.get(key);
        if (result == null) {
            result = this.put(key, value);
        }
        return result;
    }

    @Override
    default public boolean replace(long key, V oldValue, V newValue) {
        V curValue = this.get(key);
        if (!Objects.equals(curValue, oldValue) || curValue == null && !this.containsKey(key)) {
            return false;
        }
        this.put(key, newValue);
        return true;
    }

    @Override
    default public V replace(long key, V value) {
        V curValue = this.get(key);
        if (curValue != null || this.containsKey(key)) {
            curValue = this.put(key, value);
        }
        return curValue;
    }

    @Override
    default public V computeIfAbsent(long key, Function<? super Long, ? extends V> mappingFunction) {
        V newValue;
        Objects.requireNonNull(mappingFunction);
        V v = this.get(key);
        if (v == null && (newValue = mappingFunction.apply(key)) != null) {
            this.put(key, newValue);
            return newValue;
        }
        return v;
    }

    @Override
    default public V computeIfPresent(long key, BiFunction<? super Long, ? super V, ? extends V> remappingFunction) {
        Objects.requireNonNull(remappingFunction);
        V oldValue = this.get(key);
        if (oldValue != null) {
            V newValue = remappingFunction.apply(key, oldValue);
            if (newValue != null) {
                this.put(key, newValue);
                return newValue;
            }
            this.remove(key);
            return null;
        }
        return null;
    }

    @Override
    default public V compute(long key, BiFunction<? super Long, ? super V, ? extends V> remappingFunction) {
        Objects.requireNonNull(remappingFunction);
        V oldValue = this.get(key);
        V newValue = remappingFunction.apply(key, oldValue);
        if (newValue == null) {
            if (oldValue != null || this.containsKey(key)) {
                this.remove(key);
                return null;
            }
            return null;
        }
        this.put(key, newValue);
        return newValue;
    }

    @Override
    default public V merge(long key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        V newValue;
        Objects.requireNonNull(remappingFunction);
        Objects.requireNonNull(value);
        V oldValue = this.get(key);
        V v = newValue = oldValue == null ? value : remappingFunction.apply(oldValue, value);
        if (newValue == null) {
            this.remove(key);
        } else {
            this.put(key, newValue);
        }
        return newValue;
    }

    default public boolean remove(long key, Object value) {
        V curValue = this.get(key);
        if (!Objects.equals(curValue, value) || curValue == null && !this.containsKey(key)) {
            return false;
        }
        this.remove(key);
        return true;
    }

    public static interface Entry<V>
    extends Map.Entry<Long, V> {
        public long getLongKey();
    }
}

