/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.util;

import com.devexperts.util.AbstractLongSet;
import com.devexperts.util.LongHashMap;
import com.devexperts.util.LongIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.PrimitiveIterator;

public final class LongHashSet
extends AbstractLongSet
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -1317101846278749919L;
    private transient LongHashMap<?> map;

    public LongHashSet() {
        this.map = new LongHashMap();
    }

    public LongHashSet(Collection<? extends Long> c) {
        this.map = new LongHashMap(c.size());
        this.addAll(c);
    }

    public LongHashSet(int capacity) {
        this.map = new LongHashMap(capacity);
    }

    LongHashSet(LongHashMap map) {
        this.map = map;
    }

    @Override
    public LongIterator longIterator() {
        return (LongIterator)this.map.newKeySetIterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(long key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean add(long key) {
        return this.map.putExplicitly(key, null) == LongHashMap.NOT_FOUND;
    }

    @Override
    public boolean remove(long key) {
        return this.map.removeExplicitly(key, null, false) != LongHashMap.NOT_FOUND;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public Object clone() {
        try {
            LongHashSet new_set = (LongHashSet)super.clone();
            new_set.map = (LongHashMap)this.map.clone();
            return new_set;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public void ensureCapacity(int capacity) {
        this.map.ensureCapacity(capacity);
    }

    public void compact() {
        this.map.compact();
    }

    public void compact(int capacity) {
        this.map.compact(capacity);
    }

    public void clearAndCompact() {
        this.map.clearAndCompact();
    }

    public void clearAndCompact(int capacity) {
        this.map.clearAndCompact(capacity);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeInt(this.map.size());
        PrimitiveIterator.OfLong it = this.map.newKeySetIterator();
        while (it.hasNext()) {
            s.writeLong(it.nextLong());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException {
        int size = s.readInt();
        this.map = new LongHashMap(size);
        for (int i = 0; i < size; ++i) {
            this.map.put(s.readLong(), null);
        }
    }
}

