/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.util;

import com.devexperts.util.AbstractLongMap;
import com.devexperts.util.LongHashSet;
import com.devexperts.util.LongIterator;
import com.devexperts.util.LongMap;
import com.devexperts.util.LongSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import java.util.Set;

public final class LongHashMap<V>
extends AbstractLongMap<V>
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -6950829448098599560L;
    private static final long MAGIC = 7046029254386354333L;
    private static final int INITIAL_POWER = 3;
    static final int INITIAL_LENGTH = 8;
    private static final int INITIAL_SHIFT = 61;
    public static final int MAX_CAPACITY = 0x2AAAAAAA;
    private transient int count;
    private transient int threshold;
    private transient long first_key;
    private transient V first_val;
    private transient long[] table;
    private transient V[] table_val;
    private transient int shift;
    private transient int mod_count;
    static final Object NOT_FOUND = new Object();
    private volatile transient LongSet key_set;
    private transient Collection<V> values;
    private transient Set<Map.Entry<Long, V>> entry_set;

    public LongHashMap() {
    }

    public LongHashMap(Map<? extends Long, ? extends V> m) {
        this.ensureCapacity(m.size());
        this.putAll((Map<? extends Long, ? extends V>)m);
    }

    public LongHashMap(int capacity) {
        this.ensureCapacity(capacity);
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public void clear() {
        if (this.count > 1) {
            int h = this.table.length;
            while (--h >= 0) {
                this.table[h] = 0L;
            }
            this.table_val = null;
        }
        if (this.count > 0) {
            this.first_val = null;
            this.count = 0;
            ++this.mod_count;
        }
    }

    @Override
    public void putAll(Map<? extends Long, ? extends V> t) {
        if (t instanceof LongHashMap) {
            LongHashMap lhm = (LongHashMap)t;
            if (lhm.count == 0) {
                return;
            }
            this.put(lhm.first_key, lhm.first_val);
            long[] lhm_table = lhm.table;
            if (lhm_table == null) {
                return;
            }
            V[] lhm_table_val = lhm.table_val;
            if (lhm_table_val == null) {
                int i = lhm_table.length;
                while (--i >= 0) {
                    if (lhm_table[i] == 0L) continue;
                    this.put(lhm_table[i], (V)null);
                }
            } else {
                int i = lhm_table.length;
                while (--i >= 0) {
                    if (lhm_table[i] == 0L) continue;
                    this.put(lhm_table[i], lhm_table_val[i]);
                }
            }
        } else {
            super.putAll(t);
        }
    }

    @Override
    public boolean containsKey(long key) {
        long k;
        if (this.count == 0) {
            return false;
        }
        if (key == this.first_key) {
            return true;
        }
        if (this.count == 1) {
            return false;
        }
        int h = (int)(key * 7046029254386354333L >>> this.shift);
        while ((k = this.table[h]) != 0L) {
            if (k == key) {
                return true;
            }
            if (h == 0) {
                h = this.table.length;
            }
            --h;
        }
        return false;
    }

    @Override
    public V get(long key) {
        V result = this.getExplicitly(key);
        return result == NOT_FOUND ? null : (V)result;
    }

    @Override
    public V put(long key, V value) {
        V result = this.putExplicitly(key, value);
        return result == NOT_FOUND ? null : (V)result;
    }

    @Override
    public V remove(long key) {
        V result = this.removeExplicitly(key, null, false);
        return result == NOT_FOUND ? null : (V)result;
    }

    @Override
    public V getOrDefault(long key, V defaultValue) {
        V result = this.getExplicitly(key);
        return result == NOT_FOUND ? defaultValue : result;
    }

    @Override
    public boolean remove(long key, Object value) {
        return this.removeExplicitly(key, value, true) != NOT_FOUND;
    }

    private V notFound() {
        return (V)NOT_FOUND;
    }

    V getExplicitly(long key) {
        long k;
        if (this.count == 0) {
            return this.notFound();
        }
        if (key == this.first_key) {
            return this.first_val;
        }
        if (this.count == 1) {
            return this.notFound();
        }
        int h = (int)(key * 7046029254386354333L >>> this.shift);
        while ((k = this.table[h]) != 0L) {
            if (k == key) {
                return this.table_val == null ? null : (V)this.table_val[h];
            }
            if (h == 0) {
                h = this.table.length;
            }
            --h;
        }
        return this.notFound();
    }

    V putExplicitly(long key, V value) {
        long k;
        boolean inserting_zero;
        if (this.count == 0) {
            this.first_key = key;
            this.first_val = value;
            ++this.count;
            ++this.mod_count;
            return this.notFound();
        }
        if (key == this.first_key) {
            V old_val = this.first_val;
            this.first_val = value;
            return old_val;
        }
        if (this.table == null) {
            this.table = new long[8];
            this.shift = 61;
            this.threshold = 5;
        }
        boolean bl = inserting_zero = key == 0L;
        if (inserting_zero) {
            key = this.first_key;
            this.first_key = 0L;
            V t_val = this.first_val;
            this.first_val = value;
            value = t_val;
        }
        int h = (int)(key * 7046029254386354333L >>> this.shift);
        while ((k = this.table[h]) != 0L) {
            if (k == key) {
                V old_val = this.putValueAt(h, value);
                return inserting_zero ? this.notFound() : old_val;
            }
            if (h == 0) {
                h = this.table.length;
            }
            --h;
        }
        this.table[h] = key;
        this.putValueAt(h, value);
        ++this.count;
        if (this.count > this.threshold) {
            --this.shift;
            this.rehashHelper(this.table.length << 1);
        } else {
            ++this.mod_count;
        }
        return this.notFound();
    }

    private V putValueAt(int index, V value) {
        V old_val;
        if (this.table_val == null) {
            old_val = null;
            if (value != null) {
                this.table_val = new Object[this.table.length];
                this.table_val[index] = value;
            }
        } else {
            old_val = this.table_val[index];
            this.table_val[index] = value;
        }
        return old_val;
    }

    V removeExplicitly(long key, Object value, boolean matchValue) {
        long k;
        if (this.count == 0) {
            return this.notFound();
        }
        if (key == this.first_key) {
            V old_val = this.first_val;
            if (!matchValue || old_val == value || old_val != null && old_val.equals(value)) {
                this.removeFirstKey();
                return old_val;
            }
            return this.notFound();
        }
        if (this.table == null) {
            return this.notFound();
        }
        int h = (int)(key * 7046029254386354333L >>> this.shift);
        while ((k = this.table[h]) != 0L) {
            if (k == key) {
                Object old_val;
                Object object = old_val = this.table_val == null ? null : (Object)this.table_val[h];
                if (!matchValue || old_val == value || old_val != null && old_val.equals(value)) {
                    this.removeByIndex(h);
                    return (V)old_val;
                }
                return this.notFound();
            }
            if (h == 0) {
                h = this.table.length;
            }
            --h;
        }
        return this.notFound();
    }

    private void removeFirstKey() {
        --this.count;
        ++this.mod_count;
        if (this.count == 0) {
            this.first_val = null;
            return;
        }
        int h = (int)(this.first_key * 7046029254386354333L >>> this.shift);
        while (this.table[h] == 0L) {
            if (h == 0) {
                h = this.table.length;
            }
            --h;
        }
        while (this.table[h] != 0L) {
            if (h == 0) {
                h = this.table.length;
            }
            --h;
        }
        if (++h == this.table.length) {
            h = 0;
        }
        this.first_key = this.table[h];
        this.table[h] = 0L;
        if (this.table_val != null) {
            this.first_val = this.table_val[h];
            this.table_val[h] = null;
        } else {
            this.first_val = null;
        }
    }

    private void removeByIndex(int index) {
        --this.count;
        ++this.mod_count;
        int i = index;
        while (true) {
            int hh;
            long k;
            if (i == 0) {
                i = this.table.length;
            }
            if ((k = this.table[--i]) == 0L) {
                this.table[index] = 0L;
                if (this.table_val != null) {
                    this.table_val[index] = null;
                }
                return;
            }
            for (hh = (int)(k * 7046029254386354333L >>> this.shift); hh != index && hh != i; --hh) {
                if (hh != 0) continue;
                hh = this.table.length;
            }
            if (hh != index) continue;
            this.table[index] = k;
            if (this.table_val != null) {
                this.table_val[index] = this.table_val[i];
            }
            index = i;
        }
    }

    @Override
    public LongSet longKeySet() {
        LongSet ks = this.key_set;
        if (ks == null) {
            this.key_set = ks = new LongHashSet(this);
        }
        return ks;
    }

    @Override
    public Collection<V> values() {
        AbstractCollection vals = this.values;
        if (vals == null) {
            this.values = vals = new AbstractCollection<V>(){

                @Override
                public int size() {
                    return LongHashMap.this.count;
                }

                @Override
                public boolean isEmpty() {
                    return LongHashMap.this.count == 0;
                }

                @Override
                public void clear() {
                    LongHashMap.this.clear();
                }

                @Override
                public Iterator<V> iterator() {
                    return new ValuesIterator();
                }
            };
        }
        return vals;
    }

    @Override
    public Set<Map.Entry<Long, V>> entrySet() {
        AbstractSet es = this.entry_set;
        if (es == null) {
            this.entry_set = es = new AbstractSet<Map.Entry<Long, V>>(){

                @Override
                public int size() {
                    return LongHashMap.this.count;
                }

                @Override
                public boolean isEmpty() {
                    return LongHashMap.this.count == 0;
                }

                @Override
                public void clear() {
                    LongHashMap.this.clear();
                }

                @Override
                public boolean contains(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)o;
                    long key = entry instanceof LongMap.Entry ? ((LongMap.Entry)entry).getLongKey() : ((Long)entry.getKey()).longValue();
                    Object val = LongHashMap.this.getExplicitly(key);
                    Object e_val = entry.getValue();
                    return val == e_val || val != null && val.equals(e_val);
                }

                @Override
                public boolean remove(Object o) {
                    Object e_val;
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)o;
                    long key = entry instanceof LongMap.Entry ? ((LongMap.Entry)entry).getLongKey() : ((Long)entry.getKey()).longValue();
                    Object val = LongHashMap.this.getExplicitly(key);
                    if (val == (e_val = entry.getValue()) || val != null && val.equals(e_val)) {
                        LongHashMap.this.remove(key);
                        return true;
                    }
                    return false;
                }

                @Override
                public Iterator<Map.Entry<Long, V>> iterator() {
                    return new EntrySetIterator();
                }
            };
        }
        return es;
    }

    private void rehash(int new_power) {
        int new_length = 1 << new_power;
        if (this.table != null && this.table.length == new_length) {
            return;
        }
        this.shift = 64 - new_power;
        this.rehashHelper(new_length);
    }

    private void rehashHelper(int new_length) {
        this.threshold = (new_length << 1) / 3;
        ++this.mod_count;
        if (this.count <= 1) {
            this.table = new long[new_length];
            this.table_val = null;
        } else {
            long[] t = new long[new_length];
            Object[] tv = null;
            int i = this.table.length;
            while (--i >= 0) {
                long k = this.table[i];
                if (k == 0L) continue;
                int h = (int)(k * 7046029254386354333L >>> this.shift);
                while (t[h] != 0L) {
                    if (h == 0) {
                        h = t.length;
                    }
                    --h;
                }
                t[h] = k;
                if (this.table_val == null || this.table_val[i] == null) continue;
                if (tv == null) {
                    tv = new Object[new_length];
                }
                tv[h] = this.table_val[i];
            }
            this.table = t;
            this.table_val = tv;
        }
    }

    private static int getPower(int capacity) {
        int power = 3;
        for (capacity = capacity * 3 >> 4; capacity != 0; capacity >>= 1) {
            ++power;
        }
        return power;
    }

    public void ensureCapacity(int capacity) {
        if (capacity > 0x2AAAAAAA) {
            throw new IllegalArgumentException("Invalid capacity");
        }
        if (capacity <= this.threshold) {
            return;
        }
        this.rehash(LongHashMap.getPower(capacity));
    }

    public void compact() {
        if (this.count <= 1) {
            ++this.mod_count;
            this.table = null;
            this.table_val = null;
            this.threshold = 0;
        } else {
            this.rehash(LongHashMap.getPower(this.count));
        }
    }

    public void compact(int capacity) {
        if (capacity <= 1 || capacity <= this.count) {
            this.compact();
            return;
        }
        if (capacity > 0x2AAAAAAA) {
            throw new IllegalArgumentException("Invalid capacity");
        }
        this.rehash(LongHashMap.getPower(capacity));
    }

    public void clearAndCompact() {
        if (this.count > 0 || this.table != null) {
            this.count = 0;
            ++this.mod_count;
            this.first_val = null;
            this.table = null;
            this.table_val = null;
            this.threshold = 0;
        }
    }

    public void clearAndCompact(int capacity) {
        if (capacity <= 1) {
            this.clearAndCompact();
            return;
        }
        if (capacity > 0x2AAAAAAA) {
            throw new IllegalArgumentException("Invalid capacity");
        }
        int new_power = LongHashMap.getPower(capacity);
        int new_length = 1 << new_power;
        if (this.table != null && this.table.length == new_length) {
            this.clear();
            return;
        }
        this.count = 0;
        ++this.mod_count;
        this.first_val = null;
        this.table = new long[new_length];
        this.table_val = null;
        this.shift = 64 - new_power;
        this.threshold = (new_length << 1) / 3;
    }

    @Override
    public Object clone() {
        try {
            LongHashMap m = (LongHashMap)super.clone();
            if (this.table != null) {
                m.table = (long[])this.table.clone();
            }
            if (this.table_val != null) {
                m.table_val = (Object[])this.table_val.clone();
            }
            m.key_set = null;
            m.values = null;
            m.entry_set = null;
            m.mod_count = 0;
            return m;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeInt(this.count);
        if (this.count == 0) {
            return;
        }
        s.writeLong(this.first_key);
        s.writeObject(this.first_val);
        if (this.count == 1) {
            return;
        }
        int h = this.table.length;
        while (--h >= 0) {
            long k = this.table[h];
            if (k == 0L) continue;
            s.writeLong(k);
            s.writeObject(this.table_val == null ? null : this.table_val[h]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        int cnt = s.readInt();
        if (cnt == 0) {
            return;
        }
        this.first_key = s.readLong();
        this.first_val = s.readObject();
        this.count = 1;
        if (cnt == 1) {
            return;
        }
        this.ensureCapacity(cnt);
        for (int i = 1; i < cnt; ++i) {
            this.put(s.readLong(), (V)s.readObject());
        }
    }

    PrimitiveIterator.OfLong newKeySetIterator() {
        return new KeySetIterator();
    }

    private final class IndexEntry
    extends AbstractEntry {
        private final int index;

        IndexEntry(int index) {
            super(LongHashMap.this.table[index]);
            this.index = index;
        }

        @Override
        public V getValue() {
            if (LongHashMap.this.mod_count != this.expected_mod_count) {
                throw new ConcurrentModificationException();
            }
            return LongHashMap.this.table_val == null ? null : LongHashMap.this.table_val[this.index];
        }

        @Override
        public V setValue(V value) {
            if (LongHashMap.this.mod_count != this.expected_mod_count) {
                throw new ConcurrentModificationException();
            }
            return LongHashMap.this.putValueAt(this.index, value);
        }
    }

    private final class FirstKeyEntry
    extends AbstractEntry {
        FirstKeyEntry() {
            super(LongHashMap.this.first_key);
        }

        @Override
        public V getValue() {
            if (LongHashMap.this.mod_count != this.expected_mod_count) {
                throw new ConcurrentModificationException();
            }
            return LongHashMap.this.first_val;
        }

        @Override
        public V setValue(V value) {
            if (LongHashMap.this.mod_count != this.expected_mod_count) {
                throw new ConcurrentModificationException();
            }
            Object old_val = LongHashMap.this.first_val;
            LongHashMap.this.first_val = value;
            return old_val;
        }
    }

    private abstract class AbstractEntry
    implements LongMap.Entry<V> {
        protected final int expected_mod_count;
        protected final long key;

        protected AbstractEntry(long key) {
            this.expected_mod_count = LongHashMap.this.mod_count;
            this.key = key;
        }

        @Override
        public long getLongKey() {
            return this.key;
        }

        @Override
        public Long getKey() {
            return this.key;
        }

        @Override
        public abstract V getValue();

        @Override
        public abstract V setValue(V var1);

        @Override
        public boolean equals(Object o) {
            Object value;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            if (e instanceof LongMap.Entry) {
                if (((LongMap.Entry)e).getLongKey() != this.key) {
                    return false;
                }
            } else {
                Object e_key = e.getKey();
                if (!(e_key instanceof Long)) {
                    return false;
                }
                if ((Long)e_key != this.key) {
                    return false;
                }
            }
            return (value = this.getValue()) == null ? e.getValue() == null : value.equals(e.getValue());
        }

        @Override
        public int hashCode() {
            Object value = this.getValue();
            int hash = (int)(this.key ^ this.key >> 32);
            return hash ^ (value == null ? 0 : value.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.getValue();
        }
    }

    private final class EntrySetIterator
    extends AbstractIterator<Map.Entry<Long, V>> {
        EntrySetIterator() {
        }

        @Override
        public Map.Entry<Long, V> next() {
            this.nextIndex();
            return this.last_returned >= 0 ? new IndexEntry(this.last_returned) : new FirstKeyEntry();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<V> {
        ValuesIterator() {
        }

        @Override
        public V next() {
            this.nextIndex();
            return this.last_returned >= 0 ? (LongHashMap.this.table_val == null ? null : LongHashMap.this.table_val[this.last_returned]) : LongHashMap.this.first_val;
        }
    }

    private final class KeySetIterator
    extends AbstractIterator<Long>
    implements LongIterator {
        KeySetIterator() {
        }

        @Override
        public long nextLong() throws NoSuchElementException {
            this.nextIndex();
            return this.last_returned >= 0 ? this.table[this.last_returned] : LongHashMap.this.first_key;
        }

        @Override
        public Long next() {
            return this.nextLong();
        }
    }

    private abstract class AbstractIterator<T>
    implements Iterator<T> {
        protected long[] table;
        private int last_index;
        private int index;
        protected int last_returned;
        private int expected_mod_count;

        protected AbstractIterator() {
            this.table = LongHashMap.this.table;
            this.index = -1;
            this.last_returned = -1;
            this.expected_mod_count = LongHashMap.this.mod_count;
        }

        @Override
        public boolean hasNext() {
            if (this.index == -1) {
                return LongHashMap.this.count > 0;
            }
            return this.index != -2;
        }

        public void nextIndex() throws NoSuchElementException {
            if (LongHashMap.this.mod_count != this.expected_mod_count) {
                throw new ConcurrentModificationException();
            }
            if (LongHashMap.this.count == 0 || this.index == -2) {
                throw new NoSuchElementException();
            }
            if (LongHashMap.this.count == 1) {
                this.last_returned = -2;
                this.index = -2;
                return;
            }
            if (this.index == -1) {
                while (this.table[this.last_index] != 0L) {
                    ++this.last_index;
                }
                this.index = this.last_index + 1;
            }
            while (this.table[this.index] == 0L && this.index != this.last_index) {
                ++this.index;
                if (this.index < this.table.length) continue;
                this.index = 0;
            }
            if (this.index == this.last_index) {
                this.last_returned = -2;
                this.index = -2;
                return;
            }
            this.last_returned = this.index++;
            if (this.index >= this.table.length) {
                this.index = 0;
            }
        }

        @Override
        public void remove() {
            if (LongHashMap.this.mod_count != this.expected_mod_count) {
                throw new ConcurrentModificationException();
            }
            if (this.last_returned == -1) {
                throw new IllegalStateException();
            }
            if (this.last_returned >= 0) {
                LongHashMap.this.removeByIndex(this.last_returned);
            } else {
                LongHashMap.this.removeFirstKey();
            }
            ++this.expected_mod_count;
            this.last_returned = -1;
        }

        @Override
        public abstract T next();
    }
}

