/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.util;

import com.devexperts.logging.Logging;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class LoggedThreadPoolExecutor
extends ScheduledThreadPoolExecutor {
    private final Logging log;

    public LoggedThreadPoolExecutor(int corePoolSize, String name, Logging log) {
        super(corePoolSize, new PoolThreadFactory(name));
        this.log = log;
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        if (t == null && r instanceof Future) {
            try {
                ((Future)((Object)r)).get();
            }
            catch (ExecutionException e) {
                t = e.getCause();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (t != null) {
            this.log.error("Uncaught exception", t);
        }
    }

    private static class PoolThreadFactory
    implements ThreadFactory {
        private final String name;
        private final AtomicInteger index = new AtomicInteger();
        private final ThreadGroup group;

        PoolThreadFactory(String name) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.name = name;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(this.group, r, this.name + "-" + this.index.incrementAndGet());
            thread.setDaemon(true);
            return thread;
        }
    }
}

