/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.util;

import com.devexperts.util.SystemProperties;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;

public class LogUtil {
    private static final int MAX_LOG_STRING_LENGTH = SystemProperties.getIntProperty(LogUtil.class, "maxLogStringLength", 120);
    private static final int MIN_ARRAY_LENGTH = SystemProperties.getIntProperty(LogUtil.class, "minArrayLength", 10);
    private static final String NULL = "null";
    private static final Pattern CREDENTIALS_PROPERTIES = Pattern.compile("([\\[\\(\\?,;&](user|password)=)([^\\]\\),;&]+)");
    private static final Pattern CREDENTIALS_USER_INFO = Pattern.compile("(://)([^/\\?\\[\\]\\(\\),;&]+)(@)");

    public static String hideCredentials(Object o) {
        if (o == null) {
            return null;
        }
        String s = o.toString();
        if (s == null) {
            return null;
        }
        if (s.contains("user=") || s.contains("password=")) {
            s = CREDENTIALS_PROPERTIES.matcher(s).replaceAll("$1****");
        }
        if (s.contains("://") && s.lastIndexOf(64) > s.indexOf("://")) {
            s = CREDENTIALS_USER_INFO.matcher(s).replaceAll("$1****$3");
        }
        return s;
    }

    public static String deepToString(Object object) {
        if (object == null) {
            return NULL;
        }
        if (object instanceof Object[]) {
            return LogUtil.printArray((Object[])object);
        }
        if (object instanceof boolean[]) {
            return LogUtil.printArray((boolean[])object);
        }
        if (object instanceof byte[]) {
            return LogUtil.printArray((byte[])object);
        }
        if (object instanceof short[]) {
            return LogUtil.printArray((short[])object);
        }
        if (object instanceof int[]) {
            return LogUtil.printArray((int[])object);
        }
        if (object instanceof char[]) {
            return LogUtil.printArray((char[])object);
        }
        if (object instanceof long[]) {
            return LogUtil.printArray((long[])object);
        }
        if (object instanceof float[]) {
            return LogUtil.printArray((float[])object);
        }
        if (object instanceof double[]) {
            return LogUtil.printArray((double[])object);
        }
        if (object instanceof Collection) {
            return LogUtil.printCollection((Collection)object);
        }
        if (object instanceof Map) {
            return LogUtil.printMap((Map)object);
        }
        return LogUtil.printObject(object);
    }

    public static String printMap(Map<?, ?> map) {
        if (map == null) {
            return NULL;
        }
        StringBuilder result = new StringBuilder();
        result.append("[");
        int i = 0;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (i > 0) {
                result.append(", ");
            }
            result.append(LogUtil.deepToString(entry.getKey())).append("=");
            result.append(LogUtil.deepToString(entry.getValue()));
            if (i > MIN_ARRAY_LENGTH && result.length() >= MAX_LOG_STRING_LENGTH) break;
            ++i;
        }
        if (i < map.size()) {
            result.append(" ... ").append(map.size() - i).append(" more");
        }
        result.append("]");
        return result.toString();
    }

    public static String printCollection(Collection<?> collection) {
        if (collection == null) {
            return NULL;
        }
        StringBuilder result = new StringBuilder();
        result.append("[");
        int i = 0;
        for (Object o : collection) {
            if (i > 0) {
                result.append(", ");
            }
            result.append(LogUtil.deepToString(o));
            if (i > MIN_ARRAY_LENGTH && result.length() >= MAX_LOG_STRING_LENGTH) break;
            ++i;
        }
        if (i < collection.size()) {
            result.append(" ... ").append(collection.size() - i).append(" more");
        }
        result.append("]");
        return result.toString();
    }

    public static String printArray(Object[] objects) {
        int i;
        if (objects == null) {
            return NULL;
        }
        StringBuilder result = new StringBuilder();
        result.append("[");
        int count = Math.min(MIN_ARRAY_LENGTH, objects.length);
        for (i = 0; i < count; ++i) {
            if (i > 0) {
                result.append(", ");
            }
            result.append(LogUtil.deepToString(objects[i]));
            if (i > MIN_ARRAY_LENGTH && result.length() >= MAX_LOG_STRING_LENGTH) break;
        }
        if (i < objects.length) {
            result.append(", ... ").append(objects.length - i).append(" more");
        }
        result.append("]");
        return result.toString();
    }

    public static String printArray(boolean[] objects) {
        int i;
        if (objects == null) {
            return NULL;
        }
        StringBuilder result = new StringBuilder();
        result.append("[");
        int count = Math.min(MIN_ARRAY_LENGTH, objects.length);
        for (i = 0; i < count; ++i) {
            if (i > 0) {
                result.append(", ");
            }
            result.append(LogUtil.deepToString(objects[i]));
            if (i > MIN_ARRAY_LENGTH && result.length() >= MAX_LOG_STRING_LENGTH) break;
        }
        if (i < objects.length) {
            result.append(", ... ").append(objects.length - i).append(" more");
        }
        result.append("]");
        return result.toString();
    }

    public static String printArray(byte[] objects) {
        int i;
        if (objects == null) {
            return NULL;
        }
        StringBuilder result = new StringBuilder();
        result.append("[");
        int count = Math.min(MIN_ARRAY_LENGTH, objects.length);
        for (i = 0; i < count; ++i) {
            if (i > 0) {
                result.append(", ");
            }
            result.append(LogUtil.deepToString(objects[i]));
            if (i > MIN_ARRAY_LENGTH && result.length() >= MAX_LOG_STRING_LENGTH) break;
        }
        if (i < objects.length) {
            result.append(", ... ").append(objects.length - i).append(" more");
        }
        result.append("]");
        return result.toString();
    }

    public static String printArray(short[] objects) {
        int i;
        if (objects == null) {
            return NULL;
        }
        StringBuilder result = new StringBuilder();
        result.append("[");
        int count = Math.min(MIN_ARRAY_LENGTH, objects.length);
        for (i = 0; i < count; ++i) {
            if (i > 0) {
                result.append(", ");
            }
            result.append(LogUtil.deepToString(objects[i]));
            if (i > MIN_ARRAY_LENGTH && result.length() >= MAX_LOG_STRING_LENGTH) break;
        }
        if (i < objects.length) {
            result.append(", ... ").append(objects.length - i).append(" more");
        }
        result.append("]");
        return result.toString();
    }

    public static String printArray(int[] objects) {
        int i;
        if (objects == null) {
            return NULL;
        }
        StringBuilder result = new StringBuilder();
        result.append("[");
        int count = Math.min(MIN_ARRAY_LENGTH, objects.length);
        for (i = 0; i < count; ++i) {
            if (i > 0) {
                result.append(", ");
            }
            result.append(LogUtil.deepToString(objects[i]));
            if (i > MIN_ARRAY_LENGTH && result.length() >= MAX_LOG_STRING_LENGTH) break;
        }
        if (i < objects.length) {
            result.append(", ... ").append(objects.length - i).append(" more");
        }
        result.append("]");
        return result.toString();
    }

    public static String printArray(char[] objects) {
        int i;
        if (objects == null) {
            return NULL;
        }
        StringBuilder result = new StringBuilder();
        result.append("[");
        int count = Math.min(MIN_ARRAY_LENGTH, objects.length);
        for (i = 0; i < count; ++i) {
            if (i > 0) {
                result.append(", ");
            }
            result.append(LogUtil.deepToString(Character.valueOf(objects[i])));
            if (i > MIN_ARRAY_LENGTH && result.length() >= MAX_LOG_STRING_LENGTH) break;
        }
        if (i < objects.length) {
            result.append(", ... ").append(objects.length - i).append(" more");
        }
        result.append("]");
        return result.toString();
    }

    public static String printArray(long[] objects) {
        int i;
        if (objects == null) {
            return NULL;
        }
        StringBuilder result = new StringBuilder();
        result.append("[");
        int count = Math.min(MIN_ARRAY_LENGTH, objects.length);
        for (i = 0; i < count; ++i) {
            if (i > 0) {
                result.append(", ");
            }
            result.append(LogUtil.deepToString(objects[i]));
            if (i > MIN_ARRAY_LENGTH && result.length() >= MAX_LOG_STRING_LENGTH) break;
        }
        if (i < objects.length) {
            result.append(", ... ").append(objects.length - i).append(" more");
        }
        result.append("]");
        return result.toString();
    }

    public static String printArray(float[] objects) {
        int i;
        if (objects == null) {
            return NULL;
        }
        StringBuilder result = new StringBuilder();
        result.append("[");
        int count = Math.min(MIN_ARRAY_LENGTH, objects.length);
        for (i = 0; i < count; ++i) {
            if (i > 0) {
                result.append(", ");
            }
            result.append(LogUtil.deepToString(Float.valueOf(objects[i])));
            if (i > MIN_ARRAY_LENGTH && result.length() >= MAX_LOG_STRING_LENGTH) break;
        }
        if (i < objects.length) {
            result.append(", ... ").append(objects.length - i).append(" more");
        }
        result.append("]");
        return result.toString();
    }

    public static String printArray(double[] objects) {
        int i;
        if (objects == null) {
            return NULL;
        }
        StringBuilder result = new StringBuilder();
        result.append("[");
        int count = Math.min(MIN_ARRAY_LENGTH, objects.length);
        for (i = 0; i < count; ++i) {
            if (i > 0) {
                result.append(", ");
            }
            result.append(LogUtil.deepToString(objects[i]));
            if (i > MIN_ARRAY_LENGTH && result.length() >= MAX_LOG_STRING_LENGTH) break;
        }
        if (i < objects.length) {
            result.append(", ... ").append(objects.length - i).append(" more");
        }
        result.append("]");
        return result.toString();
    }

    private static String printObject(Object object) {
        String s = object.toString();
        return s.length() <= MAX_LOG_STRING_LENGTH ? s : s.substring(0, MAX_LOG_STRING_LENGTH) + " ... " + (s.length() - MAX_LOG_STRING_LENGTH) + " chars more";
    }
}

