/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.util;

import com.devexperts.util.SystemProperties;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class LockFreePool<E> {
    private static final int SIZE_BITS = 24;
    private static final int INDEX_BITS = 25;
    private static final long SIZE_INC = 0x2000000L;
    private static final long VERSION_INC = 0x2000000000000L;
    private static final long INDEX_MASK = 0x1FFFFFFL;
    private static final long SIZE_MASK = 562949919866880L;
    public static final int MAX_CAPACITY = 0xFFFFFF;
    private final int capacity;
    private final int lengthMask;
    private final AtomicReferenceArray<E> objects;
    private final int[] next;
    private final AtomicLong state = new AtomicLong();

    public LockFreePool(int poolCapacity) {
        if (poolCapacity < 1 || poolCapacity > 0xFFFFFF) {
            throw new IllegalArgumentException("Pool capacity is out of range");
        }
        this.capacity = poolCapacity;
        this.lengthMask = (Integer.highestOneBit(Math.max(poolCapacity, 16)) << 2) - 1;
        this.objects = new AtomicReferenceArray(this.lengthMask + 1);
        this.next = new int[this.lengthMask + 1];
    }

    public LockFreePool(String poolName, int defaultPoolCapacity) {
        this(SystemProperties.getIntProperty(poolName + ".poolCapacity", defaultPoolCapacity));
    }

    public int size() {
        return (int)((this.state.get() & 0x1FFFFFE000000L) >>> 25);
    }

    public E poll() {
        int index;
        long st;
        do {
            if (((st = this.state.get()) & 0x1FFFFFE000000L) != 0L) continue;
            return null;
        } while (!this.state.compareAndSet(st, st + 562949919866880L & 0xFFFFFFFFFE000000L | (long)this.next[index = (int)(st & 0x1FFFFFFL)]));
        E result = this.objects.get(index);
        this.objects.set(index, null);
        return result;
    }

    public boolean offer(E o) {
        long st;
        E old;
        if (o == null) {
            throw new NullPointerException("Element is null");
        }
        int index = LockFreePool.hash(o) & this.lengthMask;
        int attempts = 0;
        while ((old = this.objects.get(index)) != null || !this.objects.compareAndSet(index, null, o)) {
            if (old == o) {
                throw new IllegalStateException("Element is already in the pool");
            }
            index = index + 1 & this.lengthMask;
            if (++attempts < this.lengthMask && ((attempts & 3) != 0 || this.size() < this.capacity)) continue;
            return false;
        }
        do {
            if (((st = this.state.get()) & 0x1FFFFFE000000L) >>> 25 >= (long)this.capacity) {
                this.objects.set(index, null);
                return false;
            }
            this.next[index] = (int)(st & 0x1FFFFFFL);
        } while (!this.state.compareAndSet(st, st + 0x2000002000000L & 0xFFFFFFFFFE000000L | (long)index));
        return true;
    }

    private static int hash(Object o) {
        int h = System.identityHashCode(o);
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }
}

