/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.util;

import com.devexperts.util.Indexer;
import java.io.Serializable;

@FunctionalInterface
public interface IndexerFunction<K, V>
extends Serializable {
    public static final IndexerFunction DEFAULT = new DefaultIndexerFunction();
    public static final IdentityKey DEFAULT_IDENTITY_KEY = new DefaultIdentityKey();

    public K getObjectKey(V var1);

    default public int hashCodeByKey(K key) {
        return key == null ? 0 : key.hashCode();
    }

    default public boolean matchesByKey(K key, V value) {
        return key == null ? this.getObjectKey(value) == null : key.equals(this.getObjectKey(value));
    }

    default public int hashCodeByValue(V value) {
        return this.hashCodeByKey(this.getObjectKey(value));
    }

    default public boolean matchesByValue(V newValue, V oldValue) {
        return this.matchesByKey(this.getObjectKey(newValue), oldValue);
    }

    default public long getNumberKey(V value) {
        return this.hashCodeByKey(((Number)this.getObjectKey(value)).longValue());
    }

    default public int hashCodeByKey(long key) {
        return Long.hashCode(key);
    }

    default public boolean matchesByKey(long key, V value) {
        return key == this.getNumberKey(value);
    }

    public static final class DefaultIdentityKey
    implements IdentityKey {
        private static final long serialVersionUID = 0L;

        DefaultIdentityKey() {
        }

        @Override
        public Object getObjectKey(Object value) {
            return value;
        }

        private Object readResolve() {
            return DEFAULT_IDENTITY_KEY;
        }
    }

    public static final class DefaultIndexerFunction
    implements IndexerFunction {
        private static final long serialVersionUID = 0L;

        DefaultIndexerFunction() {
        }

        public Object getObjectKey(Object value) {
            return value;
        }

        private Object writeReplace() {
            return Indexer.DEFAULT;
        }

        private Object readResolve() {
            return DEFAULT;
        }
    }

    @FunctionalInterface
    public static interface IdentityKey<K, V>
    extends IndexerFunction<K, V> {
        @Override
        default public int hashCodeByKey(K key) {
            return System.identityHashCode(key);
        }

        @Override
        default public boolean matchesByKey(K key, V value) {
            return key == this.getObjectKey(value);
        }
    }

    @FunctionalInterface
    public static interface LongKey<V>
    extends IndexerFunction<Long, V> {
        @Override
        public long getNumberKey(V var1);

        @Override
        default public int hashCodeByValue(V value) {
            return this.hashCodeByKey(this.getNumberKey(value));
        }

        @Override
        default public boolean matchesByValue(V newValue, V oldValue) {
            return this.getNumberKey(newValue) == this.getNumberKey(oldValue);
        }

        @Override
        default public Long getObjectKey(V value) {
            return this.getNumberKey(value);
        }

        @Override
        default public int hashCodeByKey(Long key) {
            return this.hashCodeByKey((long)key);
        }

        @Override
        default public boolean matchesByKey(Long key, V value) {
            return key.longValue() == this.getNumberKey(value);
        }
    }

    @FunctionalInterface
    public static interface IntKey<V>
    extends IndexerFunction<Integer, V> {
        public int getIntKey(V var1);

        @Override
        default public long getNumberKey(V value) {
            return this.getIntKey(value);
        }

        @Override
        default public int hashCodeByValue(V value) {
            return this.hashCodeByKey((long)this.getIntKey(value));
        }

        @Override
        default public boolean matchesByValue(V newValue, V oldValue) {
            return this.getIntKey(newValue) == this.getIntKey(oldValue);
        }

        @Override
        default public Integer getObjectKey(V value) {
            return this.getIntKey(value);
        }

        @Override
        default public int hashCodeByKey(Integer key) {
            return this.hashCodeByKey((long)key.intValue());
        }

        @Override
        default public boolean matchesByKey(Integer key, V value) {
            return key.intValue() == this.getIntKey(value);
        }
    }
}

