/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.util;

import com.devexperts.util.AbstractConcurrentSet;
import com.devexperts.util.IndexedSetStats;
import com.devexperts.util.Indexer;
import com.devexperts.util.IndexerFunction;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.Predicate;
import java.util.stream.Collector;
import javax.annotation.Nonnull;

public class IndexedSet<K, V>
extends AbstractConcurrentSet<V>
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 0L;
    private final IndexerFunction<K, ? super V> indexer;
    private volatile transient Core<K, V> core;
    static final int THRESHOLD_UP = -1908874354;
    static final int THRESHOLD_DOWN = 795364314;
    static final int THRESHOLD_ALLOC_UP = 0x71C71C71;
    static final int MAX_SHIFT = 29;
    static final int MIN_SHIFT = 2;
    static final int MAX_CAPACITY = 0x1C71C71C;
    private static final int GOLDEN_RATIO = -1640531527;
    private static final int MAGIC = -915711435;
    private static int magicSeed = (int)(System.currentTimeMillis() * Runtime.getRuntime().freeMemory());

    public static <V> IndexedSet<V, V> create() {
        return new IndexedSet();
    }

    public static <V> IndexedSet<V, V> createIdentity() {
        return new IndexedSet(IndexerFunction.DEFAULT_IDENTITY_KEY);
    }

    public static <K, V> IndexedSet<K, V> create(IndexerFunction<K, ? super V> indexer) {
        return new IndexedSet<K, V>(indexer);
    }

    public static <K, V> IndexedSet<K, V> createIdentity(IndexerFunction.IdentityKey<K, ? super V> indexer) {
        return new IndexedSet<K, V>(indexer);
    }

    public static <V> IndexedSet<Integer, V> createInt(IndexerFunction.IntKey<? super V> indexer) {
        return new IndexedSet(indexer);
    }

    public static <V> IndexedSet<Long, V> createLong(IndexerFunction.LongKey<? super V> indexer) {
        return new IndexedSet(indexer);
    }

    @Deprecated
    public static <V> IndexedSet<Integer, V> create(IndexerFunction.IntKey<? super V> indexer) {
        return new IndexedSet(indexer);
    }

    @Deprecated
    public static <V> IndexedSet<Long, V> create(IndexerFunction.LongKey<? super V> indexer) {
        return new IndexedSet(indexer);
    }

    @Deprecated
    public static <K, V> IndexedSet<K, V> create(IndexerFunction<K, ? super V> indexer, int initialCapacity) {
        return new IndexedSet<K, V>(indexer, initialCapacity);
    }

    @Deprecated
    public static <V> IndexedSet<Integer, V> create(IndexerFunction.IntKey<? super V> indexer, int initialCapacity) {
        return new IndexedSet(indexer, initialCapacity);
    }

    @Deprecated
    public static <V> IndexedSet<Long, V> create(IndexerFunction.LongKey<? super V> indexer, int initialCapacity) {
        return new IndexedSet(indexer, initialCapacity);
    }

    @Deprecated
    public static <K, V> IndexedSet<K, V> create(IndexerFunction<K, ? super V> indexer, Collection<? extends V> c) {
        return new IndexedSet<K, V>(indexer, c);
    }

    @Deprecated
    public static <V> IndexedSet<Integer, V> create(IndexerFunction.IntKey<? super V> indexer, Collection<? extends V> c) {
        return new IndexedSet(indexer, c);
    }

    @Deprecated
    public static <V> IndexedSet<Long, V> create(IndexerFunction.LongKey<? super V> indexer, Collection<? extends V> c) {
        return new IndexedSet(indexer, c);
    }

    @SafeVarargs
    public static <V> IndexedSet<V, V> of(V ... objs) {
        return new IndexedSet(Arrays.asList(objs));
    }

    public static <V> Collector<V, ?, ? extends IndexedSet<V, V>> collector() {
        return IndexedSet.collector(IndexerFunction.DEFAULT);
    }

    public static <V> Collector<V, ?, ? extends IndexedSet<V, V>> collectorIdentity() {
        return IndexedSet.collector(IndexerFunction.DEFAULT_IDENTITY_KEY);
    }

    public static <K, V> Collector<V, ?, ? extends IndexedSet<K, V>> collector(IndexerFunction<K, ? super V> indexer) {
        return Collector.of(() -> IndexedSet.create(indexer), IndexedSet::add, (left, right) -> {
            left.addAll(right);
            return left;
        }, Collector.Characteristics.UNORDERED, Collector.Characteristics.IDENTITY_FINISH);
    }

    public static <K, V> Collector<V, ?, ? extends IndexedSet<K, V>> collectorIdentity(IndexerFunction.IdentityKey<K, ? super V> indexer) {
        return IndexedSet.collector(indexer);
    }

    public static <V> Collector<V, ?, ? extends IndexedSet<Integer, V>> collectorInt(IndexerFunction.IntKey<? super V> indexer) {
        return IndexedSet.collector(indexer);
    }

    public static <V> Collector<V, ?, ? extends IndexedSet<Long, V>> collectorLong(IndexerFunction.LongKey<? super V> indexer) {
        return IndexedSet.collector(indexer);
    }

    @Deprecated
    public static <V> Collector<V, ?, ? extends IndexedSet<Integer, V>> collector(IndexerFunction.IntKey<? super V> indexer) {
        return IndexedSet.collector(indexer);
    }

    @Deprecated
    public static <V> Collector<V, ?, ? extends IndexedSet<Long, V>> collector(IndexerFunction.LongKey<? super V> indexer) {
        return IndexedSet.collector(indexer);
    }

    public IndexedSet() {
        this(0);
    }

    public IndexedSet(int initialCapacity) {
        this(IndexerFunction.DEFAULT, initialCapacity);
    }

    protected IndexedSet(IndexerFunction<K, ? super V> indexer) {
        this(indexer, 0);
    }

    @Deprecated
    public IndexedSet(Indexer<K, ? super V> indexer) {
        this((IndexerFunction<K, ? super V>)indexer);
    }

    protected IndexedSet(IndexerFunction<K, ? super V> indexer, int initialCapacity) {
        if (indexer == null) {
            throw new NullPointerException("Indexer is null.");
        }
        this.indexer = indexer;
        this.core = initialCapacity <= 0 ? Core.EMPTY_CORE : new Core<K, V>(indexer, initialCapacity, -1640531527);
    }

    @Deprecated
    public IndexedSet(Indexer<K, ? super V> indexer, int initialCapacity) {
        this((IndexerFunction<K, ? super V>)indexer, initialCapacity);
    }

    public IndexedSet(Collection<V> c) {
        this(c instanceof IndexedSet ? ((IndexedSet)c).getIndexerFunction() : IndexerFunction.DEFAULT, c);
    }

    protected IndexedSet(IndexerFunction<K, ? super V> indexer, Collection<? extends V> c) {
        this(indexer, c.size());
        this.addAll(c);
    }

    @Deprecated
    public IndexedSet(Indexer<K, ? super V> indexer, Collection<? extends V> c) {
        this((IndexerFunction<K, ? extends V>)indexer, c);
    }

    public IndexedSet<K, V> clone() {
        try {
            IndexedSet result = (IndexedSet)super.clone();
            if (result.core != Core.EMPTY_CORE) {
                result.core = new Core<K, V>(result.core);
            }
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public IndexedSet<K, V> withCapacity(int capacity) {
        this.ensureCapacity(capacity);
        return this;
    }

    public IndexedSet<K, V> withElements(Collection<? extends V> c) {
        this.ensureCapacity(c.size());
        this.addAll(c);
        return this;
    }

    public void ensureCapacity(int capacity) {
        this.core = this.core.ensureCapacity(this.indexer, capacity);
    }

    public void trimToSize() {
        this.core = this.core.trimToSize(this.indexer);
    }

    @Override
    public void clear() {
        this.core = this.core.clear();
    }

    @Deprecated
    public Indexer<K, ? super V> getIndexer() {
        return this.indexer instanceof Indexer ? (Indexer)this.indexer : new Indexer.DelegateIndexer<K, V>(this.indexer);
    }

    public IndexerFunction<K, ? super V> getIndexerFunction() {
        return this.indexer;
    }

    @Override
    public int size() {
        return this.core.size();
    }

    public V getByValue(V value) {
        return this.core.getByValue(value);
    }

    public V getByKey(K key) {
        return this.core.getByKey(key);
    }

    public V getByKey(int key) {
        return this.core.getByKey(key);
    }

    public V getByKey(long key) {
        return this.core.getByKey(key);
    }

    @Override
    public boolean contains(Object value) {
        return this.getByValue(value) != null;
    }

    public boolean containsValue(V value) {
        return this.getByValue(value) != null;
    }

    public boolean containsKey(K key) {
        return this.getByKey(key) != null;
    }

    public boolean containsKey(int key) {
        return this.getByKey(key) != null;
    }

    public boolean containsKey(long key) {
        return this.getByKey(key) != null;
    }

    @Override
    @Nonnull
    public Iterator<V> iterator() {
        return this.iterator(1);
    }

    public Iterator<K> keyIterator() {
        return this.iterator(2);
    }

    public Iterator<Map.Entry<K, V>> entryIterator() {
        return this.iterator(3);
    }

    public Iterator<V> concurrentIterator() {
        return this.iterator(0);
    }

    @Override
    @Nonnull
    public Object[] toArray() {
        return this.core.toArray(null);
    }

    @Override
    @Nonnull
    public <T> T[] toArray(T[] a) {
        return this.core.toArray(a);
    }

    public IndexedSetStats getStats() {
        return this.core.getStats();
    }

    public V put(V value) {
        return this.putImpl(this.core, value);
    }

    public V putIfAbsentAndGet(V value) {
        Core<K, V> core = this.core;
        V oldValue = core.getByValue(value);
        if (oldValue != null) {
            return oldValue;
        }
        this.putImpl(core, value);
        return value;
    }

    @Override
    public boolean add(V value) {
        return this.put(value) == null;
    }

    @Override
    public boolean remove(Object value) {
        return this.removeValue(value) != null;
    }

    public V removeValue(V value) {
        Core<K, V> core = this.core;
        V oldValue = core.removeValue(value);
        this.core = core;
        return oldValue;
    }

    public V removeKey(K key) {
        Core<K, V> core = this.core;
        V oldValue = core.removeKey(key);
        this.core = core;
        return oldValue;
    }

    public V removeKey(int key) {
        return this.removeKey((long)key);
    }

    public V removeKey(long key) {
        Core<K, V> core = this.core;
        V oldValue = core.removeKey(key);
        this.core = core;
        return oldValue;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        Objects.requireNonNull(c);
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean modified = false;
        if (this.size() < c.size() && c instanceof IndexedSet && this.indexer.equals(((IndexedSet)c).getIndexerFunction())) {
            Iterator<V> it = this.iterator();
            while (it.hasNext()) {
                if (!c.contains(it.next())) continue;
                it.remove();
                modified = true;
            }
        } else {
            for (Object o : c) {
                if (!this.remove(o)) continue;
                modified = true;
            }
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Objects.requireNonNull(c);
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        IndexedSet retain = c instanceof IndexedSet && this.indexer.equals(((IndexedSet)c).getIndexerFunction()) ? (IndexedSet)c : new IndexedSet(this.indexer, c);
        return this.retainAllImpl(retain);
    }

    boolean removeAllEntries(Collection<?> c) {
        Objects.requireNonNull(c);
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean modified = false;
        for (Object o : c) {
            Map.Entry e;
            if (!(o instanceof Map.Entry) || !this.indexer.matchesByKey((e = (Map.Entry)o).getKey(), e.getValue()) || !this.remove(e.getValue())) continue;
            modified = true;
        }
        return modified;
    }

    boolean retainAllEntries(Collection<?> c) {
        Objects.requireNonNull(c);
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        IndexedSet retain = new IndexedSet(this.indexer, c.size());
        for (Object o : c) {
            Map.Entry e;
            if (!(o instanceof Map.Entry) || !this.indexer.matchesByKey((e = (Map.Entry)o).getKey(), e.getValue())) continue;
            retain.add((V)e.getValue());
        }
        return this.retainAllImpl(retain);
    }

    boolean removeEntryIf(Predicate<? super Map.Entry<K, V>> filter) {
        Objects.requireNonNull(filter);
        return IndexedSet.removeIfImpl(filter, this.entryIterator());
    }

    boolean removeAllKeys(Collection<?> c) {
        Objects.requireNonNull(c);
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean modified = false;
        for (Object o : c) {
            if (this.removeKey(o) == null) continue;
            modified = true;
        }
        return modified;
    }

    boolean retainAllKeys(Collection<?> c) {
        Objects.requireNonNull(c);
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        IndexedSet<K, V> retain = new IndexedSet<K, V>(this.indexer, c.size());
        for (Object o : c) {
            V v = this.getByKey(o);
            if (v == null) continue;
            retain.add(v);
        }
        return this.retainAllImpl(retain);
    }

    boolean removeKeyIf(Predicate<? super K> filter) {
        Objects.requireNonNull(filter);
        return IndexedSet.removeIfImpl(filter, this.keyIterator());
    }

    private V putImpl(Core<K, V> core, V value) {
        Object oldValue;
        if (core.needRehash()) {
            if (core == Core.EMPTY_CORE || (oldValue = core.put(value, true)) == null) {
                core = core.rehash(this.indexer, 0);
                oldValue = core.put(value, false);
            }
        } else {
            oldValue = core.put(value, false);
        }
        this.core = core;
        return oldValue;
    }

    private Iterator<?> iterator(int type) {
        Core<K, V> core = this.core;
        return core.size() == 0 ? IndexedIterator.EMPTY_ITERATOR : new IndexedIterator<K, V>(this, core, type);
    }

    void checkModification(Object checkCore, long checkModCount) {
        Core<K, V> core = this.core;
        if (checkCore != core || checkModCount != core.getModCount()) {
            throw new ConcurrentModificationException();
        }
    }

    void removeIterated(Object checkCore, long checkModCount, boolean concurrent, V lastValue, int lastIndex) {
        Core<K, V> core = this.core;
        if (!(concurrent || checkCore == core && checkModCount == core.getModCount())) {
            throw new ConcurrentModificationException();
        }
        if (core.get(lastIndex) == lastValue) {
            core.removeAt(lastIndex, core.getInitialIndexByValue(lastValue));
        } else if (concurrent) {
            core.removeValue(lastValue);
        } else {
            throw new ConcurrentModificationException();
        }
        this.core = core;
    }

    private static <T> boolean removeIfImpl(Predicate<? super T> filter, Iterator<T> iterator) {
        boolean modified = false;
        while (iterator.hasNext()) {
            if (!filter.test(iterator.next())) continue;
            iterator.remove();
            modified = true;
        }
        return modified;
    }

    private boolean retainAllImpl(IndexedSet<K, V> retain) {
        if (retain.isEmpty() && !this.isEmpty()) {
            this.clear();
            return true;
        }
        boolean modified = false;
        Iterator<V> it = this.iterator();
        while (it.hasNext()) {
            if (retain.containsValue(it.next())) continue;
            it.remove();
            modified = true;
        }
        return modified;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        this.writeCore(out);
    }

    void writeCore(ObjectOutputStream out) throws IOException {
        this.core.writeObjectImpl(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.core = Core.readObjectImpl(this.indexer, in);
    }

    static int getShift(int capacity) {
        int shift;
        for (shift = 29; 0x71C71C71 >>> shift < capacity && shift >= 2; --shift) {
        }
        if (shift < 2) {
            throw new IllegalArgumentException("Capacity is too large: " + capacity);
        }
        return shift;
    }

    static int nextMagic(int prevMagic) {
        magicSeed = magicSeed * -915711435 + 1;
        int magic = magicSeed | 1;
        int i = 31;
        while (--i >= 0) {
            int bits = magic >> i & 0xF;
            if (bits != 0 && bits != 15) continue;
            magic ^= 1 << i;
            i -= 2;
        }
        if ((magic & 1) == 0) {
            magic ^= 3;
        }
        i = 25;
        while (--i >= 0) {
            if (((magic ^ prevMagic) >> i & 0xFF) != 0) continue;
            magic ^= (magic ^ magic << 1) & 4 << i ^ 2 << i;
            i -= 6;
        }
        return magic;
    }

    static int nextMagic(int prevMagic, int capacity) {
        int magic = IndexedSet.nextMagic(prevMagic);
        if (capacity < 32) {
            return magic;
        }
        double eval = IndexedSet.evaluateContinuedFraction(magic);
        int attempts = 30 - Integer.numberOfLeadingZeros(capacity);
        for (int i = 0; i < attempts; ++i) {
            int m = IndexedSet.nextMagic(prevMagic);
            double e = IndexedSet.evaluateContinuedFraction(m);
            if (!(e > eval)) continue;
            magic = m;
            eval = e;
        }
        return magic;
    }

    static double evaluateContinuedFraction(int magic) {
        double x;
        double rem = x = (double)((long)magic & 0xFFFFFFFFL) / 4.294967296E9;
        long p2 = 1L;
        long q2 = 0L;
        long p1 = 0L;
        long q1 = 1L;
        double grade = x;
        for (int i = 1; i <= 20; ++i) {
            rem = 1.0 / rem;
            long a = (long)rem;
            rem -= (double)a;
            long p = a * p1 + p2;
            long q = a * q1 + q2;
            p2 = p1;
            q2 = q1;
            p1 = p;
            q1 = q;
            if ((grade = Math.min(grade, Math.abs(x * (double)q - (double)p) * (double)q)) < 1.0E-6 || rem < 1.0E-6 || q > 0x100000L) break;
        }
        return grade;
    }

    private static final class IndexedEntry<K, V>
    implements Map.Entry<K, V> {
        private final IndexedSet<K, V> set;
        private V value;

        IndexedEntry(IndexedSet<K, V> set, V value) {
            this.set = set;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.set.getIndexerFunction().getObjectKey(this.value);
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            if (value == null) {
                throw new NullPointerException("Value is null.");
            }
            V oldValue = this.value;
            if (!this.set.getIndexerFunction().matchesByValue(value, oldValue)) {
                throw new IllegalArgumentException("New value does not match old value.");
            }
            this.value = value;
            this.set.put(this.value);
            return oldValue;
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)obj;
            K key = this.getKey();
            Object ekey = e.getKey();
            return (key == null ? ekey == null : key.equals(ekey)) && this.value.equals(e.getValue());
        }

        @Override
        public int hashCode() {
            K key = this.getKey();
            return (key == null ? 0 : key.hashCode()) ^ this.value.hashCode();
        }

        public String toString() {
            return this.getKey() + "=" + this.value;
        }
    }

    private static final class IndexedIterator<K, V>
    implements Iterator<Object> {
        static final int VALUE_CONCURRENT = 0;
        static final int VALUE_FAILFAST = 1;
        static final int KEY_FAILFAST = 2;
        static final int ENTRY_FAILFAST = 3;
        static final Iterator<?> EMPTY_ITERATOR = new IndexedIterator(null, Core.EMPTY_CORE, 0);
        private final IndexedSet<K, V> set;
        private final Core<K, V> core;
        private final int type;
        private long modCount;
        private V nextValue;
        private int nextIndex;
        private V lastValue;
        private int lastIndex;

        IndexedIterator(IndexedSet<K, V> set, Core<K, V> core, int type) {
            this.set = set;
            this.core = core;
            this.type = type;
            this.modCount = core.getModCount();
            this.nextIndex = core.length();
            this.fillNext();
        }

        private void fillNext() {
            if (this.type != 0) {
                this.set.checkModification(this.core, this.modCount);
            }
            while (--this.nextIndex >= 0) {
                this.nextValue = this.core.get(this.nextIndex);
                if (this.nextValue == null || this.nextValue == Core.REMOVED) continue;
                return;
            }
            this.nextValue = null;
        }

        @Override
        public boolean hasNext() {
            return this.nextValue != null;
        }

        @Override
        public Object next() {
            if (this.nextValue == null) {
                throw new NoSuchElementException();
            }
            this.lastValue = this.nextValue;
            this.lastIndex = this.nextIndex;
            this.fillNext();
            if (this.type == 2) {
                return this.set.getIndexerFunction().getObjectKey(this.lastValue);
            }
            if (this.type == 3) {
                return new IndexedEntry<K, V>(this.set, this.lastValue);
            }
            return this.lastValue;
        }

        @Override
        public void remove() {
            if (this.lastValue == null) {
                throw new IllegalStateException();
            }
            this.set.removeIterated(this.core, this.modCount, this.type == 0, this.lastValue, this.lastIndex);
            this.modCount = this.core.getModCount();
            this.lastValue = null;
        }
    }

    private static final class Core<K, V>
    extends AtomicReferenceArray<V> {
        static final int QUALITY_BASE = 6;
        static final Object REMOVED = new Object();
        static final Core<?, ?> EMPTY_CORE = new Core<Object, Object>(value -> null, 0, -1640531527);
        private final int magic;
        private final int shift;
        private final IndexerFunction<K, ? super V> indexer;
        private long quality;
        private int payloadSize;
        private int overallSize;
        private long modCount;
        private long amortizedCost;

        Core(IndexerFunction<K, ? super V> indexer, int capacity, int magic) {
            super((-1 >>> IndexedSet.getShift(capacity)) + 1);
            if (indexer == null) {
                throw new NullPointerException("Indexer is null.");
            }
            this.magic = magic;
            this.shift = Integer.numberOfLeadingZeros(this.length()) + 1;
            this.indexer = indexer;
            this.quality = 7L;
        }

        Core(Core<K, V> source) {
            super(source.length());
            this.magic = source.magic;
            this.shift = source.shift;
            this.indexer = source.indexer;
            this.quality = source.quality;
            this.payloadSize = source.payloadSize;
            this.overallSize = source.overallSize;
            this.modCount = source.modCount;
            this.amortizedCost = source.amortizedCost;
            int i = this.length();
            while (--i >= 0) {
                this.set(i, source.get(i));
            }
        }

        private long qualityInc(int index, int initialIndex) {
            return (initialIndex - index & -1 >>> this.shift) << 6;
        }

        private boolean exceed(long distanceShift) {
            return (this.quality & 0xFFFFFFFFFFFFFFC0L) > (long)this.payloadSize << (int)distanceShift;
        }

        private void computeTolerance() {
            while (this.exceed(this.quality)) {
                ++this.quality;
            }
            if ((this.quality & 0xFFFFFFFFFFFFFFC0L) * 3L > ((long)this.payloadSize << (int)this.quality) * 2L) {
                ++this.quality;
            }
        }

        private long unamortizedCost() {
            return (this.quality >>> 6) + (long)this.payloadSize;
        }

        private void putValuesIntoEmptyCore(Core<K, V> source) {
            int i = source.length();
            while (--i >= 0) {
                int index;
                Object value = source.get(i);
                if (value == null || value == REMOVED) continue;
                int initialIndex = index = this.getInitialIndexByValue(value);
                while (this.get(index) != null) {
                    index = index - 1 & -1 >>> this.shift;
                }
                this.set(index, value);
                this.quality += this.qualityInc(index, initialIndex);
                ++this.payloadSize;
                ++this.overallSize;
                if (this.overallSize <= -1908874354 >>> this.shift) continue;
                throw new ConcurrentModificationException("Concurrent modification during rehash");
            }
        }

        private Core<K, V> rehashInternal(IndexerFunction<K, ? super V> indexer, int capacity) {
            capacity = Math.min(Math.max(capacity, this.payloadSize), 0x1C71C71C);
            long totalCost = this.amortizedCost + this.unamortizedCost();
            Core<K, ? super V> result = new Core<K, V>(indexer, capacity, this.exceed(7L) ? IndexedSet.nextMagic(this.magic, capacity) : this.magic);
            super.putValuesIntoEmptyCore(this);
            totalCost += super.unamortizedCost();
            if (super.exceed(7L)) {
                for (int k = 0; k < 3; ++k) {
                    Core<K, ? super V> other = new Core<K, V>(indexer, capacity, IndexedSet.nextMagic(this.magic, capacity));
                    super.putValuesIntoEmptyCore(this);
                    totalCost += super.unamortizedCost();
                    if (other.quality < result.quality) {
                        result = other;
                    }
                    if (!super.exceed(8 + k)) break;
                    capacity = Math.min(capacity * 2, 0x1C71C71C);
                }
            }
            super.computeTolerance();
            result.modCount = this.modCount;
            result.amortizedCost = totalCost - super.unamortizedCost();
            return result;
        }

        Core<K, V> rehash(IndexerFunction<K, ? super V> indexer, int capacity) {
            long modCount = this.modCount;
            Core<K, ? super V> result = this.rehashInternal(indexer, capacity);
            if (modCount != this.modCount) {
                throw new ConcurrentModificationException("Concurrent modification during rehash");
            }
            return result;
        }

        boolean needRehash() {
            return this.overallSize > -1908874354 >>> this.shift || this.exceed(this.quality);
        }

        Core<K, V> rehashIfNeeded(IndexerFunction<K, ? super V> indexer, int capacity) {
            return this.needRehash() ? this.rehash(indexer, capacity) : this;
        }

        Core<K, V> ensureCapacity(IndexerFunction<K, ? super V> indexer, int capacity) {
            return capacity > -1908874354 >>> this.shift && this.shift > 2 ? this.rehash(indexer, capacity) : this;
        }

        Core<K, V> trimToSize(IndexerFunction<K, ? super V> indexer) {
            return this.payloadSize < 795364314 >>> this.shift && this.shift < 29 ? this.rehash(indexer, 0) : this;
        }

        Core<K, V> clear() {
            if (this == EMPTY_CORE) {
                return this;
            }
            int i = this.length();
            while (--i >= 0) {
                this.set(i, null);
            }
            this.modCount += (long)this.payloadSize;
            this.amortizedCost += this.unamortizedCost();
            this.quality = 7L;
            this.payloadSize = 0;
            this.overallSize = 0;
            return this;
        }

        int size() {
            return this.payloadSize;
        }

        long getModCount() {
            return this.modCount;
        }

        int getInitialIndexByValue(V value) {
            return this.indexer.hashCodeByValue(value) * this.magic >>> this.shift;
        }

        V getByValue(V value) {
            Object testValue;
            int index = this.getInitialIndexByValue(value);
            while ((testValue = this.get(index)) != null) {
                if (testValue != REMOVED && this.indexer.matchesByValue(value, testValue)) {
                    return (V)testValue;
                }
                index = index - 1 & -1 >>> this.shift;
            }
            return null;
        }

        V getByKey(K key) {
            Object testValue;
            int index = this.indexer.hashCodeByKey(key) * this.magic >>> this.shift;
            while ((testValue = this.get(index)) != null) {
                if (testValue != REMOVED && this.indexer.matchesByKey(key, testValue)) {
                    return (V)testValue;
                }
                index = index - 1 & -1 >>> this.shift;
            }
            return null;
        }

        V getByKey(long key) {
            Object testValue;
            int index = this.indexer.hashCodeByKey(key) * this.magic >>> this.shift;
            while ((testValue = this.get(index)) != null) {
                if (testValue != REMOVED && this.indexer.matchesByKey(key, testValue)) {
                    return (V)testValue;
                }
                index = index - 1 & -1 >>> this.shift;
            }
            return null;
        }

        V put(V value, boolean replaceOnly) {
            Object testValue;
            int index;
            assert (this != EMPTY_CORE) : "Putting into EMPTY core.";
            assert (value != REMOVED) : "Value is an internal special marker object.";
            if (value == null) {
                throw new NullPointerException("Value is null.");
            }
            int initialIndex = index = this.getInitialIndexByValue(value);
            int removedIndex = -1;
            while ((testValue = this.get(index)) != null) {
                if (testValue != REMOVED && this.indexer.matchesByValue(value, testValue)) {
                    this.set(index, value);
                    return (V)testValue;
                }
                if (testValue == REMOVED && removedIndex < 0) {
                    removedIndex = index;
                }
                index = index - 1 & -1 >>> this.shift;
            }
            if (replaceOnly) {
                return null;
            }
            if (removedIndex < 0) {
                ++this.overallSize;
            } else {
                index = removedIndex;
            }
            this.set(index, value);
            this.quality += this.qualityInc(index, initialIndex);
            ++this.payloadSize;
            ++this.modCount;
            return null;
        }

        V removeValue(V value) {
            Object testValue;
            int index;
            int initialIndex = index = this.getInitialIndexByValue(value);
            while ((testValue = this.get(index)) != null) {
                if (testValue != REMOVED && this.indexer.matchesByValue(value, testValue)) {
                    this.removeAt(index, initialIndex);
                    return (V)testValue;
                }
                index = index - 1 & -1 >>> this.shift;
            }
            return null;
        }

        V removeKey(K key) {
            Object testValue;
            int index;
            int initialIndex = index = this.indexer.hashCodeByKey(key) * this.magic >>> this.shift;
            while ((testValue = this.get(index)) != null) {
                if (testValue != REMOVED && this.indexer.matchesByKey(key, testValue)) {
                    this.removeAt(index, initialIndex);
                    return (V)testValue;
                }
                index = index - 1 & -1 >>> this.shift;
            }
            return null;
        }

        V removeKey(long key) {
            Object testValue;
            int index;
            int initialIndex = index = this.indexer.hashCodeByKey(key) * this.magic >>> this.shift;
            while ((testValue = this.get(index)) != null) {
                if (testValue != REMOVED && this.indexer.matchesByKey(key, testValue)) {
                    this.removeAt(index, initialIndex);
                    return (V)testValue;
                }
                index = index - 1 & -1 >>> this.shift;
            }
            return null;
        }

        void removeAt(int index, int initialIndex) {
            this.set(index, REMOVED);
            this.quality -= this.qualityInc(index, initialIndex);
            --this.payloadSize;
            if (this.get(index - 1 & -1 >>> this.shift) == null) {
                while (this.get(index) == REMOVED) {
                    this.set(index, null);
                    --this.overallSize;
                    index = index + 1 & -1 >>> this.shift;
                }
            }
            ++this.modCount;
            this.amortizedCost += 2L * ((this.qualityInc(index, initialIndex) >>> 6) + 1L);
        }

        <T> T[] toArray(T[] a) {
            int size = this.payloadSize;
            Object[] result = a == null ? new Object[size] : (a.length >= size ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), size));
            int n = 0;
            int i = this.length();
            while (--i >= 0) {
                Object value = this.get(i);
                if (value == null || value == REMOVED) continue;
                if (n >= result.length) {
                    Object[] tmp = (Object[])Array.newInstance(result.getClass().getComponentType(), n + Math.min(n, i) + 1);
                    System.arraycopy(result, 0, tmp, 0, n);
                    result = tmp;
                }
                result[n++] = value;
            }
            if (n < result.length && a == null) {
                Object[] tmp = new Object[n];
                System.arraycopy(result, 0, tmp, 0, n);
                result = tmp;
            }
            if (n < result.length) {
                result[n] = null;
            }
            return result;
        }

        void writeObjectImpl(ObjectOutputStream out) throws IOException {
            int n = this.payloadSize;
            out.writeInt(n);
            int i = this.length();
            while (--i >= 0) {
                Object value = this.get(i);
                if (value == null || value == REMOVED || n-- <= 0) continue;
                out.writeObject(value);
            }
            if (n != 0) {
                throw new IOException("Concurrent modification detected.");
            }
        }

        static <K, V> Core<K, V> readObjectImpl(IndexerFunction<K, ? super V> indexer, ObjectInputStream in) throws IOException, ClassNotFoundException {
            int n = in.readInt();
            if (n == 0) {
                return EMPTY_CORE;
            }
            Core<K, Object> core = new Core<K, Object>(indexer, Math.abs(n), -1640531527);
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    core = core.rehashIfNeeded(indexer, n);
                    core.put(in.readObject(), false);
                }
            } else {
                Object value;
                while ((value = in.readObject()) != null) {
                    core = core.rehashIfNeeded(indexer, -n);
                    core.put(value, false);
                }
            }
            return core;
        }

        IndexedSetStats getStats() {
            return new IndexedSetStats(this.payloadSize, this.length(), this.quality >>> 6, this.amortizedCost + this.unamortizedCost(), this.modCount);
        }

        static {
            Core.EMPTY_CORE.overallSize = EMPTY_CORE.length();
        }
    }
}

