/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.util;

import com.devexperts.util.AbstractConcurrentSet;
import com.devexperts.util.IndexedSet;
import com.devexperts.util.Indexer;
import com.devexperts.util.IndexerFunction;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collector;
import javax.annotation.Nonnull;

public class IndexedMap<K, V>
implements Map<K, V>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 0L;
    private IndexedSet<K, V> set;
    private transient KeySet<K, V> keySet;
    private transient EntrySet<K, V> entrySet;

    public static <V> IndexedMap<V, V> create() {
        return new IndexedMap();
    }

    public static <V> IndexedMap<V, V> createIdentity() {
        return new IndexedMap(IndexerFunction.DEFAULT_IDENTITY_KEY);
    }

    public static <K, V> IndexedMap<K, V> create(IndexerFunction<K, ? super V> indexer) {
        return new IndexedMap<K, V>(indexer);
    }

    public static <K, V> IndexedMap<K, V> createIdentity(IndexerFunction.IdentityKey<K, ? super V> indexer) {
        return new IndexedMap<K, V>(indexer);
    }

    public static <V> IndexedMap<Integer, V> createInt(IndexerFunction.IntKey<? super V> indexer) {
        return new IndexedMap(indexer);
    }

    public static <V> IndexedMap<Long, V> createLong(IndexerFunction.LongKey<? super V> indexer) {
        return new IndexedMap(indexer);
    }

    @Deprecated
    public static <V> IndexedMap<Integer, V> create(IndexerFunction.IntKey<? super V> indexer) {
        return new IndexedMap(indexer);
    }

    @Deprecated
    public static <V> IndexedMap<Long, V> create(IndexerFunction.LongKey<? super V> indexer) {
        return new IndexedMap(indexer);
    }

    @Deprecated
    public static <K, V> IndexedMap<K, V> create(IndexerFunction<K, ? super V> indexer, int initialCapacity) {
        return new IndexedMap<K, V>(indexer, initialCapacity);
    }

    @Deprecated
    public static <V> IndexedMap<Integer, V> create(IndexerFunction.IntKey<? super V> indexer, int initialCapacity) {
        return new IndexedMap(indexer, initialCapacity);
    }

    @Deprecated
    public static <V> IndexedMap<Long, V> create(IndexerFunction.LongKey<? super V> indexer, int initialCapacity) {
        return new IndexedMap(indexer, initialCapacity);
    }

    @Deprecated
    public static <K, V> IndexedMap<K, V> create(IndexerFunction<K, ? super V> indexer, Collection<? extends V> c) {
        return new IndexedMap<K, V>(indexer, c);
    }

    @Deprecated
    public static <V> IndexedMap<Integer, V> create(IndexerFunction.IntKey<? super V> indexer, Collection<? extends V> c) {
        return new IndexedMap(indexer, c);
    }

    @Deprecated
    public static <V> IndexedMap<Long, V> create(IndexerFunction.LongKey<? super V> indexer, Collection<? extends V> c) {
        return new IndexedMap(indexer, c);
    }

    @Deprecated
    public static <K, V> IndexedMap<K, V> create(IndexerFunction<K, ? super V> indexer, Map<? extends K, ? extends V> map) {
        return new IndexedMap<K, V>(indexer, map);
    }

    @Deprecated
    public static <V> IndexedMap<Integer, V> create(IndexerFunction.IntKey<? super V> indexer, Map<Integer, ? extends V> map) {
        return new IndexedMap<Integer, V>(indexer, map);
    }

    @Deprecated
    public static <V> IndexedMap<Long, V> create(IndexerFunction.LongKey<? super V> indexer, Map<Long, ? extends V> map) {
        return new IndexedMap<Long, V>(indexer, map);
    }

    public static <V> Collector<V, ?, ? extends IndexedMap<V, V>> collector() {
        return IndexedMap.collector(IndexerFunction.DEFAULT);
    }

    public static <V> Collector<V, ?, ? extends IndexedMap<V, V>> collectorIdentity() {
        return IndexedMap.collector(IndexerFunction.DEFAULT_IDENTITY_KEY);
    }

    public static <K, V> Collector<V, ?, ? extends IndexedMap<K, V>> collector(IndexerFunction<K, ? super V> indexer) {
        return Collector.of(() -> IndexedMap.create(indexer), IndexedMap::put, (left, right) -> {
            left.putAll((Map)right);
            return left;
        }, Collector.Characteristics.UNORDERED, Collector.Characteristics.IDENTITY_FINISH);
    }

    public static <K, V> Collector<V, ?, ? extends IndexedMap<K, V>> collectorIdentity(IndexerFunction.IdentityKey<K, ? super V> indexer) {
        return IndexedMap.collector(indexer);
    }

    public static <V> Collector<V, ?, ? extends IndexedMap<Integer, V>> collectorInt(IndexerFunction.IntKey<? super V> indexer) {
        return IndexedMap.collector(indexer);
    }

    public static <V> Collector<V, ?, ? extends IndexedMap<Long, V>> collectorLong(IndexerFunction.LongKey<? super V> indexer) {
        return IndexedMap.collector(indexer);
    }

    @Deprecated
    public static <V> Collector<V, ?, ? extends IndexedMap<Integer, V>> collector(IndexerFunction.IntKey<? super V> indexer) {
        return IndexedMap.collector(indexer);
    }

    @Deprecated
    public static <V> Collector<V, ?, ? extends IndexedMap<Long, V>> collector(IndexerFunction.LongKey<? super V> indexer) {
        return IndexedMap.collector(indexer);
    }

    public IndexedMap() {
        this(0);
    }

    public IndexedMap(int initialCapacity) {
        this(IndexerFunction.DEFAULT, initialCapacity);
    }

    protected IndexedMap(IndexerFunction<K, ? super V> indexer) {
        this(indexer, 0);
    }

    @Deprecated
    public IndexedMap(Indexer<K, ? super V> indexer) {
        this((IndexerFunction<K, ? super V>)indexer);
    }

    protected IndexedMap(IndexerFunction<K, ? super V> indexer, int initialCapacity) {
        this.set = new IndexedSet<K, V>(indexer, initialCapacity);
    }

    @Deprecated
    public IndexedMap(Indexer<K, ? super V> indexer, int initialCapacity) {
        this((IndexerFunction<K, ? super V>)indexer, initialCapacity);
    }

    public IndexedMap(Collection<V> c) {
        this(c instanceof IndexedSet ? ((IndexedSet)c).getIndexerFunction() : IndexerFunction.DEFAULT, c);
    }

    protected IndexedMap(IndexerFunction<K, ? super V> indexer, Collection<? extends V> c) {
        this(indexer, c.size());
        this.putAll(c);
    }

    @Deprecated
    public IndexedMap(Indexer<K, ? super V> indexer, Collection<? extends V> c) {
        this((IndexerFunction<K, ? extends V>)indexer, c);
    }

    public IndexedMap(Map<K, V> map) {
        this(map instanceof IndexedMap ? ((IndexedMap)map).getIndexerFunction() : IndexerFunction.DEFAULT, map);
    }

    protected IndexedMap(IndexerFunction<K, ? super V> indexer, Map<? extends K, ? extends V> map) {
        this(indexer, map.size());
        this.putAll(map);
    }

    @Deprecated
    public IndexedMap(Indexer<K, ? super V> indexer, Map<? extends K, ? extends V> map) {
        this((IndexerFunction<? extends K, ? extends V>)indexer, map);
    }

    public IndexedMap(IndexedSet<K, V> set, boolean wrap) {
        if (set == null) {
            throw new NullPointerException("Set is null.");
        }
        this.set = wrap ? set : new IndexedSet(set.getIndexerFunction(), set);
    }

    public IndexedMap<K, V> clone() {
        try {
            IndexedMap result = (IndexedMap)super.clone();
            result.set = result.set.clone();
            result.keySet = null;
            result.entrySet = null;
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public IndexedMap<K, V> withCapacity(int capacity) {
        this.ensureCapacity(capacity);
        return this;
    }

    public IndexedMap<K, V> withElements(Collection<? extends V> c) {
        this.ensureCapacity(c.size());
        this.putAll(c);
        return this;
    }

    public IndexedMap<K, V> withElements(Map<K, ? extends V> map) {
        this.ensureCapacity(map.size());
        this.putAll(map);
        return this;
    }

    public void ensureCapacity(int capacity) {
        this.set.ensureCapacity(capacity);
    }

    public void trimToSize() {
        this.set.trimToSize();
    }

    @Override
    public void clear() {
        this.set.clear();
    }

    @Deprecated
    public Indexer<K, ? super V> getIndexer() {
        return this.set.getIndexer();
    }

    public IndexerFunction<K, ? super V> getIndexerFunction() {
        return this.set.getIndexerFunction();
    }

    public IndexedSet<K, V> getIndexedSet() {
        return this.set;
    }

    @Override
    @Nonnull
    public Collection<V> values() {
        return this.set;
    }

    @Override
    @Nonnull
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet<K, V>(this.set);
        }
        return this.keySet;
    }

    @Override
    @Nonnull
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet<K, V>(this.set);
        }
        return this.entrySet;
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public V get(Object key) {
        return this.set.getByKey(key);
    }

    public V getByValue(V value) {
        return this.set.getByValue(value);
    }

    public V getByKey(K key) {
        return this.set.getByKey(key);
    }

    public V getByKey(long key) {
        return this.set.getByKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.set.containsValue(value);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.set.containsKey(key);
    }

    public boolean containsKey(long key) {
        return this.set.containsKey(key);
    }

    public V put(V value) {
        return this.set.put(value);
    }

    @Override
    public V put(K key, V value) {
        if (!this.set.getIndexerFunction().matchesByKey(key, value)) {
            throw new IllegalArgumentException("Key does not match value.");
        }
        return this.set.put(value);
    }

    @Override
    public V remove(Object key) {
        return this.set.removeKey(key);
    }

    public V removeValue(V value) {
        return this.set.removeValue(value);
    }

    public V removeKey(K key) {
        return this.set.removeKey(key);
    }

    public V removeKey(long key) {
        return this.set.removeKey(key);
    }

    public void putAll(Collection<? extends V> c) {
        this.set.addAll(c);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        if (!(map instanceof IndexedMap)) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                if (this.set.getIndexerFunction().matchesByKey(e.getKey(), e.getValue())) continue;
                throw new IllegalArgumentException("Key does not match value.");
            }
        }
        this.set.addAll(map.values());
    }

    @Override
    public boolean equals(Object o) {
        return o == this || o instanceof Map && this.entrySet().equals(((Map)o).entrySet());
    }

    @Override
    public int hashCode() {
        return this.entrySet().hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.set.size() * 5 + 10);
        sb.append("{");
        String separator = "";
        for (V value : this.set) {
            sb.append(separator);
            sb.append(this.set.getIndexerFunction().getObjectKey(value));
            sb.append("=");
            sb.append(value);
            separator = ", ";
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class EntrySet<K, V>
    extends AbstractConcurrentSet<Map.Entry<K, V>>
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private final IndexedSet<K, V> set;

        EntrySet(IndexedSet<K, V> set) {
            this.set = set;
        }

        @Override
        public void clear() {
            this.set.clear();
        }

        @Override
        public int size() {
            return this.set.size();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.set.getIndexerFunction().matchesByKey(e.getKey(), e.getValue()) && this.set.containsValue(e.getValue());
        }

        @Override
        @Nonnull
        public Iterator<Map.Entry<K, V>> iterator() {
            return this.set.entryIterator();
        }

        @Override
        public boolean add(Map.Entry<K, V> e) {
            if (!this.set.getIndexerFunction().matchesByKey(e.getKey(), e.getValue())) {
                throw new IllegalArgumentException("Key does not match value.");
            }
            return this.set.add(e.getValue());
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.set.getIndexerFunction().matchesByKey(e.getKey(), e.getValue()) && this.set.remove(e.getValue());
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.set.removeAllEntries(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.set.retainAllEntries(c);
        }

        @Override
        public boolean removeIf(Predicate<? super Map.Entry<K, V>> filter) {
            return this.set.removeEntryIf(filter);
        }
    }

    private static final class KeySet<K, V>
    extends AbstractConcurrentSet<K>
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private final IndexedSet<K, V> set;

        KeySet(IndexedSet<K, V> set) {
            this.set = set;
        }

        @Override
        public void clear() {
            this.set.clear();
        }

        @Override
        public int size() {
            return this.set.size();
        }

        @Override
        public boolean contains(Object o) {
            return this.set.containsKey(o);
        }

        @Override
        @Nonnull
        public Iterator<K> iterator() {
            return this.set.keyIterator();
        }

        @Override
        public boolean add(K o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            return this.set.removeKey(o) != null;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.set.removeAllKeys(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.set.retainAllKeys(c);
        }

        @Override
        public boolean removeIf(Predicate<? super K> filter) {
            return this.set.removeKeyIf(filter);
        }
    }
}

