/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.util;

import com.devexperts.logging.Logging;
import com.devexperts.util.LoggedThreadPoolExecutor;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;

public class ExecutorProvider {
    private static final int AUTO_THREADS = -1;
    private static final int FIXED_EXECUTOR_THREADS = 0;
    private static final int MIN_THREADS = 1;
    private final int nThreads;
    private final String name;
    private final Logging log;
    private Executor createdExecutor;
    private int refCount;

    public ExecutorProvider(String name, Logging log) {
        this.log = log;
        this.nThreads = -1;
        this.name = name;
    }

    public ExecutorProvider(int nThreads, String name, Logging log) {
        this.nThreads = Math.max(1, nThreads);
        this.name = name;
        this.log = log;
    }

    public ExecutorProvider(Executor executor) {
        this.nThreads = 0;
        this.name = null;
        this.log = null;
        this.createdExecutor = executor;
    }

    public Reference newReference() {
        return new Reference();
    }

    private synchronized Executor useReference() {
        if (this.refCount++ == 0 && this.nThreads != 0) {
            int nThreads = this.nThreads == -1 ? Math.max(1, Runtime.getRuntime().availableProcessors()) : this.nThreads;
            this.createdExecutor = new LoggedThreadPoolExecutor(nThreads, this.name, this.log);
        }
        return this.createdExecutor;
    }

    private synchronized void releaseReference(Executor executor) {
        this.log.trace("Release reference for " + executor + ". CreatedExecutor = " + this.createdExecutor + ", refCount = " + this.refCount);
        if (executor == null || executor != this.createdExecutor) {
            return;
        }
        assert (this.refCount > 0);
        if (--this.refCount == 0 && this.nThreads != 0) {
            ((ExecutorService)this.createdExecutor).shutdown();
            this.createdExecutor = null;
        }
    }

    public class Reference {
        private volatile Executor executor;
        private boolean closed;

        private Reference() {
        }

        public Executor getOrCreateExecutor() {
            Executor executor = this.executor;
            if (executor != null) {
                return executor;
            }
            return this.getOrCreateExecutorSync();
        }

        private synchronized Executor getOrCreateExecutorSync() {
            if (this.executor != null) {
                return this.executor;
            }
            if (!this.closed) {
                this.executor = ExecutorProvider.this.useReference();
            }
            return this.executor;
        }

        public synchronized void setExecutor(Executor executor) {
            if (executor == null) {
                throw new NullPointerException();
            }
            if (executor == this.executor) {
                return;
            }
            if (!this.closed) {
                ExecutorProvider.this.releaseReference(this.executor);
            }
            this.executor = executor;
        }

        public synchronized void close() {
            if (!this.closed) {
                ExecutorProvider.this.releaseReference(this.executor);
                this.closed = true;
            }
        }
    }
}

