/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.util;

import com.devexperts.util.MathUtil;

public class DayUtil {
    private static final int[] DAY_OF_YEAR = new int[]{0, 0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365};

    private DayUtil() {
    }

    public static int getDayIdByYearMonthDay(int year, int month, int day) {
        if (month < 1 || month > 12) {
            throw new IllegalArgumentException("invalid month " + month);
        }
        int dayOfYear = DAY_OF_YEAR[month] + day - 1;
        if (month > 2 && year % 4 == 0 && (year % 100 != 0 || year % 400 == 0)) {
            ++dayOfYear;
        }
        return year * 365 + MathUtil.div(year - 1, 4) - MathUtil.div(year - 1, 100) + MathUtil.div(year - 1, 400) + dayOfYear - 719527;
    }

    public static int getDayIdByYearMonthDay(int yyyymmdd) {
        if (yyyymmdd >= 0) {
            return DayUtil.getDayIdByYearMonthDay(yyyymmdd / 10000, yyyymmdd / 100 % 100, yyyymmdd % 100);
        }
        return DayUtil.getDayIdByYearMonthDay(-(-yyyymmdd / 10000), -yyyymmdd / 100 % 100, -yyyymmdd % 100);
    }

    public static int getYearMonthDayByDayId(int dayId) {
        int j = dayId + 2472632;
        int g = MathUtil.div(j, 146097);
        int dg = j - g * 146097;
        int c = (dg / 36524 + 1) * 3 / 4;
        int dc = dg - c * 36524;
        int b = dc / 1461;
        int db = dc - b * 1461;
        int a = (db / 365 + 1) * 3 / 4;
        int da = db - a * 365;
        int y = g * 400 + c * 100 + b * 4 + a;
        int m = (da * 5 + 308) / 153 - 2;
        int d = da - (m + 4) * 153 / 5 + 122;
        int yyyy = y - 4800 + (m + 2) / 12;
        int mm = (m + 2) % 12 + 1;
        int dd = d + 1;
        int yyyymmdd = Math.abs(yyyy) * 10000 + mm * 100 + dd;
        return yyyy >= 0 ? yyyymmdd : -yyyymmdd;
    }
}

