/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.util;

import com.devexperts.util.DayUtil;
import com.devexperts.util.MathUtil;
import java.io.Serializable;

public class DayRange
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static final int WEEK_EPOCH = DayUtil.getDayIdByYearMonthDay(19700105);
    private static final int EARLIEST_DAY_ID = DayUtil.getDayIdByYearMonthDay(0, 1, 1);
    private final int startDayId;
    private final int endDayId;

    private DayRange(int startDayId, int endDayId) {
        this.startDayId = startDayId;
        this.endDayId = endDayId;
    }

    public boolean containsDayId(int dayId) {
        return dayId >= this.startDayId && dayId < this.endDayId;
    }

    public int getStartDayId() {
        return this.startDayId;
    }

    public int getStartYmd() {
        return DayUtil.getYearMonthDayByDayId(this.startDayId);
    }

    public int getEndDayId() {
        return this.endDayId;
    }

    public int getEndYmd() {
        return DayUtil.getYearMonthDayByDayId(this.endDayId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DayRange dayRange = (DayRange)o;
        if (this.startDayId != dayRange.startDayId) {
            return false;
        }
        return this.endDayId == dayRange.endDayId;
    }

    public int hashCode() {
        int result = this.startDayId;
        result = 31 * result + this.endDayId;
        return result;
    }

    public String toString() {
        return "DayRange{" + this.getStartYmd() + ", " + this.getEndYmd() + "}";
    }

    public static DayRange getWeekRangeByDayId(int dayId, int numberOfWeeks) {
        if (dayId < EARLIEST_DAY_ID) {
            throw new IllegalArgumentException("Incorrect dayId = " + dayId);
        }
        if (numberOfWeeks <= 0 || numberOfWeeks > 1000) {
            throw new IllegalArgumentException("Incorrect numberOfWeeks = " + numberOfWeeks);
        }
        int periodDurationInDays = 7 * numberOfWeeks;
        int startDayId = dayId - MathUtil.rem(dayId - WEEK_EPOCH, periodDurationInDays);
        int endDayId = startDayId + periodDurationInDays;
        return new DayRange(startDayId, endDayId);
    }

    public static DayRange getMonthRangeByDayId(int dayId, int numberOfMonths) {
        if (dayId < EARLIEST_DAY_ID) {
            throw new IllegalArgumentException("Incorrect dayId = " + dayId);
        }
        if (numberOfMonths <= 0 || numberOfMonths > 1000) {
            throw new IllegalArgumentException("Incorrect numberOfMonths = " + numberOfMonths);
        }
        int yyyymmdd = DayUtil.getYearMonthDayByDayId(dayId);
        int monthId = (yyyymmdd / 10000 - 1970) * 12 + (yyyymmdd / 100 % 100 - 1);
        int startMonthId = monthId - MathUtil.rem(monthId, numberOfMonths);
        int endMonthId = startMonthId + numberOfMonths;
        int startDayId = DayUtil.getDayIdByYearMonthDay(MathUtil.div(startMonthId, 12) + 1970, MathUtil.rem(startMonthId, 12) + 1, 1);
        int endDayId = DayUtil.getDayIdByYearMonthDay(MathUtil.div(endMonthId, 12) + 1970, MathUtil.rem(endMonthId, 12) + 1, 1);
        return new DayRange(startDayId, endDayId);
    }

    public static DayRange getYearRangeByDayId(int dayId, int numberOfYears) {
        if (dayId < EARLIEST_DAY_ID) {
            throw new IllegalArgumentException("Incorrect dayId = " + dayId);
        }
        if (numberOfYears <= 0 || numberOfYears > 1000) {
            throw new IllegalArgumentException("Incorrect numberOfYears = " + numberOfYears);
        }
        int year = DayUtil.getYearMonthDayByDayId(dayId) / 10000;
        int startYear = year - MathUtil.rem(year - 1970, numberOfYears);
        int endYear = startYear + numberOfYears;
        int startDayId = DayUtil.getDayIdByYearMonthDay(startYear, 1, 1);
        int endDayId = DayUtil.getDayIdByYearMonthDay(endYear, 1, 1);
        return new DayRange(startDayId, endDayId);
    }
}

