/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.util;

import com.devexperts.util.InvalidFormatException;
import com.devexperts.util.TimeFormat;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Locale;

public class ConfigUtil {
    private ConfigUtil() {
    }

    public static Object convertStringToObject(Class<?> type, String value) throws InvalidFormatException {
        if (value == null) {
            return null;
        }
        try {
            if (type == String.class) {
                return value;
            }
            if (type == Integer.TYPE) {
                return (int)ConfigUtil.parseLong(value);
            }
            if (type == Long.TYPE) {
                return ConfigUtil.parseLong(value.endsWith("l") || value.endsWith("L") ? value.substring(0, value.length() - 1) : value);
            }
            if (type == Double.TYPE) {
                return ConfigUtil.parseDouble(value);
            }
            if (type == Float.TYPE) {
                return Float.valueOf((float)ConfigUtil.parseDouble(value));
            }
            if (type == Boolean.TYPE) {
                return value.isEmpty() ? true : Boolean.valueOf(value);
            }
            if (type == Date.class) {
                return TimeFormat.DEFAULT.parse(value);
            }
            if (Enum.class.isAssignableFrom(type)) {
                value = value.toUpperCase(Locale.US);
            }
            try {
                Method m = type.getMethod("valueOf", String.class);
                return m.invoke(null, value);
            }
            catch (NoSuchMethodException m) {
            }
            catch (IllegalAccessException e) {
                throw new InvalidFormatException("Cannot access conversion method: " + e.getMessage(), e);
            }
            catch (InvocationTargetException e) {
                throw new InvalidFormatException(e.getTargetException().getMessage(), e);
            }
            throw new InvalidFormatException("Unsupported property type \"" + type.getName() + "\"");
        }
        catch (NumberFormatException e) {
            throw new InvalidFormatException("Value should be a number", e);
        }
    }

    private static long getMultiplier(String value) {
        if (value.isEmpty()) {
            throw new InvalidFormatException("Cannot parse numeric value from an empty string");
        }
        long multiplier = 1L;
        char c = value.charAt(value.length() - 1);
        if (Character.isLetter(c)) {
            switch (Character.toUpperCase(c)) {
                case 'B': {
                    break;
                }
                case 'K': {
                    multiplier = 1024L;
                    break;
                }
                case 'M': {
                    multiplier = 0x100000L;
                    break;
                }
                case 'G': {
                    multiplier = 0x40000000L;
                    break;
                }
                default: {
                    throw new InvalidFormatException("Cannot parse numeric value from string \"" + value + "\"");
                }
            }
        }
        return multiplier;
    }

    private static long parseLong(String value) throws InvalidFormatException {
        if (value.equalsIgnoreCase("max")) {
            return Long.MAX_VALUE;
        }
        long multiplier = ConfigUtil.getMultiplier(value);
        if (multiplier != 1L) {
            value = value.substring(0, value.length() - 1);
        }
        try {
            return Long.parseLong(value) * multiplier;
        }
        catch (NumberFormatException e) {
            throw new InvalidFormatException("Cannot parse integer value from string \"" + value + "\"");
        }
    }

    private static double parseDouble(String value) throws InvalidFormatException {
        if (value.equalsIgnoreCase("max")) {
            return Double.MAX_VALUE;
        }
        long multiplier = ConfigUtil.getMultiplier(value);
        if (multiplier != 1L) {
            value = value.substring(0, value.length() - 1);
        }
        try {
            return Double.parseDouble(value) * (double)multiplier;
        }
        catch (NumberFormatException e) {
            throw new InvalidFormatException("Cannot parse numeric value from string \"" + value + "\"");
        }
    }
}

