/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.util;

import com.devexperts.util.InvalidFormatException;
import java.util.Arrays;

public final class Base64 {
    public static final Base64 DEFAULT = new Base64("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=");
    public static final Base64 URLSAFE = new Base64("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_=");
    public static final Base64 DEFAULT_UNPADDED = new Base64(DEFAULT.getAlphabet().substring(0, 64));
    public static final Base64 URLSAFE_UNPADDED = new Base64(URLSAFE.getAlphabet().substring(0, 64));
    private final String alphabet;
    private final char[] ca;
    private final int[] ia;
    private final int pad;

    public Base64(String alphabet) {
        if (alphabet.length() != 64 && alphabet.length() != 65) {
            throw new IllegalArgumentException("Alphabet should have 64 characters plus optional pad character.");
        }
        this.alphabet = alphabet;
        this.ca = alphabet.toCharArray();
        this.ia = new int[256];
        Arrays.fill(this.ia, -1);
        for (int i = 0; i < 64; ++i) {
            if (this.ia[this.ca[i]] != -1) {
                throw new IllegalArgumentException("Alphabet contains duplicate character '" + this.ca[i] + "'.");
            }
            this.ia[this.ca[i]] = i;
        }
        int n = this.pad = alphabet.length() == 64 ? -1 : (int)alphabet.charAt(64);
        if (this.pad >= 0 && this.ia[this.pad] != -1) {
            throw new IllegalArgumentException("Alphabet contains pad character '" + (char)this.pad + "'.");
        }
    }

    public String getAlphabet() {
        return this.alphabet;
    }

    public String encode(byte[] source) {
        if (source == null) {
            return "";
        }
        int sourceLength = source.length;
        int resultLength = this.pad >= 0 ? (sourceLength + 2) / 3 * 4 : (sourceLength * 4 + 2) / 3;
        char[] result = new char[resultLength];
        int ri = 0;
        for (int si = 0; si < sourceLength; si += 3) {
            int val = (source[si] & 0xFF) << 16;
            if (si + 1 < sourceLength) {
                val |= (source[si + 1] & 0xFF) << 8;
            }
            if (si + 2 < sourceLength) {
                val |= source[si + 2] & 0xFF;
            }
            result[ri++] = this.ca[val >> 18 & 0x3F];
            result[ri++] = this.ca[val >> 12 & 0x3F];
            if (ri < resultLength) {
                char c = result[ri++] = si + 1 < sourceLength ? this.ca[val >> 6 & 0x3F] : (char)this.pad;
            }
            if (ri >= resultLength) continue;
            result[ri++] = si + 2 < sourceLength ? this.ca[val & 0x3F] : (char)this.pad;
        }
        return new String(result);
    }

    public byte[] decode(String source) {
        if (source == null) {
            return new byte[0];
        }
        int sourceLength = source.length();
        int validCount = 0;
        int padCount = 0;
        for (int i = 0; i < sourceLength; ++i) {
            char c = source.charAt(i);
            if (this.ia[c] >= 0) {
                ++validCount;
                if (padCount <= 0) continue;
                throw new InvalidFormatException("Encoded text has pad character in the middle.");
            }
            if (c != this.pad) continue;
            ++padCount;
        }
        if (validCount % 4 == 1) {
            throw new InvalidFormatException("Encoded text has incomplete character.");
        }
        if (this.pad >= 0 && (validCount + padCount) % 4 != 0) {
            throw new InvalidFormatException("Encoded text length is not multiple of 4.");
        }
        int resultLength = validCount * 3 / 4;
        byte[] result = new byte[resultLength];
        int si = 0;
        int ri = 0;
        while (ri < resultLength) {
            int val = 0;
            int shift = 24;
            while (shift > 0 && si < sourceLength) {
                int index;
                if ((index = this.ia[source.charAt(si++)]) < 0) continue;
                val |= index << (shift -= 6);
            }
            result[ri++] = (byte)(val >> 16);
            if (ri < resultLength) {
                result[ri++] = (byte)(val >> 8);
            }
            if (ri >= resultLength) continue;
            result[ri++] = (byte)val;
        }
        return result;
    }

    public String toString() {
        return "Base64[" + this.alphabet + "]";
    }
}

