/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.util;

import java.util.Arrays;

public class ArrayUtil {
    public static final int MIN_CAPACITY = 8;
    public static final int MAX_CAPACITY = 2146483647;

    private ArrayUtil() {
    }

    public static int findFreeIndex(Object[] a, int lastFoundIndex, int minIndex) {
        for (int i = lastFoundIndex; i < a.length; ++i) {
            if (a[i] != null) continue;
            return i;
        }
        int freeCount = 0;
        int firstFreeIndex = 0;
        int i = lastFoundIndex;
        while (--i >= minIndex) {
            if (a[i] != null) continue;
            ++freeCount;
            firstFreeIndex = i;
        }
        return freeCount <= a.length >> 2 ? a.length : firstFreeIndex;
    }

    private static int growSize(int n, int minCapacity) {
        if (n >= 2146483647 || minCapacity > 2146483647) {
            throw new IllegalArgumentException("Array size is too large");
        }
        return n <= 1073241823 ? Math.max(Math.max(minCapacity, 8), n << 1) : 2146483647;
    }

    public static <T> T[] grow(T[] a, int minCapacity) {
        return Arrays.copyOf(a, ArrayUtil.growSize(a.length, minCapacity));
    }

    public static boolean[] grow(boolean[] a, int minCapacity) {
        return Arrays.copyOf(a, ArrayUtil.growSize(a.length, minCapacity));
    }

    public static byte[] grow(byte[] a, int minCapacity) {
        return Arrays.copyOf(a, ArrayUtil.growSize(a.length, minCapacity));
    }

    public static char[] grow(char[] a, int minCapacity) {
        return Arrays.copyOf(a, ArrayUtil.growSize(a.length, minCapacity));
    }

    public static int[] grow(int[] a, int minCapacity) {
        return Arrays.copyOf(a, ArrayUtil.growSize(a.length, minCapacity));
    }

    public static long[] grow(long[] a, int minCapacity) {
        return Arrays.copyOf(a, ArrayUtil.growSize(a.length, minCapacity));
    }
}

