/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.util;

import com.devexperts.util.LongCollection;
import com.devexperts.util.LongIterator;
import com.devexperts.util.LongSet;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;

public abstract class AbstractLongSet
extends AbstractSet<Long>
implements LongSet {
    @Override
    public abstract int size();

    @Override
    public abstract void clear();

    @Override
    public abstract boolean contains(long var1);

    @Override
    public abstract boolean remove(long var1);

    @Override
    public abstract LongIterator longIterator();

    @Override
    public final boolean containsAll(Collection<?> c) {
        if (c instanceof LongCollection) {
            LongCollection lc = (LongCollection)c;
            LongIterator e = lc.longIterator();
            while (e.hasNext()) {
                if (this.contains(e.nextLong())) continue;
                return false;
            }
            return true;
        }
        return super.containsAll(c);
    }

    @Override
    public final boolean addAll(Collection<? extends Long> c) {
        if (c instanceof LongCollection) {
            LongCollection lc = (LongCollection)c;
            boolean modified = false;
            LongIterator e = lc.longIterator();
            while (e.hasNext()) {
                if (!this.add(e.nextLong())) continue;
                modified = true;
            }
            return modified;
        }
        return super.addAll(c);
    }

    @Override
    public final boolean removeAll(Collection<?> c) {
        if (c instanceof LongCollection) {
            LongCollection lc = (LongCollection)c;
            boolean modified = false;
            if (this.size() > lc.size()) {
                LongIterator i = lc.longIterator();
                while (i.hasNext()) {
                    modified |= this.remove(i.nextLong());
                }
            } else {
                LongIterator i = this.longIterator();
                while (i.hasNext()) {
                    if (!lc.contains(i.nextLong())) continue;
                    i.remove();
                    modified = true;
                }
            }
            return modified;
        }
        return super.removeAll(c);
    }

    @Override
    public final boolean retainAll(Collection<?> c) {
        if (c instanceof LongCollection) {
            LongCollection lc = (LongCollection)c;
            boolean modified = false;
            LongIterator e = this.longIterator();
            while (e.hasNext()) {
                if (lc.contains(e.nextLong())) continue;
                e.remove();
                modified = true;
            }
            return modified;
        }
        return super.retainAll(c);
    }

    @Override
    public boolean add(long key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean contains(Object o) {
        return o instanceof Long && this.contains((Long)o);
    }

    @Override
    public final Iterator<Long> iterator() {
        return this.longIterator();
    }

    @Override
    public final boolean add(Long o) {
        return this.add((long)o);
    }

    @Override
    public final boolean remove(Object o) {
        return o instanceof Long && this.remove((Long)o);
    }

    @Override
    public long[] toLongArray() {
        long[] result = new long[this.size()];
        LongIterator e = this.longIterator();
        int i = 0;
        while (e.hasNext()) {
            result[i] = e.nextLong();
            ++i;
        }
        return result;
    }
}

