/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.services;

import com.devexperts.io.URLInputStream;
import com.devexperts.logging.Logging;
import com.devexperts.services.OverrideURLClassLoader;
import com.devexperts.services.Service;
import com.devexperts.services.ServiceProvider;
import com.devexperts.services.StartupService;
import com.devexperts.services.SupersedesService;
import com.devexperts.util.SystemProperties;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;

public class Services {
    public static final String META_INF_SERVICES = "META-INF/services/";
    private static final String DISABLE_SUFFIX = ".disable";
    private static boolean startupsStarted;

    @Deprecated
    protected Services() {
    }

    private static Logging log() {
        return Logging.getLogging(Services.class);
    }

    public static synchronized void startup() {
        if (!startupsStarted) {
            startupsStarted = true;
            for (StartupService startup : Services.createServices(StartupService.class, null)) {
                try {
                    startup.start();
                }
                catch (Throwable t) {
                    Services.log().error("Cannot start startup", t);
                }
            }
        }
    }

    public static <T> T createService(Class<T> serviceClass, ClassLoader loader, String implClassName) {
        List<Class<T>> list;
        String serviceName = serviceClass.getName();
        String className = implClassName;
        if (className == null && loader == null) {
            className = SystemProperties.getProperty(serviceName, null);
        }
        if (className != null && loader == null) {
            int i = className.indexOf(33);
            if (i < 0 && className.toLowerCase(Locale.US).endsWith(".jar")) {
                className = className + "!";
                i = className.length() - 1;
            }
            if (i >= 0) {
                String jarName = className.substring(0, i).trim();
                className = className.substring(i + 1).trim();
                if (jarName.length() > 0) {
                    try {
                        loader = new OverrideURLClassLoader(new URL[]{URLInputStream.resolveURL(jarName)});
                    }
                    catch (MalformedURLException e) {
                        throw new IllegalArgumentException("Service property " + serviceName + " has malformed jar file name " + jarName);
                    }
                }
            }
            if (className.isEmpty()) {
                className = null;
            }
        }
        if (className != null) {
            return Services.createOrGetInstance(serviceClass, loader, Services.loadServiceClass(serviceClass, loader, className));
        }
        Service serviceAnnotation = serviceClass.getAnnotation(Service.class);
        if (serviceAnnotation != null && serviceAnnotation.combineMethod().length() > 0) {
            list = Services.createInOrder(serviceClass, loader);
            return (T)(list.isEmpty() ? null : (list.size() == 1 ? list.get(0) : Services.invokeStaticMethod(serviceClass, loader, serviceAnnotation.combineMethod(), list)));
        }
        list = Services.loadServiceClasses(serviceClass, loader);
        return list.isEmpty() ? null : (T)Services.createOrGetInstance(serviceClass, loader, list.get(0));
    }

    public static <T> Iterable<T> createServices(Class<T> serviceClass, ClassLoader loader) {
        return Services.createInOrder(serviceClass, loader);
    }

    private static Object invokeStaticMethod(Class<?> serviceClass, ClassLoader loader, String methodName, Object argument) {
        int i = methodName.lastIndexOf(46);
        if (i >= 0) {
            String className = methodName.substring(0, i);
            methodName = methodName.substring(i + 1);
            if ((serviceClass = Services.loadServiceClass(serviceClass, loader, className)) == null) {
                return null;
            }
        }
        Class<?> argClass = argument.getClass();
        Method method = null;
        for (Method m : serviceClass.getMethods()) {
            Class<?>[] pts;
            if (!Modifier.isStatic(m.getModifiers()) || !m.getName().equals(methodName) || (pts = m.getParameterTypes()).length != 1 || !pts[0].isAssignableFrom(argClass)) continue;
            if (method != null) {
                Services.log().error("Ambiguous method " + methodName + " on " + serviceClass.getName() + " for parameter class " + argClass.getName());
                return null;
            }
            method = m;
        }
        if (method == null) {
            Services.log().error("Cannot find suitable method " + methodName + " on " + serviceClass.getName() + " for parameter class " + argClass.getName());
            return null;
        }
        try {
            return method.invoke(null, argument);
        }
        catch (Exception e) {
            Services.log().error("Exception while invoking method " + methodName + " on " + serviceClass.getName() + " for parameter class " + argClass.getName(), e);
            return null;
        }
    }

    private static <T> List<T> createInOrder(Class<T> serviceClass, ClassLoader loader) {
        ArrayList<T> instances = new ArrayList<T>();
        for (Class<T> clazz : Services.loadServiceClasses(serviceClass, loader)) {
            T instance = Services.createOrGetInstance(serviceClass, loader, clazz);
            if (instance == null) continue;
            instances.add(instance);
        }
        return instances;
    }

    private static <T> ClassLoader resolveLoader(ClassLoader loader, Class<T> serviceClass) {
        if (loader == null) {
            loader = serviceClass.getClassLoader();
        }
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        return loader;
    }

    private static <T> Class<? extends T> loadServiceClass(Class<T> serviceClass, ClassLoader loader, String className) {
        try {
            return Class.forName(className.trim(), false, Services.resolveLoader(loader, serviceClass));
        }
        catch (ClassNotFoundException e) {
            Services.log().error("Cannot find " + className, e);
            return null;
        }
    }

    private static <T> T createOrGetInstance(Class<T> serviceClass, ClassLoader loader, Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        try {
            Object instance = null;
            try {
                Method getInstance = clazz.getDeclaredMethod("getInstance", new Class[0]);
                int m = getInstance.getModifiers();
                if (Modifier.isStatic(m) && Modifier.isPublic(m)) {
                    instance = getInstance.invoke(null, new Object[0]);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (instance == null) {
                instance = clazz.newInstance();
            }
            instance = Services.adaptInstanceIfNeeded(serviceClass, loader, instance);
            instance = Services.upgradeInstanceIfNeeded(serviceClass, loader, instance);
            return (T)instance;
        }
        catch (Exception e) {
            Services.log().error("Cannot create " + clazz.getName(), e);
            return null;
        }
    }

    private static Object adaptInstanceIfNeeded(Class<?> serviceClass, ClassLoader loader, Object instance) throws Exception {
        if (serviceClass.isInstance(instance)) {
            return instance;
        }
        SupersedesService supersedesAnnotation = serviceClass.getAnnotation(SupersedesService.class);
        if (supersedesAnnotation != null) {
            instance = Services.adaptInstanceIfNeeded(supersedesAnnotation.value(), loader, instance);
            if (serviceClass.isInstance(instance)) {
                return instance;
            }
            if (supersedesAnnotation.adapterMethod().length() > 0 && serviceClass.isInstance(instance = Services.invokeStaticMethod(serviceClass, loader, supersedesAnnotation.adapterMethod(), instance))) {
                return instance;
            }
        }
        throw new IllegalArgumentException(instance.getClass().getName() + " is not an instance of " + serviceClass);
    }

    private static Object upgradeInstanceIfNeeded(Class<?> serviceClass, ClassLoader loader, Object instance) {
        Service serviceAnnotation = serviceClass.getAnnotation(Service.class);
        if (serviceAnnotation != null && serviceAnnotation.upgradeMethod().length() > 0) {
            instance = Services.invokeStaticMethod(serviceClass, loader, serviceAnnotation.upgradeMethod(), instance);
        }
        return instance;
    }

    public static <T> List<Class<? extends T>> loadServiceClasses(Class<T> serviceClass, ClassLoader loader) {
        TreeMap<Integer, ArrayList<Class<T>>> ordered = new TreeMap<Integer, ArrayList<Class<T>>>();
        for (String className : Services.getServiceClassNames(serviceClass, loader)) {
            ArrayList<Class<T>> list;
            Class<T> clazz = Services.loadServiceClass(serviceClass, loader, className);
            if (clazz == null) continue;
            int order = 0;
            ServiceProvider providerAnnotation = clazz.getAnnotation(ServiceProvider.class);
            if (providerAnnotation != null) {
                order = providerAnnotation.order();
            }
            if ((list = (ArrayList<Class<T>>)ordered.get(order)) == null) {
                list = new ArrayList<Class<T>>();
                ordered.put(order, list);
            }
            list.add(clazz);
        }
        ArrayList<Class<T>> classes = new ArrayList<Class<T>>();
        for (List list : ordered.values()) {
            classes.addAll(list);
        }
        return classes;
    }

    private static List<String> getServiceClassNames(Class<?> serviceClass, ClassLoader loader) {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        for (URL url : Services.getServiceConfigURLs(serviceClass, loader)) {
            try {
                BufferedReader r = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));
                Throwable throwable = null;
                try {
                    String name;
                    while ((name = r.readLine()) != null) {
                        int ci = name.indexOf(35);
                        if (ci >= 0) {
                            name = name.substring(0, ci);
                        }
                        if ((name = name.trim()).isEmpty() || SystemProperties.getProperty(name + DISABLE_SUFFIX, null) != null) continue;
                        names.add(name);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (r == null) continue;
                    if (throwable != null) {
                        try {
                            r.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    r.close();
                }
            }
            catch (IOException e) {
                Services.log().error("Cannot read " + url, e);
            }
        }
        return new ArrayList<String>(names);
    }

    private static List<URL> getServiceConfigURLs(Class<?> serviceClass, ClassLoader loader) {
        SupersedesService supersedes;
        URL resource;
        String serviceConfig = META_INF_SERVICES + serviceClass.getName();
        List<Object> urls = new ArrayList<URL>();
        try {
            loader = Services.resolveLoader(loader, serviceClass);
            urls.addAll(Collections.list(loader.getResources(serviceConfig)));
        }
        catch (IOException e) {
            Services.log().error("Cannot read " + serviceConfig);
            urls = Collections.emptyList();
        }
        if (urls.isEmpty() && (resource = loader.getResource(serviceConfig)) != null) {
            urls.add(resource);
        }
        if ((supersedes = serviceClass.getAnnotation(SupersedesService.class)) != null && supersedes.value() != null) {
            urls.addAll(Services.getServiceConfigURLs(supersedes.value(), loader));
        }
        return urls;
    }
}

