/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.services;

import java.util.Enumeration;
import java.util.NoSuchElementException;

class SequenceEnumeration<T>
implements Enumeration<T> {
    private final Enumeration<T>[] seq;
    private int index;
    private boolean hasMore;
    private T next;

    SequenceEnumeration(Enumeration<T> ... seq) {
        this.seq = seq;
        this.initNext();
    }

    private void initNext() {
        while (this.index < this.seq.length && !this.seq[this.index].hasMoreElements()) {
            ++this.index;
        }
        boolean bl = this.hasMore = this.index < this.seq.length;
        if (this.hasMore) {
            this.next = this.seq[this.index].nextElement();
        }
    }

    @Override
    public boolean hasMoreElements() {
        return this.hasMore;
    }

    @Override
    public T nextElement() {
        if (!this.hasMore) {
            throw new NoSuchElementException();
        }
        T old = this.next;
        this.initNext();
        return old;
    }
}

