/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.services;

import com.devexperts.services.SequenceEnumeration;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.util.Enumeration;

public class OverrideURLClassLoader
extends URLClassLoader {
    public OverrideURLClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public OverrideURLClassLoader(URL[] urls) {
        super(urls);
    }

    public OverrideURLClassLoader(URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
        super(urls, parent, factory);
    }

    private boolean isServiceResource(String name) {
        return name.startsWith("META-INF/services/");
    }

    @Override
    public URL getResource(String name) {
        if (!this.isServiceResource(name)) {
            return super.getResource(name);
        }
        URL url = this.findResource(name);
        if (url == null) {
            ClassLoader parent = this.getParent();
            url = parent == null ? OverrideURLClassLoader.getSystemResource(name) : parent.getResource(name);
        }
        return url;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        ClassLoader parent;
        if (!this.isServiceResource(name)) {
            return super.getResources(name);
        }
        Enumeration[] tmp = new Enumeration[]{this.findResources(name), (parent = this.getParent()) == null ? OverrideURLClassLoader.getSystemResources(name) : parent.getResources(name)};
        return new SequenceEnumeration<URL>(tmp);
    }
}

