/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.management;

import com.devexperts.annotation.Description;
import com.devexperts.logging.Logging;
import com.devexperts.management.ManagementDescription;
import com.devexperts.management.ManagementParameterDescription;
import java.lang.annotation.Annotation;
import java.lang.management.ManagementFactory;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.StandardMBean;

public class Management {
    private static final Logging log = Logging.getLogging(Management.class);
    private static final String MXBEAN = "MXBean";
    private static final Map<String, Class<?>> PRIMITIVE_TYPES = new HashMap();

    private Management() {
    }

    public static String getMBeanNameForClass(Class<?> clazz) {
        String name = clazz.getName();
        int i = name.lastIndexOf(46);
        return (i >= 0 ? name.substring(0, i) : "default") + ":type=" + (i >= 0 ? name.substring(i + 1) : name);
    }

    public static Registration registerMBean(Object mbean, Class<?> mbeanInterface, String name) {
        try {
            mbean = Management.wrapMBean(mbean, mbeanInterface);
            return new Registration(false, false, ManagementFactory.getPlatformMBeanServer().registerMBean(mbean, new ObjectName(name)));
        }
        catch (InstanceAlreadyExistsException e) {
            return new Registration(false, true, null);
        }
        catch (Exception e) {
            log.error("Unexpected MBean registration exception for " + name, e);
            return new Registration(true, false, null);
        }
    }

    public static DynamicMBean wrapMBean(Object mbean, Class<?> mbeanInterface) {
        if (mbean instanceof DynamicMBean) {
            return (DynamicMBean)mbean;
        }
        if (mbeanInterface == null) {
            try {
                Class<?> candidate = Class.forName(mbean.getClass().getName() + MXBEAN);
                if (candidate.isInstance(mbean)) {
                    mbeanInterface = candidate;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return new MBean(new StandardMBean(mbean, mbeanInterface, mbeanInterface != null && mbeanInterface.getSimpleName().endsWith(MXBEAN)));
    }

    static String getDescription(String defaultDescription, AnnotatedElement element) {
        String description = null;
        Description descriptionAnnotation = element.getAnnotation(Description.class);
        if (descriptionAnnotation != null) {
            description = descriptionAnnotation.value();
        } else {
            ManagementDescription managementDescriptionAnnotation = element.getAnnotation(ManagementDescription.class);
            if (managementDescriptionAnnotation != null) {
                description = managementDescriptionAnnotation.value();
            }
        }
        return description != null ? description : defaultDescription;
    }

    static MBeanAttributeInfo[] getDescription(MBeanAttributeInfo[] attributes, StandardMBean delegate, Class<?> mbeanInterface) {
        ArrayList<MBeanAttributeInfo> result = new ArrayList<MBeanAttributeInfo>(attributes.length);
        for (int i = 0; i < attributes.length; ++i) {
            MBeanAttributeInfo attribute = attributes[i];
            if (attribute.isReadable()) {
                try {
                    delegate.getAttribute(attribute.getName());
                }
                catch (UnsupportedOperationException e) {
                    continue;
                }
                catch (MBeanException e) {
                    if (e.getTargetException() instanceof UnsupportedOperationException) {
                        continue;
                    }
                }
                catch (AttributeNotFoundException | ReflectionException e) {
                    // empty catch block
                }
                try {
                    Method method = mbeanInterface.getMethod((attribute.isIs() ? "is" : "get") + attribute.getName(), new Class[0]);
                    String description = Management.getDescription(null, method);
                    if (description != null) {
                        attribute = new MBeanAttributeInfo(attribute.getName(), attribute.getType(), description, attribute.isReadable(), attribute.isWritable(), attribute.isIs());
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            result.add(attribute);
        }
        return result.toArray(new MBeanAttributeInfo[result.size()]);
    }

    static MBeanOperationInfo[] getDescription(MBeanOperationInfo[] operations, Class<?> mbeanInterface) {
        MBeanOperationInfo[] result = new MBeanOperationInfo[operations.length];
        for (int i = 0; i < operations.length; ++i) {
            MBeanOperationInfo operation = operations[i];
            MBeanParameterInfo[] signature = operation.getSignature();
            try {
                Class[] params = new Class[signature.length];
                for (int j = 0; j < signature.length; ++j) {
                    MBeanParameterInfo param = signature[j];
                    params[j] = Management.getTypeClass(param.getType());
                }
                Method method = mbeanInterface.getMethod(operation.getName(), params);
                ManagementDescription a = method.getAnnotation(ManagementDescription.class);
                if (a != null) {
                    ManagementParameterDescription[] aps = a.parameters();
                    for (int j = 0; j < Math.min(signature.length, aps.length); ++j) {
                        MBeanParameterInfo param = signature[j];
                        ManagementParameterDescription ap = aps[j];
                        signature[j] = new MBeanParameterInfo(ap.name(), param.getType(), ap.value());
                    }
                    operation = new MBeanOperationInfo(operation.getName(), a.value(), signature, operation.getReturnType(), a.impact());
                } else {
                    Description methodDescription = method.getAnnotation(Description.class);
                    for (int paramI = 0; paramI < method.getParameterAnnotations().length; ++paramI) {
                        Description parameterDescription = null;
                        for (int j = 0; j < method.getParameterAnnotations()[paramI].length; ++j) {
                            Annotation annotation = method.getParameterAnnotations()[paramI][j];
                            if (!(annotation instanceof Description)) continue;
                            parameterDescription = (Description)annotation;
                        }
                        MBeanParameterInfo param = signature[paramI];
                        signature[paramI] = new MBeanParameterInfo(parameterDescription != null ? parameterDescription.name() : signature[paramI].getName(), param.getType(), parameterDescription != null ? parameterDescription.value() : signature[paramI].getDescription());
                    }
                    operation = new MBeanOperationInfo(operation.getName(), methodDescription != null ? methodDescription.value() : operation.getDescription(), signature, operation.getReturnType(), 3);
                }
            }
            catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
                // empty catch block
            }
            result[i] = operation;
        }
        return result;
    }

    private static void putPrimitive(Class<?> c) {
        PRIMITIVE_TYPES.put(c.getName(), c);
    }

    private static Class<?> getTypeClass(String type) throws ClassNotFoundException {
        Class<?> c = PRIMITIVE_TYPES.get(type);
        if (c != null) {
            return c;
        }
        return Class.forName(type);
    }

    static {
        Management.putPrimitive(Boolean.TYPE);
        Management.putPrimitive(Byte.TYPE);
        Management.putPrimitive(Short.TYPE);
        Management.putPrimitive(Character.TYPE);
        Management.putPrimitive(Integer.TYPE);
        Management.putPrimitive(Long.TYPE);
        Management.putPrimitive(Float.TYPE);
        Management.putPrimitive(Double.TYPE);
    }

    public static class Registration {
        private final boolean failed;
        private final boolean existed;
        private ObjectInstance instance;

        Registration(boolean failed, boolean existed, ObjectInstance instance) {
            this.failed = failed;
            this.existed = existed;
            this.instance = instance;
        }

        public ObjectInstance getInstance() {
            return this.instance;
        }

        public boolean hasFailed() {
            return this.failed;
        }

        public boolean hasExisted() {
            return this.existed;
        }

        public synchronized void unregister() {
            if (this.instance != null) {
                try {
                    ManagementFactory.getPlatformMBeanServer().unregisterMBean(this.instance.getObjectName());
                }
                catch (Exception e) {
                    log.error("Unexpected MBean unregistration exception for " + this.instance.getObjectName(), e);
                }
                this.instance = null;
            }
        }
    }

    private static class MBean
    implements DynamicMBean {
        private final DynamicMBean delegate;
        private final MBeanInfo info;

        MBean(StandardMBean delegate) {
            this.delegate = delegate;
            Class<?> mbeanInterface = delegate.getMBeanInterface();
            MBeanInfo bi = delegate.getMBeanInfo();
            this.info = new MBeanInfo(bi.getClassName(), Management.getDescription(bi.getDescription(), mbeanInterface), Management.getDescription(bi.getAttributes(), delegate, mbeanInterface), bi.getConstructors(), Management.getDescription(bi.getOperations(), mbeanInterface), bi.getNotifications());
        }

        @Override
        public MBeanInfo getMBeanInfo() {
            return this.info;
        }

        @Override
        public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
            return this.delegate.getAttribute(attribute);
        }

        @Override
        public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
            this.delegate.setAttribute(attribute);
        }

        @Override
        public AttributeList getAttributes(String[] attributes) {
            return this.delegate.getAttributes(attributes);
        }

        @Override
        public AttributeList setAttributes(AttributeList attributes) {
            return this.delegate.setAttributes(attributes);
        }

        @Override
        public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
            return this.delegate.invoke(actionName, params, signature);
        }
    }
}

