/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.logging;

import com.devexperts.logging.LogFormatter;
import com.devexperts.util.SystemProperties;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

public class TraceLogging {
    private static final int STOPPED_INDEX = -1;
    private static final int SIZE = SystemProperties.getIntProperty(TraceLogging.class, "size", 4096);
    private static final int MASK = SIZE - 1;
    private static final int THREAD_OFS = 0;
    private static final int NAME_OFS = 1;
    private static final int LEVEL_OFS = 2;
    private static final int MSG_OFS = 3;
    private static final int THROWABLE_OFS = 4;
    private static final int DATA_CNT = 5;
    private static final long[] timeQueue = new long[SIZE];
    private static final Object[] dataQueue = new Object[SIZE * 5];
    private static final AtomicInteger index = new AtomicInteger(-1);
    private static int lastIndex = -1;

    public static synchronized void restart() {
        Arrays.fill(dataQueue, null);
        lastIndex = -1;
        index.compareAndSet(-1, 0);
    }

    public static void stop() {
        TraceLogging.stopIndex(-1);
    }

    public static void log(String loggerName, Level level, String msg, Throwable t) {
        TraceLogging.append(TraceLogging.nextIndex(), loggerName, level, msg, t);
    }

    public static void logAndStop(Class<?> where, String msg) {
        TraceLogging.logAndStop(where, msg, null);
    }

    public static void logAndStop(Class<?> where, String msg, Throwable t) {
        TraceLogging.append(TraceLogging.stopIndex(0), where.getName(), Level.INFO, msg, t);
    }

    private static void append(int i, String loggerName, Level level, String msg, Throwable t) {
        if (i < 0) {
            return;
        }
        TraceLogging.timeQueue[i] = System.currentTimeMillis();
        TraceLogging.dataQueue[i * 5 + 0] = Thread.currentThread();
        TraceLogging.dataQueue[i * 5 + 1] = loggerName;
        TraceLogging.dataQueue[i * 5 + 2] = level;
        TraceLogging.dataQueue[i * 5 + 3] = msg;
        TraceLogging.dataQueue[i * 5 + 4] = t;
    }

    public static synchronized void dump(PrintStream out, String title) {
        int stop = lastIndex;
        if (stop < 0) {
            return;
        }
        lastIndex = -1;
        LogFormatter formatter = new LogFormatter();
        out.println("********************** Dump trace log for " + title);
        int i = stop;
        do {
            Thread thread;
            if ((thread = (Thread)dataQueue[(i = i + 1 & MASK) * 5 + 0]) == null) continue;
            String loggerName = (String)dataQueue[i * 5 + 1];
            Level level = (Level)dataQueue[i * 5 + 2];
            String msg = (String)dataQueue[i * 5 + 3];
            Throwable t = (Throwable)dataQueue[i * 5 + 4];
            long time = timeQueue[i];
            out.print("* ");
            out.print(formatter.format(LogFormatter.getLevelChar(level), time, thread.getName(), loggerName, msg));
            if (t == null) continue;
            t.printStackTrace(out);
        } while (i != stop);
        out.println("********************** Done trace log for " + title);
    }

    private static int nextIndex() {
        int result;
        while ((result = index.get()) >= 0 && !index.compareAndSet(result, result + 1 & MASK)) {
        }
        return result;
    }

    private static synchronized int stopIndex(int lastOffset) {
        int result;
        while ((result = index.get()) >= 0 && !index.compareAndSet(result, -1)) {
        }
        if (result >= 0) {
            lastIndex = result + lastOffset & MASK;
        }
        return result;
    }

    static {
        if ((SIZE & MASK) != 0) {
            throw new RuntimeException("Size must be a power of two");
        }
    }
}

