/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.logging;

import com.devexperts.io.URLInputStream;
import com.devexperts.logging.DefaultLogging;
import com.devexperts.logging.LogFormatter;
import com.devexperts.util.IndexedSet;
import com.devexperts.util.QuickSort;
import com.devexperts.util.SynchronizedIndexedSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

class ThreadNameFormatter
implements Comparable<ThreadNameFormatter> {
    private static final Map<Pattern, String> PATTERNS = new LinkedHashMap<Pattern, String>();
    private static final int MAX_NAME_CONVERSIONS_CACHE_SIZE = 1000;
    private static final IndexedSet<String, ThreadNameFormatter> NAME_CONVERSIONS = SynchronizedIndexedSet.create(ThreadNameFormatter::getThreadName);
    final String thread_name;
    final String replacement_name;
    long last_time;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadPatterns() {
        InputStream config_input_stream = null;
        try {
            String line;
            String config_path = DefaultLogging.getProperty("logformatter.properties", null);
            if (config_path != null) {
                try {
                    config_input_stream = new URLInputStream(config_path);
                }
                catch (IOException e) {
                    System.err.println("Cannot find log formatter configuration file: '" + config_path + "'");
                    System.err.println("No thread name conversion will be performed.");
                    try {
                        if (config_input_stream != null) {
                            config_input_stream.close();
                        }
                    }
                    catch (IOException e2) {
                        System.err.println("Cannot close log formatter configuration file");
                        e2.printStackTrace(System.err);
                    }
                    return;
                }
            }
            config_input_stream = LogFormatter.class.getResourceAsStream("/META-INF/logformatter.properties");
            if (config_input_stream == null) {
                return;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(config_input_stream, Charset.forName("ISO-8859-1")));
            Pattern config_line_pattern = Pattern.compile("((?:[^=]|(?:\\\\=))*[^\\\\=])=(.*)");
            Pattern whitespace_line_pattern = Pattern.compile("\\s*");
            Pattern comment_line_pattern = Pattern.compile("#.*|!.*");
            HashSet<String> patterns_set = new HashSet<String>();
            while ((line = reader.readLine()) != null) {
                Matcher config_line_matcher = config_line_pattern.matcher(line);
                if (whitespace_line_pattern.matcher(line).matches() || comment_line_pattern.matcher(line).matches()) continue;
                if (!config_line_matcher.matches()) {
                    System.err.println("The following line cannot be parsed in log formatter configuration file: '" + line + "'");
                    continue;
                }
                String config_pattern = config_line_matcher.group(1);
                String config_replacement = config_line_matcher.group(2);
                if (!patterns_set.add(config_pattern)) {
                    System.err.println("Duplicate pattern found in log formatter configuration file: '" + config_pattern + "'");
                    continue;
                }
                try {
                    PATTERNS.put(Pattern.compile(config_pattern), config_replacement);
                }
                catch (PatternSyntaxException e) {
                    System.err.println("Cannot parse config pattern in log formatter configuration file: '" + config_pattern + "'");
                }
            }
        }
        catch (IOException e) {
            System.err.println("Cannot read log formatter configuration file");
            e.printStackTrace(System.err);
        }
        finally {
            try {
                if (config_input_stream != null) {
                    config_input_stream.close();
                }
            }
            catch (IOException e) {
                System.err.println("Cannot close log formatter configuration file");
                e.printStackTrace(System.err);
            }
        }
    }

    static String formatThreadName(long time, String thread_name) {
        ThreadNameFormatter entry = NAME_CONVERSIONS.getByKey(thread_name);
        if (entry == null) {
            ThreadNameFormatter.cleanupNameConversionsIfNeeded();
            entry = new ThreadNameFormatter(thread_name, ThreadNameFormatter.calculateThreadNameReplacement(thread_name));
            NAME_CONVERSIONS.put(entry);
        }
        entry.last_time = time;
        return entry.replacement_name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanupNameConversionsIfNeeded() {
        if (NAME_CONVERSIONS.size() <= 1000) {
            return;
        }
        IndexedSet<String, ThreadNameFormatter> indexedSet = NAME_CONVERSIONS;
        synchronized (indexedSet) {
            if (NAME_CONVERSIONS.size() <= 1000) {
                return;
            }
            Object[] entries = NAME_CONVERSIONS.toArray(new ThreadNameFormatter[NAME_CONVERSIONS.size()]);
            QuickSort.sort(entries);
            for (int i = 0; i < entries.length - 500; ++i) {
                NAME_CONVERSIONS.removeKey(((ThreadNameFormatter)entries[i]).thread_name);
            }
        }
    }

    private static String calculateThreadNameReplacement(String thread_name) {
        for (Map.Entry<Pattern, String> entry : PATTERNS.entrySet()) {
            Matcher matcher = entry.getKey().matcher(thread_name);
            if (!matcher.matches()) continue;
            String config_replacement = entry.getValue();
            try {
                return matcher.replaceAll(config_replacement);
            }
            catch (IndexOutOfBoundsException e) {
                System.err.println("Cannot parse replacement string in log formatter configuration file: '" + config_replacement + "'");
            }
        }
        return thread_name;
    }

    ThreadNameFormatter(String thread_name, String replacement_name) {
        this.thread_name = thread_name;
        this.replacement_name = replacement_name;
    }

    private String getThreadName() {
        return this.thread_name;
    }

    @Override
    public int compareTo(ThreadNameFormatter o) {
        return this.last_time < o.last_time ? -1 : (this.last_time > o.last_time ? 1 : 0);
    }

    static {
        ThreadNameFormatter.loadPatterns();
    }
}

