/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.logging;

import com.devexperts.logging.DefaultLogging;
import com.devexperts.logging.DetailedLogLayout;
import com.devexperts.logging.LogFormatter;
import com.devexperts.logging.Logging;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import org.apache.log4j.Appender;
import org.apache.log4j.Category;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Priority;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.spi.LoggingEvent;

class Log4jLogging
extends DefaultLogging {
    private static final String FQCN = Logging.class.getName() + ".";

    Log4jLogging() {
    }

    @Override
    Map<String, Exception> configure() {
        if (Category.getCurrentCategories().hasMoreElements() || Category.getRoot().getAllAppenders().hasMoreElements()) {
            return Log4jLogging.defaultErrors();
        }
        return Log4jLogging.reconfigure(Log4jLogging.getProperty("log.file", null));
    }

    @Override
    Map<String, Exception> configureLogFile(String logFile) {
        Category.getRoot().removeAllAppenders();
        return Log4jLogging.reconfigure(logFile);
    }

    private static Map<String, Exception> defaultErrors() {
        LinkedHashMap<String, Exception> errors = new LinkedHashMap<String, Exception>();
        errors.put("WARNING: DEPRECATED use of log4j 1.x logging. Migrate to log4j2 or use its bridge to log4j 1.x", null);
        return errors;
    }

    private static Map<String, Exception> reconfigure(String logFile) {
        Map<String, Exception> errors = Log4jLogging.defaultErrors();
        RollingFileAppender appender = null;
        if (logFile != null) {
            try {
                appender = Log4jLogging.createFileAppender(logFile, "log.maxFileSize", errors);
            }
            catch (Exception e) {
                errors.put(logFile, e);
            }
        }
        if (appender == null) {
            appender = new ConsoleAppender((Layout)new DetailedLogLayout());
        }
        Category.getRoot().addAppender(appender);
        String errFile = Log4jLogging.getProperty("err.file", null);
        if (errFile != null) {
            try {
                RollingFileAppender errAppender = Log4jLogging.createFileAppender(errFile, "err.maxFileSize", errors);
                errAppender.setThreshold(Priority.WARN);
                Category.getRoot().addAppender((Appender)errAppender);
            }
            catch (Exception e) {
                errors.put(errFile, e);
            }
        }
        return errors;
    }

    private static RollingFileAppender createFileAppender(String logFile, String maxSizeKey, Map<String, Exception> errors) throws IOException {
        RollingFileAppender appender = new RollingFileAppender((Layout)new DetailedLogLayout(), logFile, true);
        int limit = Log4jLogging.getLimit(maxSizeKey, errors);
        if (limit != 0) {
            appender.setMaxFileSize(Integer.toString(limit));
        }
        return appender;
    }

    @Override
    Object getPeer(String name) {
        return Category.getInstance((String)name);
    }

    @Override
    String getName(Object peer) {
        return ((Category)peer).getName();
    }

    @Override
    boolean debugEnabled(Object peer) {
        return ((Category)peer).isEnabledFor(Priority.DEBUG);
    }

    @Override
    void setDebugEnabled(Object peer, boolean debugEnabled) {
        Category category = (Category)peer;
        Priority priority = category.getPriority();
        if (debugEnabled) {
            if (priority == null || priority.isGreaterOrEqual(Priority.DEBUG)) {
                category.setPriority(Priority.DEBUG);
            }
        } else if (priority == null || Priority.INFO.isGreaterOrEqual(priority)) {
            category.setPriority(Priority.INFO);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void log(Object peer, Level level, String msg, Throwable t) {
        Priority priority = level.intValue() <= Level.FINE.intValue() ? Priority.DEBUG : (level.intValue() <= Level.INFO.intValue() ? Priority.INFO : (level.intValue() <= Level.WARNING.intValue() ? Priority.WARN : Priority.ERROR));
        if (!((Category)peer).isEnabledFor(priority)) {
            return;
        }
        boolean interrupted = Thread.interrupted();
        try {
            ((Category)peer).callAppenders(new LoggingEvent(FQCN, (Category)peer, priority, (Object)(msg == null ? "" : msg), t));
        }
        catch (Exception e) {
            System.err.println(new LogFormatter().format('E', System.currentTimeMillis(), Thread.currentThread().getName(), "Log4j", e + " during logging of " + msg));
            if (!(e instanceof IllegalStateException) || e.getMessage() == null || !e.getMessage().equals("Current state = FLUSHED, new state = CODING")) {
                e.printStackTrace(System.err);
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

