/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.logging;

import com.devexperts.logging.DefaultLogging;
import com.devexperts.logging.DxFeedPatternLayout;
import com.devexperts.logging.LogFormatter;
import com.devexperts.logging.Logging;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.SizeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.NullConfiguration;
import org.apache.logging.log4j.core.filter.ThresholdFilter;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.status.StatusLogger;

class Log4j2Logging
extends DefaultLogging {
    private static final String FQCN = Logging.class.getName() + ".";

    Log4j2Logging() {
    }

    @Override
    Map<String, Exception> configure() {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        if (ctx.getConfiguration().getConfigurationSource() != ConfigurationSource.NULL_SOURCE) {
            return Collections.emptyMap();
        }
        return this.configureLogFile(Log4j2Logging.getProperty("log.file", null));
    }

    private static Map<String, Exception> reconfigure(String logFile) {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        LinkedHashMap<String, Exception> errors = new LinkedHashMap<String, Exception>();
        config.getRootLogger().setLevel(Level.DEBUG);
        String errFile = Log4j2Logging.getProperty("err.file", null);
        for (Map.Entry entry : config.getRootLogger().getAppenders().entrySet()) {
            ((Appender)entry.getValue()).stop();
            config.getRootLogger().removeAppender((String)entry.getKey());
        }
        RollingFileAppender appender = null;
        if (logFile != null) {
            try {
                appender = Log4j2Logging.createFileAppender("common", logFile, "log.maxFileSize", errors);
            }
            catch (Exception e) {
                errors.put(logFile, e);
            }
        }
        if (appender == null) {
            appender = ((ConsoleAppender.Builder)((ConsoleAppender.Builder)ConsoleAppender.newBuilder().withName("common")).withLayout((Layout)Log4j2Logging.getDetailedLayout())).setTarget(ConsoleAppender.Target.SYSTEM_OUT).build();
        }
        config.getRootLogger().addAppender((Appender)appender, Level.DEBUG, errFile == null ? null : ThresholdFilter.createFilter((Level)Level.WARN, (Filter.Result)Filter.Result.DENY, (Filter.Result)Filter.Result.ACCEPT));
        if (errFile != null) {
            try {
                RollingFileAppender errAppender = Log4j2Logging.createFileAppender("error", errFile, "err.maxFileSize", errors);
                config.getRootLogger().addAppender((Appender)errAppender, Level.WARN, (Filter)ThresholdFilter.createFilter((Level)Level.WARN, (Filter.Result)Filter.Result.ACCEPT, (Filter.Result)Filter.Result.DENY));
            }
            catch (Exception e) {
                errors.put(errFile, e);
            }
        }
        ctx.updateLoggers();
        return errors;
    }

    private static AbstractStringLayout getDetailedLayout() {
        return DxFeedPatternLayout.createDefaultLayout(null);
    }

    private static RollingFileAppender createFileAppender(String name, String logFile, String maxSizeKey, Map<String, Exception> errors) {
        RollingFileAppender.Builder builder = RollingFileAppender.newBuilder();
        builder.setConfiguration((Configuration)new NullConfiguration());
        builder.withName(name);
        builder.withLayout((Layout)Log4j2Logging.getDetailedLayout());
        builder.withFileName(logFile);
        builder.withFilePattern(logFile);
        builder.withAppend(true);
        builder.withImmediateFlush(true);
        int limit = Log4j2Logging.getLimit(maxSizeKey, errors);
        if (limit == 0) {
            limit = 943718400;
        }
        builder.withPolicy((TriggeringPolicy)SizeBasedTriggeringPolicy.createPolicy((String)Integer.toString(limit)));
        return builder.build();
    }

    @Override
    Map<String, Exception> configureLogFile(String logFile) {
        return Log4j2Logging.reconfigure(logFile);
    }

    @Override
    Object getPeer(String name) {
        return LogManager.getLogger((String)name);
    }

    @Override
    String getName(Object peer) {
        return ((Logger)peer).getName();
    }

    @Override
    boolean debugEnabled(Object peer) {
        return ((Logger)peer).isDebugEnabled();
    }

    @Override
    void setDebugEnabled(Object peer, boolean debugEnabled) {
        Logger logger = (Logger)peer;
        if (debugEnabled) {
            if (logger.getLevel().isMoreSpecificThan(Level.DEBUG)) {
                logger.setLevel(Level.DEBUG);
            }
        } else if (logger.getLevel().isLessSpecificThan(Level.INFO)) {
            logger.setLevel(Level.INFO);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void log(Object peer, java.util.logging.Level level, String msg, Throwable t) {
        Level priority = level.intValue() <= java.util.logging.Level.FINE.intValue() ? Level.DEBUG : (level.intValue() <= java.util.logging.Level.INFO.intValue() ? Level.INFO : (level.intValue() <= java.util.logging.Level.WARNING.intValue() ? Level.WARN : Level.ERROR));
        if (!((Logger)peer).isEnabled(priority)) {
            return;
        }
        boolean interrupted = Thread.interrupted();
        try {
            ((Logger)peer).logMessage(FQCN, priority, null, (Message)new SimpleMessage(msg == null ? "" : msg), t);
        }
        catch (Exception e) {
            System.err.println(new LogFormatter().format('E', System.currentTimeMillis(), Thread.currentThread().getName(), "Log4j", e + " during logging of " + msg));
            if (!(e instanceof IllegalStateException) || e.getMessage() == null || !e.getMessage().equals("Current state = FLUSHED, new state = CODING")) {
                e.printStackTrace(System.err);
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    static {
        StatusLogger.getLogger().setLevel(Level.OFF);
    }
}

