/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.logging;

import com.devexperts.logging.DefaultLogging;
import com.devexperts.logging.LogFormatter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.core.layout.ByteBufferDestination;
import org.apache.logging.log4j.core.layout.Encoder;
import org.apache.logging.log4j.core.pattern.MessagePatternConverter;

@Plugin(name="dxFeedPatternLayout", category="Core", elementType="layout", printObject=true)
public class DxFeedPatternLayout
extends AbstractStringLayout {
    private static final String LINE_SEP = DefaultLogging.getProperty("line.separator", "\n");
    private final BiConsumer<Object, StringBuilder> msgConsumer;
    private final LogFormatter logFormatter;

    private DxFeedPatternLayout(Configuration configuration) {
        super(configuration, Charset.defaultCharset(), null, null);
        MessagePatternConverter messagePatternConverter = MessagePatternConverter.newInstance((Configuration)configuration, null);
        this.msgConsumer = (o, sb) -> {
            Throwable throwable;
            messagePatternConverter.format(o, sb);
            if (o instanceof LogEvent && (throwable = ((LogEvent)o).getThrown()) != null) {
                sb.append(LINE_SEP);
                StringWriter w = new StringWriter();
                throwable.printStackTrace(new PrintWriter(w));
                sb.append(w.getBuffer());
                sb.setLength(sb.length() - LINE_SEP.length());
            }
        };
        this.logFormatter = new LogFormatter();
    }

    public String toSerializable(LogEvent event) {
        StringBuilder text = DxFeedPatternLayout.getStringBuilder();
        String s = this.format(event, text).toString();
        DxFeedPatternLayout.trimToMaxSize((StringBuilder)text);
        return s;
    }

    public void encode(LogEvent event, ByteBufferDestination destination) {
        StringBuilder text = DxFeedPatternLayout.getStringBuilder();
        this.format(event, text);
        Encoder encoder = this.getStringBuilderEncoder();
        encoder.encode((Object)text, destination);
        DxFeedPatternLayout.trimToMaxSize((StringBuilder)text);
    }

    private StringBuilder format(LogEvent event, StringBuilder text) {
        char level = event.getLevel().name().charAt(0);
        this.logFormatter.format(level, event.getTimeMillis(), event.getThreadName(), event.getLoggerName(), this.msgConsumer, event, text);
        return text;
    }

    public Map<String, String> getContentFormat() {
        return Collections.emptyMap();
    }

    public String toString() {
        return this.getContentFormat().toString();
    }

    public static DxFeedPatternLayout createDefaultLayout() {
        return DxFeedPatternLayout.createDefaultLayout(null);
    }

    @PluginFactory
    public static DxFeedPatternLayout createDefaultLayout(@PluginConfiguration Configuration configuration) {
        if (configuration == null) {
            configuration = new DefaultConfiguration();
        }
        return new DxFeedPatternLayout(configuration);
    }
}

