/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.logging;

import com.devexperts.logging.LogFormatter;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;

class DefaultLogging {
    DefaultLogging() {
    }

    Map<String, Exception> configure() {
        if (DefaultLogging.getProperty("java.util.logging.config.class", null) != null || DefaultLogging.getProperty("java.util.logging.config.file", null) != null || !this.hasDefaultHandlers(Logger.getLogger(""))) {
            return Collections.emptyMap();
        }
        return this.configureLogFile(DefaultLogging.getProperty("log.file", null));
    }

    private boolean hasDefaultHandlers(Logger root) {
        Handler[] handlers = root.getHandlers();
        if (handlers.length != 1) {
            return false;
        }
        Handler handler = handlers[0];
        return handler.getClass() == ConsoleHandler.class && handler.getFormatter().getClass() == SimpleFormatter.class && handler.getLevel() == Level.INFO;
    }

    Map<String, Exception> configureLogFile(String log_file) {
        Logger root = Logger.getLogger("");
        LinkedHashMap<String, Exception> errors = new LinkedHashMap<String, Exception>();
        try {
            for (Handler handler : root.getHandlers()) {
                root.removeHandler(handler);
            }
            StreamHandler handler = null;
            if (log_file != null) {
                try {
                    handler = new FileHandler(log_file, DefaultLogging.getLimit("log.maxFileSize", errors), 2, true);
                }
                catch (IOException e) {
                    errors.put(log_file, e);
                }
            }
            if (handler == null) {
                handler = new ConsoleHandler();
            }
            handler.setFormatter(new LogFormatter());
            handler.setLevel(Level.ALL);
            root.addHandler(handler);
            String err_file = DefaultLogging.getProperty("err.file", null);
            if (err_file != null) {
                try {
                    handler = new FileHandler(err_file, DefaultLogging.getLimit("err.maxFileSize", errors), 2, true);
                    handler.setFormatter(new LogFormatter());
                    handler.setLevel(Level.WARNING);
                    root.addHandler(handler);
                }
                catch (IOException e) {
                    errors.put(err_file, e);
                }
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return errors;
    }

    Object getPeer(String name) {
        return Logger.getLogger(name);
    }

    String getName(Object peer) {
        return ((Logger)peer).getName();
    }

    boolean debugEnabled(Object peer) {
        return ((Logger)peer).isLoggable(Level.FINE);
    }

    void setDebugEnabled(Object peer, boolean debugEnabled) {
        Logger category = (Logger)peer;
        Level priority = category.getLevel();
        if (debugEnabled) {
            if (priority == null || priority.intValue() > Level.FINE.intValue()) {
                category.setLevel(Level.FINE);
            }
        } else if (priority == null || priority.intValue() < Level.INFO.intValue()) {
            category.setLevel(Level.INFO);
        }
    }

    void log(Object peer, Level level, String msg, Throwable t) {
        ((Logger)peer).log(level, msg, t);
    }

    static String getProperty(String key, String def) {
        try {
            return System.getProperty(key, def);
        }
        catch (SecurityException e) {
            return def;
        }
    }

    static int getLimit(String key, Map<String, Exception> errors) {
        String value = DefaultLogging.getProperty(key, "900M").trim();
        int multiplier = 1;
        if (value.endsWith("K") || value.endsWith("k")) {
            multiplier = 1024;
            value = value.substring(0, value.length() - 1);
        } else if (value.endsWith("M") || value.endsWith("m")) {
            multiplier = 0x100000;
            value = value.substring(0, value.length() - 1);
        } else if (value.endsWith("G") || value.endsWith("g")) {
            multiplier = 0x40000000;
            value = value.substring(0, value.length() - 1);
        }
        try {
            return Integer.parseInt(value) * multiplier;
        }
        catch (NumberFormatException e) {
            errors.put(key, e);
            return 0;
        }
    }
}

