/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.io;

import com.devexperts.io.ByteArrayOutput;
import com.devexperts.util.Base64;
import com.devexperts.util.SystemProperties;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;

public class URLInputStream
extends FilterInputStream {
    private static final int CONNECT_TIMEOUT = SystemProperties.getIntProperty(URLInputStream.class, "connectTimeout", 30000);
    private static final int READ_TIMEOUT = SystemProperties.getIntProperty(URLInputStream.class, "readTimeout", 60000);
    protected final URLConnection connection;

    public static URL resolveURL(String url) throws MalformedURLException {
        if (url.length() > 2 && url.charAt(1) == ':' && File.separatorChar == '\\') {
            url = "/" + url;
        }
        return new URL(new File(".").toURL(), url);
    }

    public static URLConnection openConnection(String url) throws IOException {
        return URLInputStream.openConnection(URLInputStream.resolveURL(url), null, null);
    }

    public static URLConnection openConnection(URL url, String user, String password) throws IOException {
        URLConnection connection = url.openConnection();
        connection.setAllowUserInteraction(false);
        connection.setConnectTimeout(CONNECT_TIMEOUT);
        connection.setReadTimeout(READ_TIMEOUT);
        String auth = user != null && !user.isEmpty() && password != null && !password.isEmpty() ? user + ":" + password : url.getUserInfo();
        if (auth != null && !auth.isEmpty()) {
            connection.setRequestProperty("Authorization", "Basic " + Base64.DEFAULT.encode(auth.getBytes(StandardCharsets.UTF_8)));
        }
        return connection;
    }

    public static void checkConnectionResponseCode(URLConnection connection) throws IOException {
        if (connection instanceof HttpURLConnection && ((HttpURLConnection)connection).getResponseCode() != 200) {
            throw new IOException("Unexpected response: " + connection.getHeaderField(0));
        }
    }

    @Deprecated
    public static byte[] readURL(String url) throws IOException {
        return URLInputStream.readBytes(URLInputStream.resolveURL(url), null, null);
    }

    public static byte[] readBytes(String url) throws IOException {
        return URLInputStream.readBytes(URLInputStream.resolveURL(url), null, null);
    }

    public static byte[] readBytes(URL url, String user, String password) throws IOException {
        try (URLInputStream in = new URLInputStream(url, user, password);){
            byte[] byArray = in.readAllBytes();
            return byArray;
        }
    }

    public static long getLastModified(String url) throws IOException {
        return URLInputStream.getLastModified(URLInputStream.resolveURL(url), null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getLastModified(URL url, String user, String password) throws IOException {
        URLConnection connection = URLInputStream.openConnection(url, user, password);
        try {
            if (connection instanceof HttpURLConnection) {
                ((HttpURLConnection)connection).setRequestMethod("HEAD");
            }
            long lastModified = connection.getLastModified();
            URLInputStream.checkConnectionResponseCode(connection);
            if (lastModified == 0L) {
                throw new IOException("Last modified time is not known");
            }
            long l = lastModified;
            return l;
        }
        finally {
            connection.getInputStream().close();
        }
    }

    public URLInputStream(String url) throws IOException {
        this(URLInputStream.resolveURL(url), null, null, 0L);
    }

    public URLInputStream(URL url, String user, String password) throws IOException {
        this(url, user, password, 0L);
    }

    public URLInputStream(URL url, String user, String password, long ifModifiedSince) throws IOException {
        super(null);
        this.connection = URLInputStream.openConnection(url, user, password);
        this.connection.setIfModifiedSince(ifModifiedSince);
        this.in = this.connection.getInputStream();
        if (this.connection instanceof HttpURLConnection) {
            boolean skipped;
            int response = ((HttpURLConnection)this.connection).getResponseCode();
            boolean bl = skipped = ifModifiedSince != 0L && response == 304;
            if (response != 200 && !skipped) {
                this.close();
                throw new IOException("Unexpected response: " + this.connection.getHeaderField(0));
            }
        }
    }

    public URLConnection getConnection() {
        return this.connection;
    }

    public long getLastModified() {
        return this.connection.getLastModified();
    }

    public boolean isModifiedSince() throws IOException {
        if (this.connection instanceof HttpURLConnection && ((HttpURLConnection)this.connection).getResponseCode() == 304) {
            return false;
        }
        return this.connection.getIfModifiedSince() == 0L || this.connection.getLastModified() != this.connection.getIfModifiedSince();
    }

    @Override
    public byte[] readAllBytes() throws IOException {
        int n;
        ByteArrayOutput out = new ByteArrayOutput(this.connection.getContentLength() + 1000);
        while ((n = this.in.read(out.getBuffer(), out.getPosition(), out.getLimit() - out.getPosition())) >= 0) {
            out.setPosition(out.getPosition() + n);
            out.ensureCapacity(out.getPosition() + 1000);
        }
        return out.toByteArray();
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }
}

