/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.io;

import com.devexperts.io.BufferedInput;
import com.devexperts.io.BufferedOutput;
import com.devexperts.io.ClassUtil;
import com.devexperts.io.Marshaller;
import com.devexperts.io.ObjectDeserializer;
import com.devexperts.io.ObjectSerializer;
import com.devexperts.io.SerialClassContext;
import java.io.IOException;
import java.io.InvalidClassException;
import java.util.ArrayList;

final class TypedMarshallerImpl<T>
extends Marshaller.Typed<T> {
    private final boolean single;
    private final String types;
    private volatile Class<?>[] classes;

    TypedMarshallerImpl(boolean single, Class<?> ... classes) {
        if (classes == null) {
            throw new NullPointerException();
        }
        if (single && classes.length != 1) {
            throw new IllegalArgumentException();
        }
        this.single = single;
        StringBuilder sb = new StringBuilder();
        for (Class<?> clazz : classes) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(clazz.getName());
        }
        this.types = sb.toString();
        this.classes = classes;
    }

    TypedMarshallerImpl(boolean single, String types) {
        if (types == null) {
            throw new NullPointerException();
        }
        this.single = single;
        this.types = types;
    }

    @Override
    public String getTypes() {
        return this.types;
    }

    @Override
    public Class<?>[] getClasses(ClassLoader cl) throws InvalidClassException {
        Class<?>[] classes = this.classes;
        if (classes != null) {
            return classes;
        }
        return this.getClassesWithExplicitLoaderSync(cl);
    }

    @Override
    public boolean supportsNullObject() {
        return this.single;
    }

    @Override
    public boolean representsNullObjectAsNullBytes() {
        return false;
    }

    private synchronized Class<?>[] getClassesWithExplicitLoaderSync(ClassLoader cl) throws InvalidClassException {
        int i;
        Class<?>[] classes = this.classes;
        if (classes != null) {
            return classes;
        }
        ArrayList<String> typeList = new ArrayList<String>();
        if (!this.types.isEmpty()) {
            int j;
            i = 0;
            while ((j = this.types.indexOf(44, i)) != -1) {
                typeList.add(this.types.substring(i, j));
                i = j + 1;
            }
            typeList.add(this.types.substring(i));
        }
        if (this.single && typeList.size() != 1) {
            throw new IllegalArgumentException("Must have a single type name, but found '" + this.types + "'");
        }
        classes = new Class[typeList.size()];
        cl = ClassUtil.resolveContextClassLoader(cl);
        for (i = 0; i < classes.length; ++i) {
            try {
                classes[i] = ClassUtil.getTypeClass((String)typeList.get(i), cl);
                continue;
            }
            catch (ClassNotFoundException e) {
                throw new InvalidClassException("Class not found: " + e.getMessage());
            }
        }
        this.classes = classes;
        return classes;
    }

    private Class<?>[] getClassesWithImplicitLoader(Object[] objects) throws InvalidClassException {
        Class<?>[] classes = this.classes;
        if (classes != null) {
            return classes;
        }
        return this.getClassesWithImplicitLoaderSync(objects);
    }

    private synchronized Class<?>[] getClassesWithImplicitLoaderSync(Object[] objects) throws InvalidClassException {
        Class<?>[] classes = this.classes;
        if (classes != null) {
            return classes;
        }
        ClassLoader cl = null;
        for (Object object : objects) {
            if (object != null && (cl = object.getClass().getClassLoader()) != null) break;
        }
        return this.getClassesWithExplicitLoaderSync(cl);
    }

    @Override
    public void writeObjectTo(BufferedOutput out, T object) throws IOException {
        Object[] objectArray;
        if (this.single) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = object;
        } else {
            objectArray = (Object[])object;
        }
        Object[] objects = objectArray;
        ObjectSerializer.writeBodiesWithTypes(out, this.getClassesWithImplicitLoader(objects), objects);
    }

    @Override
    public T readObjectFrom(BufferedInput in, int length, SerialClassContext serialContext) throws IOException {
        if (serialContext == null) {
            throw new NullPointerException();
        }
        Object[] objects = ObjectDeserializer.readBodiesWithTypes(in, length, this.getClasses(serialContext.getClassLoader()), serialContext);
        return (T)(this.single ? objects[0] : objects);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TypedMarshallerImpl)) {
            return false;
        }
        TypedMarshallerImpl that = (TypedMarshallerImpl)o;
        return this.single == that.single && this.types.equals(that.types);
    }

    @Override
    public int hashCode() {
        return (this.single ? 1 : 0) + 2 * this.types.hashCode();
    }

    public String toString() {
        return "TypedMarshaller{single=" + this.single + ", types='" + this.types + '\'' + '}';
    }
}

