/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.io;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

class StringPrefixSet {
    public static final String DEFAULT_NAMES_SEPARATOR = ",";
    public static final StringPrefixSet ANYTHING_SET = new StringPrefixSet(new HashSet<String>(), new TreeSet<String>(Collections.singletonList("")));
    public static final StringPrefixSet NOTHING_SET = new StringPrefixSet(new HashSet<String>(), new TreeSet<String>());
    private static final String ANYTHING_SYMBOL = "*";
    private final HashSet<String> fullNamesSet;
    private final TreeSet<String> prefixSet;

    static StringPrefixSet valueOf(String namesSeparator, String names) {
        if (names == null) {
            return NOTHING_SET;
        }
        return StringPrefixSet.valueOf(Arrays.asList(names.split(namesSeparator)));
    }

    static StringPrefixSet valueOf(String names) {
        if (names == null) {
            return NOTHING_SET;
        }
        return StringPrefixSet.valueOf(Arrays.asList(names.split(DEFAULT_NAMES_SEPARATOR)));
    }

    static StringPrefixSet valueOf(Collection<String> names) {
        if (names == null) {
            return NOTHING_SET;
        }
        HashSet<String> fullNamesSet = new HashSet<String>();
        TreeSet<String> prefixSet = new TreeSet<String>();
        int i = -1;
        for (String name : names) {
            ++i;
            if (name.length() == 0) continue;
            int index = name.indexOf(ANYTHING_SYMBOL);
            if (index == -1) {
                fullNamesSet.add(name);
                continue;
            }
            if (index != name.length() - ANYTHING_SYMBOL.length()) {
                throw new IllegalArgumentException("Name at index " + i + " has wrong format: " + name);
            }
            prefixSet.add(name.substring(0, index));
        }
        return StringPrefixSet.optimize(fullNamesSet, prefixSet);
    }

    private static StringPrefixSet optimize(HashSet<String> fullNamesSet, TreeSet<String> prefixSet) {
        Iterator<String> it;
        if (prefixSet.size() > 1) {
            it = prefixSet.iterator();
            String last = it.next();
            while (it.hasNext()) {
                String cur = it.next();
                if (cur.startsWith(last)) {
                    it.remove();
                    continue;
                }
                last = cur;
            }
        }
        it = fullNamesSet.iterator();
        while (it.hasNext()) {
            String cur = it.next();
            String prefix = prefixSet.floor(cur);
            if (prefix == null || !cur.startsWith(prefix)) continue;
            it.remove();
        }
        if (fullNamesSet.isEmpty()) {
            if (prefixSet.isEmpty()) {
                return NOTHING_SET;
            }
            if (prefixSet.first().length() == 0) {
                return ANYTHING_SET;
            }
        }
        return new StringPrefixSet(fullNamesSet, prefixSet);
    }

    private StringPrefixSet(HashSet<String> fullNamesSet, TreeSet<String> prefixSet) {
        this.fullNamesSet = fullNamesSet;
        this.prefixSet = prefixSet;
    }

    StringPrefixSet add(StringPrefixSet other) {
        if (this == ANYTHING_SET || other == ANYTHING_SET) {
            return ANYTHING_SET;
        }
        if (this == NOTHING_SET && other == NOTHING_SET) {
            return NOTHING_SET;
        }
        if (this != NOTHING_SET && other != NOTHING_SET) {
            HashSet<String> fullNamesSetUnion = new HashSet<String>(other.fullNamesSet);
            fullNamesSetUnion.addAll(this.fullNamesSet);
            TreeSet<String> prefixSetUnion = new TreeSet<String>((SortedSet<String>)other.prefixSet);
            prefixSetUnion.addAll(this.prefixSet);
            return StringPrefixSet.optimize(fullNamesSetUnion, prefixSetUnion);
        }
        return this == NOTHING_SET ? other : this;
    }

    StringPrefixSet copy() {
        if (this == ANYTHING_SET || this == NOTHING_SET) {
            return this;
        }
        return new StringPrefixSet(this.fullNamesSet, this.prefixSet);
    }

    boolean accept(String name) {
        if (this == ANYTHING_SET) {
            return true;
        }
        if (this == NOTHING_SET) {
            return false;
        }
        if (this.fullNamesSet.contains(name)) {
            return true;
        }
        String prefix = this.prefixSet.floor(name);
        return prefix != null && name.startsWith(prefix);
    }

    boolean isAnything() {
        return this == ANYTHING_SET;
    }

    boolean isNothing() {
        return this == NOTHING_SET;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StringPrefixSet)) {
            return false;
        }
        StringPrefixSet other = (StringPrefixSet)o;
        return this.fullNamesSet.equals(other.fullNamesSet) && this.prefixSet.equals(other.prefixSet);
    }

    public int hashCode() {
        return 31 * this.fullNamesSet.hashCode() + this.prefixSet.hashCode();
    }

    public String toString() {
        if (this == ANYTHING_SET) {
            return "StringPrefixSet{ANYTHING}";
        }
        if (this == NOTHING_SET) {
            return "StringPrefixSet{NOTHING}";
        }
        return "StringPrefixSet{prefixes=" + this.prefixSet + ", full names = " + new TreeSet<String>(this.fullNamesSet) + "}";
    }

    public List<String> getList() {
        ArrayList<String> result = new ArrayList<String>(this.fullNamesSet);
        for (String prefix : this.prefixSet) {
            result.add(prefix + ANYTHING_SYMBOL);
        }
        return result;
    }
}

