/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.io;

import com.devexperts.io.BufferedOutput;
import com.devexperts.util.SystemProperties;
import java.io.IOException;
import java.io.OutputStream;

public class StreamOutput
extends BufferedOutput {
    private static final int DEFAULT_SIZE = SystemProperties.getIntProperty(StreamOutput.class, "defaultSize", 8192);
    protected OutputStream out;

    public StreamOutput() {
        this(null, DEFAULT_SIZE);
    }

    public StreamOutput(int size) {
        this(null, size);
    }

    public StreamOutput(OutputStream out) {
        this(out, DEFAULT_SIZE);
    }

    public StreamOutput(OutputStream out, int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("buffer size <= 0");
        }
        this.out = out;
        this.buffer = new byte[size];
        this.limit = this.buffer.length;
    }

    public void setOutput(OutputStream out) {
        this.out = out;
        this.totalPositionBase = 0L;
        this.position = 0;
    }

    public void resetOutput() {
        this.setOutput(null);
    }

    @Override
    public void flush() throws IOException {
        if (this.position == 0) {
            return;
        }
        this.out.write(this.buffer, 0, this.position);
        this.totalPositionBase += (long)this.position;
        this.position = 0;
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.out == null) {
            return;
        }
        this.flush();
        this.out.close();
        this.resetOutput();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len - this.limit >= this.limit - this.position) {
            this.flush();
            this.out.write(b, off, len);
            this.totalPositionBase += (long)len;
        } else {
            super.write(b, off, len);
        }
    }

    @Override
    protected void needSpace() throws IOException {
        this.flush();
    }
}

