/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.io;

import com.devexperts.io.BufferedInput;
import com.devexperts.io.IOUtil;
import com.devexperts.util.SystemProperties;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class StreamInput
extends BufferedInput {
    private static final int DEFAULT_SIZE = SystemProperties.getIntProperty(StreamInput.class, "defaultSize", 8192);
    protected InputStream in;

    public StreamInput() {
        this(null, DEFAULT_SIZE);
    }

    public StreamInput(int size) {
        this(null, size);
    }

    public StreamInput(InputStream in) {
        this(in, DEFAULT_SIZE);
    }

    public StreamInput(InputStream in, int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("buffer size <= 0");
        }
        this.in = in;
        this.buffer = new byte[size];
    }

    public void setInput(InputStream in) {
        this.in = in;
        this.position = 0;
        this.limit = 0;
        this.totalPositionBase = 0L;
        this.markPosition = -1L;
    }

    public void resetInput() {
        this.setInput(null);
    }

    @Override
    public void close() throws IOException {
        if (this.in == null) {
            return;
        }
        this.in.close();
        this.resetInput();
    }

    @Override
    public boolean hasAvailable() throws IOException {
        return this.position < this.limit || this.in.available() > 0;
    }

    @Override
    public boolean hasAvailable(int bytes) throws IOException {
        return this.limit - this.position >= bytes || this.available() >= bytes;
    }

    @Override
    public int available() throws IOException {
        return (int)Math.min((long)(this.limit - this.position) + (long)this.in.available(), Integer.MAX_VALUE);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        IOUtil.checkRange(b, off, len);
        if (len == 0) {
            return 0;
        }
        int buffered = this.limit - this.position;
        if (len <= buffered) {
            System.arraycopy(this.buffer, this.position, b, off, len);
            this.position += len;
            return len;
        }
        System.arraycopy(this.buffer, this.position, b, off, buffered);
        this.position = this.limit;
        this.resetPositionIfNotMarked();
        if (this.markPosition < 0L && len - buffered > this.buffer.length >> 1) {
            int k = this.in.read(b, off + buffered, len - buffered);
            if (k <= 0) {
                return buffered > 0 ? buffered : -1;
            }
            this.totalPositionBase += (long)k;
            return buffered + k;
        }
        int k = this.readData();
        if (k <= 0) {
            return buffered > 0 ? buffered : -1;
        }
        k = Math.min(k, len - buffered);
        System.arraycopy(this.buffer, this.position, b, off + buffered, k);
        this.position += k;
        return buffered + k;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        int buffered = this.limit - this.position;
        if (n <= (long)buffered) {
            this.position = (int)((long)this.position + n);
            return n;
        }
        this.position = this.limit;
        this.resetPositionIfNotMarked();
        if (this.markPosition < 0L) {
            long k = this.in.skip(n - (long)buffered);
            if (k <= 0L) {
                return buffered;
            }
            this.totalPositionBase += k;
            return (long)buffered + k;
        }
        long k = this.readData();
        if (k <= 0L) {
            return buffered;
        }
        k = Math.min(k, n - (long)buffered);
        this.position = (int)((long)this.position + k);
        return (long)buffered + k;
    }

    @Override
    public void rewind(long n) {
        this.checkRewind(n);
        this.position = (int)((long)this.position - n);
    }

    @Override
    protected int readData() throws IOException {
        int result;
        this.checkEOB();
        this.resetPositionIfNotMarked();
        if (this.markPosition >= 0L && this.limit > this.buffer.length >> 1) {
            byte[] newBuffer;
            int markPos = (int)(this.markPosition - this.totalPositionBase);
            int marked = this.limit - markPos;
            if (markPos > marked) {
                newBuffer = this.buffer;
            } else if (this.buffer.length < Integer.MAX_VALUE) {
                newBuffer = new byte[Math.max((int)Math.min((long)this.buffer.length << 1, Integer.MAX_VALUE), 1024)];
            } else if (markPos > 0) {
                newBuffer = this.buffer;
            } else {
                if (this.limit == this.buffer.length) {
                    throw new IOException("Buffer overflow.");
                }
                newBuffer = null;
            }
            if (newBuffer != null) {
                System.arraycopy(this.buffer, markPos, newBuffer, 0, marked);
                this.buffer = newBuffer;
                this.position -= markPos;
                this.limit -= markPos;
                this.totalPositionBase += (long)markPos;
            }
        }
        if ((result = this.in.read(this.buffer, this.limit, this.buffer.length - this.limit)) > 0) {
            this.limit += result;
        }
        return result;
    }

    @Override
    protected void throwEOFException() throws EOFException {
        throw new EOFException();
    }

    private void resetPositionIfNotMarked() {
        assert (this.position == this.limit);
        if (this.markPosition >= 0L) {
            return;
        }
        this.totalPositionBase = this.totalPosition();
        this.position = 0;
        this.limit = 0;
    }
}

