/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.io;

import com.devexperts.util.InvalidFormatException;
import com.devexperts.util.SystemProperties;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public final class StreamCompression {
    private static final int GZIP_BUFFER_SIZE = SystemProperties.getIntProperty(StreamCompression.class, "gzipBufferSize", 4096, 1, 0x40000000);
    private static final int ZIP_BUFFER_SIZE = SystemProperties.getIntProperty(StreamCompression.class, "zipBufferSize", 4096, 1, 0x40000000);
    private static final int DEFAULT_LEVEL = -1;
    private static final String LEVEL_PREFIX = "[";
    private static final String LEVEL_NAME = "level=";
    private static final String LEVEL_SUFFIX = "]";
    private static final int KIND_NONE = 0;
    private static final int KIND_GZIP = 1;
    private static final int KIND_ZIP = 2;
    public static final StreamCompression NONE = new StreamCompression(0, "none", null, "", -1);
    public static final StreamCompression GZIP = new StreamCompression(1, "gzip", "application/gzip", ".gz", -1);
    public static final StreamCompression ZIP = new StreamCompression(2, "zip", "application/zip", ".zip", -1);
    private final int kind;
    private final String name;
    private final String mimeType;
    private final String extension;
    private final int level;

    public static StreamCompression valueOf(String value) {
        StreamCompression base;
        int j;
        String s = value;
        int level = -1;
        int i = s.indexOf(LEVEL_PREFIX);
        if (i >= 0 && s.endsWith(LEVEL_SUFFIX) && (j = i + LEVEL_PREFIX.length() + LEVEL_NAME.length()) <= s.length() && s.substring(i + LEVEL_PREFIX.length(), j).equalsIgnoreCase(LEVEL_NAME)) {
            try {
                level = Integer.parseInt(s.substring(j, s.length() - LEVEL_SUFFIX.length()));
            }
            catch (NumberFormatException e) {
                throw new InvalidFormatException("Invalid compression '" + value + "'", e);
            }
            if (level < 0 || level > 9) {
                throw new InvalidFormatException("Invalid compression '" + value + "'");
            }
            s = s.substring(0, i);
        }
        if (s.equalsIgnoreCase(StreamCompression.NONE.name) && level == -1) {
            return NONE;
        }
        if (s.equalsIgnoreCase(StreamCompression.GZIP.name)) {
            base = GZIP;
        } else if (s.equalsIgnoreCase(StreamCompression.ZIP.name)) {
            base = ZIP;
        } else {
            throw new InvalidFormatException("Invalid compression '" + value + "'");
        }
        if (level == -1) {
            return base;
        }
        return new StreamCompression(base.kind, base.name, base.mimeType, base.extension, level);
    }

    public static StreamCompression detectCompressionByMimeType(String mimeType) {
        if (mimeType.equalsIgnoreCase(StreamCompression.GZIP.mimeType) || mimeType.equalsIgnoreCase("application/gzip") || mimeType.equalsIgnoreCase("application/x-gzip")) {
            return GZIP;
        }
        if (mimeType.equalsIgnoreCase(StreamCompression.ZIP.mimeType)) {
            return ZIP;
        }
        return NONE;
    }

    public static StreamCompression detectCompressionByExtension(String fileName) {
        if ((fileName = fileName.toLowerCase(Locale.ROOT)).endsWith(StreamCompression.GZIP.extension)) {
            return GZIP;
        }
        if (fileName.endsWith(StreamCompression.ZIP.extension)) {
            return ZIP;
        }
        return NONE;
    }

    public static StreamCompression detectCompressionByHeader(InputStream in) throws IOException {
        int r;
        if (!in.markSupported()) {
            throw new IllegalArgumentException("mark is not supported");
        }
        int n = 4;
        byte[] buffer = new byte[n];
        in.mark(n);
        int pos = 0;
        while ((r = in.read(buffer, pos, n - pos)) > 0 && (pos += r) < n) {
        }
        in.reset();
        if (pos >= 2 && buffer[0] == 31 && buffer[1] == -117) {
            return GZIP;
        }
        if (pos >= 4 && buffer[0] == 80 && buffer[1] == 75 && buffer[2] == 3 && buffer[3] == 4) {
            return ZIP;
        }
        return NONE;
    }

    public static InputStream detectCompressionByHeaderAndDecompress(InputStream in) throws IOException {
        if (!in.markSupported()) {
            in = new BufferedInputStream(in);
        }
        return StreamCompression.detectCompressionByHeader(in).decompress(in);
    }

    private StreamCompression(int kind, String name, String mimeType, String extension, int level) {
        this.kind = kind;
        this.name = name;
        this.mimeType = mimeType;
        this.extension = extension;
        this.level = level;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getExtension() {
        return this.extension;
    }

    public String stripExtension(String fileName) {
        if (fileName.endsWith(this.extension)) {
            return fileName.substring(0, fileName.length() - this.extension.length());
        }
        return fileName;
    }

    public boolean hasSyncFlush() {
        return true;
    }

    public InputStream decompress(InputStream in) throws IOException {
        switch (this.kind) {
            case 0: {
                return in;
            }
            case 1: {
                return new GZIPInput(in, GZIP_BUFFER_SIZE);
            }
            case 2: {
                return new ZipInput(in, ZIP_BUFFER_SIZE);
            }
        }
        throw new AssertionError();
    }

    public OutputStream compress(OutputStream out, String name) throws IOException {
        switch (this.kind) {
            case 0: {
                return out;
            }
            case 1: {
                return new GZIPOutput(out, GZIP_BUFFER_SIZE, this.level);
            }
            case 2: {
                return new ZipOutput(out, ZIP_BUFFER_SIZE, this.level, name);
            }
        }
        throw new AssertionError();
    }

    public String toString() {
        if (this.level == -1) {
            return this.name;
        }
        return this.name + LEVEL_PREFIX + LEVEL_NAME + this.level + LEVEL_SUFFIX;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StreamCompression)) {
            return false;
        }
        StreamCompression that = (StreamCompression)o;
        return this.kind == that.kind && this.level == that.level;
    }

    public int hashCode() {
        return 31 * this.kind + this.level;
    }

    private static class ZipInput
    extends ZipInputStream {
        ZipInput(InputStream in, int size) throws IOException {
            super(in);
            ZipEntry entry;
            this.buf = new byte[size];
            do {
                if ((entry = this.getNextEntry()) != null) continue;
                throw new IOException("No file entries in zip");
            } while (entry.isDirectory());
        }

        @Override
        public int available() throws IOException {
            return 0;
        }
    }

    private static class ZipOutput
    extends ZipOutputStream {
        ZipOutput(OutputStream out, int size, int level, String name) throws IOException {
            super(out);
            this.buf = new byte[size];
            this.setLevel(level);
            this.putNextEntry(new ZipEntry(name));
        }

        @Override
        public void flush() throws IOException {
            if (!this.def.finished()) {
                int len;
                while ((len = this.def.deflate(this.buf, 0, this.buf.length, 2)) > 0) {
                    this.out.write(this.buf, 0, len);
                    if (len >= this.buf.length) continue;
                }
            }
            this.out.flush();
        }
    }

    private static class GZIPInput
    extends GZIPInputStream {
        GZIPInput(InputStream in, int size) throws IOException {
            super(in, size);
        }

        @Override
        public int available() throws IOException {
            return 0;
        }
    }

    private static class GZIPOutput
    extends GZIPOutputStream {
        GZIPOutput(OutputStream out, int size, int level) throws IOException {
            super(out, size, true);
            this.def.setLevel(level);
        }
    }
}

