/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.io;

import com.devexperts.io.BufferedInput;
import com.devexperts.io.BufferedOutput;
import com.devexperts.io.Marshaller;
import com.devexperts.io.ObjectDeserializer;
import com.devexperts.io.ObjectSerializer;
import com.devexperts.io.SerialClassContext;
import java.io.IOException;
import java.io.InvalidClassException;

final class SerializationMarshallerImpl<T>
extends Marshaller<T> {
    static final Class<Object> OBJECT_TYPE = Object.class;
    private final Class<T> type;

    SerializationMarshallerImpl(Class<T> type) {
        if (type == null) {
            throw new NullPointerException();
        }
        this.type = type;
    }

    @Override
    public void writeObjectTo(BufferedOutput out, T object) throws IOException {
        if (object == null) {
            throw new NullPointerException();
        }
        if (!this.isCorrectType(object)) {
            throw new IllegalArgumentException("Invalid type " + object.getClass().getName() + ", expected " + this.type.getName());
        }
        ObjectSerializer.writeBody(out, object);
    }

    @Override
    public T readObjectFrom(BufferedInput in, int length, SerialClassContext serialClassContext) throws IOException {
        if (length < 0) {
            throw new IllegalArgumentException();
        }
        if (serialClassContext == null) {
            throw new NullPointerException();
        }
        Object object = ObjectDeserializer.readBody(in, length, serialClassContext);
        if (!this.isCorrectType(object)) {
            throw new InvalidClassException("Invalid type " + object.getClass().getName() + ", expected " + this.type.getName());
        }
        return (T)object;
    }

    private boolean isCorrectType(Object object) {
        return this.type == OBJECT_TYPE || this.type.isInstance(object);
    }

    @Override
    public boolean equals(Object o) {
        return this == o || o instanceof SerializationMarshallerImpl && this.type.equals(((SerializationMarshallerImpl)o).type);
    }

    @Override
    public int hashCode() {
        return this.type.hashCode();
    }

    public String toString() {
        return "SerializationMarshaller{type=" + this.type + '}';
    }
}

