/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.io;

import com.devexperts.io.ClassUtil;
import com.devexperts.io.StringPrefixSet;
import com.devexperts.logging.Logging;
import com.devexperts.util.LogUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;

public class SerialClassContext {
    public static final String DEFAULT_WHITE_LIST_NAME = "/META-INF/SerialClassWhitelist.txt";
    public static final String DEFAULT_BLACK_LIST_NAME = "/META-INF/SerialClassBlacklist.txt";
    private static final Map<ClassLoader, SerialClassContext> defaultSerialContextMap = Collections.synchronizedMap(new WeakHashMap());
    private static final String ARRAY_PREFIX = "[";
    private static final Logging log = Logging.getLogging(SerialClassContext.class);
    private final StringPrefixSet whitelist;
    private final StringPrefixSet blacklist;
    private final WeakReference<ClassLoader> weakLoader;

    public static SerialClassContext createSerialClassContext(ClassLoader loader, Collection<String> whiteClasses, Collection<String> blackClasses) {
        return new SerialClassContext(ClassUtil.resolveContextClassLoader(loader), whiteClasses == null ? StringPrefixSet.ANYTHING_SET : StringPrefixSet.valueOf(whiteClasses), blackClasses == null ? StringPrefixSet.NOTHING_SET : StringPrefixSet.valueOf(blackClasses));
    }

    public static SerialClassContext getDefaultSerialContext(ClassLoader loader) {
        return defaultSerialContextMap.computeIfAbsent(ClassUtil.resolveContextClassLoader(loader), SerialClassContext::readSerialClassContext);
    }

    private static SerialClassContext readSerialClassContext(ClassLoader cl) {
        StringPrefixSet whitelist = SerialClassContext.readPrefixSet(cl, DEFAULT_WHITE_LIST_NAME, StringPrefixSet.ANYTHING_SET);
        StringPrefixSet blacklist = SerialClassContext.readPrefixSet(cl, DEFAULT_BLACK_LIST_NAME, StringPrefixSet.NOTHING_SET);
        return new SerialClassContext(cl, whitelist, blacklist);
    }

    private static StringPrefixSet readPrefixSet(ClassLoader cl, String prefixSetName, StringPrefixSet def) {
        ArrayList<URL> urls;
        try {
            urls = Collections.list(cl.getResources(prefixSetName));
        }
        catch (IOException e) {
            return def;
        }
        if (urls.isEmpty()) {
            return def;
        }
        ArrayList<String> names = new ArrayList<String>();
        for (URL url : urls) {
            try {
                BufferedReader r = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));
                Throwable throwable = null;
                try {
                    String line;
                    while ((line = r.readLine()) != null) {
                        names.addAll(Arrays.asList(line.split(",")));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (r == null) continue;
                    if (throwable != null) {
                        try {
                            r.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    r.close();
                }
            }
            catch (IOException e) {
                log.error("Cannot read " + LogUtil.hideCredentials(url), e);
            }
        }
        return names.isEmpty() ? def : StringPrefixSet.valueOf(names);
    }

    private SerialClassContext(ClassLoader loader, StringPrefixSet whitelist, StringPrefixSet blacklist) {
        this.weakLoader = new WeakReference<ClassLoader>(loader);
        this.whitelist = whitelist;
        this.blacklist = blacklist;
    }

    public List<String> getWhitelist() {
        return this.whitelist.getList();
    }

    public List<String> getBlacklist() {
        return this.blacklist.getList();
    }

    public ClassLoader getClassLoader() {
        return (ClassLoader)this.weakLoader.get();
    }

    public boolean accept(String className) {
        Objects.requireNonNull(className, "className");
        if (className.startsWith(ARRAY_PREFIX)) {
            return true;
        }
        if (this.blacklist.accept(className)) {
            return false;
        }
        return this.whitelist.accept(className);
    }

    public void check(String className) throws ClassNotFoundException {
        Objects.requireNonNull(className, "className");
        if (className.startsWith(ARRAY_PREFIX)) {
            return;
        }
        if (this.blacklist.accept(className)) {
            throw new ClassNotFoundException("Class " + className + " is in the blacklist.");
        }
        if (!this.whitelist.accept(className)) {
            throw new ClassNotFoundException("Class " + className + " is not in the whitelist.");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SerialClassContext other = (SerialClassContext)o;
        if (!this.whitelist.equals(other.whitelist)) {
            return false;
        }
        if (!this.blacklist.equals(other.blacklist)) {
            return false;
        }
        return Objects.equals(this.weakLoader.get(), other.weakLoader.get());
    }

    public int hashCode() {
        return this.whitelist.hashCode() + this.blacklist.hashCode();
    }
}

