/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.io;

import com.devexperts.io.BufferedOutput;
import com.devexperts.io.ByteArrayOutput;
import com.devexperts.io.CompactSerializer;
import com.devexperts.io.Compression;
import com.devexperts.io.IOUtil;
import com.devexperts.io.Marshalled;
import com.devexperts.io.MarshallingException;
import com.devexperts.io.ObjectIOImplUtil;
import com.devexperts.io.SerializationMarshallerImpl;
import com.devexperts.util.LockFreePool;
import com.devexperts.util.SystemProperties;
import java.io.DataOutput;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;

class ObjectSerializer {
    private static final int MAX_POOLED_BUFFER = SystemProperties.getIntProperty(ObjectSerializer.class, "maxPooledBuffer", 16384);
    private static final LockFreePool<ObjectSerializer> POOL = new LockFreePool(ObjectSerializer.class.getName(), 16);
    private final ByteArrayOutput bao = new ByteArrayOutput(MAX_POOLED_BUFFER);
    private final ObjectOutputStream oos = new ObjectOutputStream(this.bao);

    private static ObjectSerializer allocate() throws IOException {
        ObjectSerializer os = POOL.poll();
        return os != null ? os : new ObjectSerializer();
    }

    private static void release(ObjectSerializer os) throws IOException {
        if (os.bao.getPosition() > MAX_POOLED_BUFFER) {
            return;
        }
        os.reset();
        POOL.offer(os);
    }

    static byte[] toBytes(Object object) throws IOException {
        if (object == null) {
            return null;
        }
        if (object instanceof Marshalled) {
            Marshalled marshalled = (Marshalled)object;
            if (!(marshalled.getMarshaller() instanceof SerializationMarshallerImpl)) {
                throw new NotSerializableException(Marshalled.class.getName());
            }
            try {
                return marshalled.getBytes();
            }
            catch (MarshallingException e) {
                throw e.getCause();
            }
        }
        ObjectSerializer os = ObjectSerializer.allocate();
        byte[] bytes = os.toBytesImpl(object);
        ObjectSerializer.release(os);
        return bytes;
    }

    static void writeCompact(DataOutput out, Object object) throws IOException {
        if (object == null) {
            IOUtil.writeCompactInt(out, -1);
            return;
        }
        if (object instanceof Marshalled) {
            ObjectSerializer.writeMarshalled(out, (Marshalled)object);
            return;
        }
        ObjectSerializer os = ObjectSerializer.allocate();
        os.writeCompactImpl(out, object);
        ObjectSerializer.release(os);
    }

    private static void writeMarshalled(DataOutput out, Marshalled<?> marshalled) throws IOException {
        if (!(marshalled.getMarshaller() instanceof SerializationMarshallerImpl)) {
            throw new NotSerializableException(Marshalled.class.getName());
        }
        try {
            IOUtil.writeByteArray(out, marshalled.getBytes());
        }
        catch (MarshallingException e) {
            throw e.getCause();
        }
    }

    static void writeBody(BufferedOutput out, Object object) throws IOException {
        if (object instanceof Marshalled) {
            ObjectSerializer.writeMarshalled(out, (Marshalled)object);
            return;
        }
        ObjectSerializer os = ObjectSerializer.allocate();
        os.writeBodyImpl(out, object);
        ObjectSerializer.release(os);
    }

    private static void writeMarshalled(BufferedOutput out, Marshalled<?> marshalled) throws IOException {
        if (!(marshalled.getMarshaller() instanceof SerializationMarshallerImpl)) {
            throw new NotSerializableException(Marshalled.class.getName());
        }
        try {
            out.write(marshalled.getBytes());
        }
        catch (MarshallingException e) {
            throw e.getCause();
        }
    }

    static void writeBodiesWithTypes(BufferedOutput out, Class<?>[] types, Object ... objects) throws IOException {
        if (types.length != objects.length) {
            throw new IOException("Number of objects does not match number of types");
        }
        ObjectSerializer os = ObjectSerializer.allocate();
        os.writeBodiesWithTypesImpl(out, types, objects);
        ObjectSerializer.release(os);
    }

    private ObjectSerializer() throws IOException {
        this.bao.clear();
    }

    private void reset() throws IOException {
        this.oos.reset();
        this.oos.flush();
        this.bao.clear();
    }

    private byte[] toBytesImpl(Object object) throws IOException {
        this.bao.write(ObjectIOImplUtil.STREAM_HEADER);
        this.oos.writeObject(object);
        this.oos.flush();
        return this.compressResultToBytes();
    }

    private byte[] compressResultToBytes() {
        if (Compression.shallCompress(this.bao.getBuffer(), 0, this.bao.getPosition())) {
            int pos = this.bao.getPosition();
            Compression.deflate(this.bao.getBuffer(), 0, pos, 1, this.bao);
            if (this.bao.getPosition() - pos < pos - (pos >> 2)) {
                byte[] b = new byte[this.bao.getPosition() - pos];
                System.arraycopy(this.bao.getBuffer(), pos, b, 0, b.length);
                this.bao.setPosition(pos);
                return b;
            }
            this.bao.setPosition(pos);
        }
        return this.bao.toByteArray();
    }

    private void writeCompactImpl(DataOutput out, Object object) throws IOException {
        this.bao.write(ObjectIOImplUtil.STREAM_HEADER);
        this.oos.writeObject(object);
        this.oos.flush();
        if (Compression.shallCompress(this.bao.getBuffer(), 0, this.bao.getPosition()) && this.tryCompressWithSize(out)) {
            return;
        }
        IOUtil.writeCompactInt(out, this.bao.getPosition());
        out.write(this.bao.getBuffer(), 0, this.bao.getPosition());
    }

    private boolean tryCompressWithSize(DataOutput out) throws IOException {
        int pos = this.bao.getPosition();
        Compression.deflate(this.bao.getBuffer(), 0, pos, 1, this.bao);
        if (this.bao.getPosition() - pos < pos - (pos >> 2)) {
            IOUtil.writeCompactInt(out, this.bao.getPosition() - pos);
            out.write(this.bao.getBuffer(), pos, this.bao.getPosition() - pos);
            this.bao.setPosition(pos);
            return true;
        }
        this.bao.setPosition(pos);
        return false;
    }

    private void writeBodyImpl(BufferedOutput out, Object object) throws IOException {
        this.bao.write(ObjectIOImplUtil.STREAM_HEADER);
        this.oos.writeObject(object);
        this.oos.flush();
        this.compressAndWriteResult(out);
    }

    private void writeBodiesWithTypesImpl(BufferedOutput out, Class<?>[] types, Object[] objects) throws IOException {
        int i;
        this.bao.writeInt(ObjectIOImplUtil.getDeclaredTypesSignature(types));
        boolean objectsPresent = false;
        for (i = 0; i < types.length; ++i) {
            if (CompactSerializer.isCompact(types[i])) {
                CompactSerializer.writeCompact(this.bao, types[i], objects[i]);
                continue;
            }
            objectsPresent = true;
        }
        if (objectsPresent) {
            this.bao.write(ObjectIOImplUtil.STREAM_HEADER);
            for (i = 0; i < types.length; ++i) {
                if (CompactSerializer.isCompact(types[i])) continue;
                Object object = objects[i];
                if (object instanceof Marshalled) {
                    try {
                        object = ((Marshalled)object).getObject();
                    }
                    catch (MarshallingException e) {
                        throw e.getCause();
                    }
                }
                if (object != null && !types[i].isInstance(object)) {
                    throw new IOException("Invalid type " + object.getClass().getName() + ", expected " + types[i]);
                }
                this.oos.writeObject(object);
            }
            this.oos.flush();
        }
        this.compressAndWriteResult(out);
    }

    private void compressAndWriteResult(BufferedOutput out) throws IOException {
        if (Compression.shallCompress(this.bao.getBuffer(), 0, this.bao.getPosition())) {
            int pos = this.bao.getPosition();
            Compression.deflate(this.bao.getBuffer(), 0, pos, 1, this.bao);
            if (this.bao.getPosition() - pos < pos - (pos >> 2)) {
                out.write(this.bao.getBuffer(), pos, this.bao.getPosition() - pos);
                this.bao.setPosition(pos);
                return;
            }
            this.bao.setPosition(pos);
        }
        out.write(this.bao.getBuffer(), 0, this.bao.getPosition());
    }
}

