/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.io;

import com.devexperts.io.BufferedInput;
import com.devexperts.io.ByteArrayInput;
import com.devexperts.io.ByteArrayOutput;
import com.devexperts.io.ClassUtil;
import com.devexperts.io.CompactSerializer;
import com.devexperts.io.Compression;
import com.devexperts.io.IOUtil;
import com.devexperts.io.ObjectIOImplUtil;
import com.devexperts.io.SerialClassContext;
import com.devexperts.logging.Logging;
import com.devexperts.util.LockFreePool;
import com.devexperts.util.SystemProperties;
import java.io.DataInput;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Objects;
import java.util.zip.DataFormatException;

class ObjectDeserializer
extends ObjectInputStream {
    private static final Logging log = Logging.getLogging(ObjectDeserializer.class);
    private static final boolean DUMP_ERRORS = SystemProperties.getBooleanProperty(ObjectDeserializer.class, "dumpErrors", false);
    private static final int MAX_BYTES_TO_LOG = SystemProperties.getIntProperty(ObjectDeserializer.class, "maxBytesToLog", 1024);
    private static final char[] DIGITS = "0123456789ABCDEF".toCharArray();
    private static final int MAX_POOLED_BUFFER = SystemProperties.getIntProperty(ObjectDeserializer.class, "maxPooledBuffer", 16384);
    private static final LockFreePool<ObjectDeserializer> POOL = new LockFreePool(ObjectDeserializer.class.getName(), 16);
    private final ByteArrayInput bai;
    private final ByteArrayOutput bao;
    private byte[] pooledBuffer;
    private byte[] dumpBytes;
    private int dumpOffset;
    private int dumpLength;
    private SerialClassContext serialContext;

    private static ObjectDeserializer allocate(SerialClassContext serialContext) throws IOException {
        ObjectDeserializer od = POOL.poll();
        if (od == null) {
            od = new ObjectDeserializer(new ByteArrayInput());
        }
        od.serialContext = Objects.requireNonNull(serialContext);
        return od;
    }

    private static void release(ObjectDeserializer od) throws IOException {
        if (od.bai.getPosition() != od.bai.getLimit()) {
            throw new IOException("Some input data was not deserialized");
        }
        if (od.bai.getPosition() > MAX_POOLED_BUFFER) {
            return;
        }
        od.bai.setBuffer(ObjectIOImplUtil.STREAM_RESET);
        try {
            if (od.readLong() != 1234395879875320345L) {
                return;
            }
        }
        catch (IOException e) {
            return;
        }
        if (od.bai.getPosition() != od.bai.getLimit()) {
            return;
        }
        od.bai.setBuffer(null);
        od.bao.setBuffer(null);
        od.dumpBytes = null;
        od.serialContext = null;
        POOL.offer(od);
    }

    static Object toObject(byte[] bytes, SerialClassContext serialContext) throws IOException {
        if (bytes == null) {
            return null;
        }
        ObjectDeserializer od = ObjectDeserializer.allocate(serialContext);
        try {
            Object object;
            od.decompressAndSetInput(bytes, 0, bytes.length);
            od.checkObjectHeader();
            try {
                object = od.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new InvalidClassException("Class not found: " + e.getMessage());
            }
            ObjectDeserializer.release(od);
            return object;
        }
        catch (Throwable t) {
            od.dumpError(null, t);
            return ObjectDeserializer.rethrowIOException(t);
        }
    }

    static Object readCompact(DataInput in, SerialClassContext serialContext) throws IOException {
        long length = IOUtil.readCompactLong(in);
        if (length < -1L || length > Integer.MAX_VALUE) {
            throw new IOException("Illegal length: " + length);
        }
        if (length == -1L) {
            return null;
        }
        return ObjectDeserializer.readBody(in, (int)length, serialContext);
    }

    static Object readBody(DataInput in, int length, SerialClassContext serialContext) throws IOException {
        ObjectDeserializer od = ObjectDeserializer.allocate(serialContext);
        try {
            Object object;
            od.decompressAndSetInput(in, length);
            od.checkObjectHeader();
            try {
                object = od.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new InvalidClassException("Class not found: " + e.getMessage());
            }
            ObjectDeserializer.release(od);
            return object;
        }
        catch (Throwable t) {
            od.dumpError(null, t);
            return ObjectDeserializer.rethrowIOException(t);
        }
    }

    static Object[] readBodiesWithTypes(DataInput in, int length, Class<?>[] types, SerialClassContext serialContext) throws IOException {
        ObjectDeserializer od = ObjectDeserializer.allocate(serialContext);
        try {
            int i;
            od.decompressAndSetInput(in, length);
            int expectedSignature = ObjectIOImplUtil.getDeclaredTypesSignature(types);
            int actualSignature = od.bai.readInt();
            if (actualSignature != expectedSignature) {
                throw new IOException(actualSignature >>> 24 != expectedSignature >>> 24 ? "Not a declared types stream." : "Wrong declared types signature, expected: " + Integer.toHexString(expectedSignature) + ", got " + Integer.toHexString(actualSignature));
            }
            Object[] objects = new Object[types.length];
            boolean objectsPresent = false;
            for (i = 0; i < types.length; ++i) {
                if (CompactSerializer.isCompact(types[i])) {
                    objects[i] = CompactSerializer.readCompact(od.bai, types[i]);
                    continue;
                }
                objectsPresent = true;
            }
            if (objectsPresent) {
                od.checkObjectHeader();
                for (i = 0; i < types.length; ++i) {
                    if (CompactSerializer.isCompact(types[i])) continue;
                    try {
                        objects[i] = od.readObject();
                        if (objects[i] == null || types[i].isInstance(objects[i])) continue;
                        throw new InvalidClassException("Invalid type " + objects[i].getClass().getName() + ", expected " + types[i].getName());
                    }
                    catch (ClassNotFoundException e) {
                        throw new InvalidClassException("Class not found: " + e.getMessage()).initCause(e);
                    }
                }
            }
            ObjectDeserializer.release(od);
            return objects;
        }
        catch (Throwable t) {
            od.dumpError(types, t);
            return ObjectDeserializer.rethrowIOException(t);
        }
    }

    private static Object[] rethrowIOException(Throwable t) throws IOException {
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof IOException) {
            throw (IOException)t;
        }
        throw new RuntimeException("Unexpected exception", t);
    }

    private ObjectDeserializer(ByteArrayInput bai) throws IOException {
        super(bai);
        this.bai = bai;
        this.bao = new ByteArrayOutput();
    }

    private byte[] readFullyIntoBuffer(DataInput in, int length) throws IOException {
        byte[] bytes;
        if (length <= MAX_POOLED_BUFFER) {
            if (this.pooledBuffer == null) {
                this.pooledBuffer = new byte[MAX_POOLED_BUFFER];
            }
            bytes = this.pooledBuffer;
        } else {
            bytes = new byte[length];
        }
        in.readFully(bytes, 0, length);
        return bytes;
    }

    private void decompressAndSetInput(DataInput in, int length) throws IOException {
        if (in instanceof BufferedInput && ((BufferedInput)in).readToCaptureBytes(this::decompressAndSetInput, length)) {
            return;
        }
        this.decompressAndSetInput(this.readFullyIntoBuffer(in, length), 0, length);
    }

    private void decompressAndSetInput(byte[] bytes, int offset, int length) {
        this.dumpBytes = bytes;
        this.dumpOffset = offset;
        this.dumpLength = length;
        try {
            while (Compression.isCompressed(bytes, offset, length)) {
                if (this.pooledBuffer == null) {
                    this.pooledBuffer = new byte[MAX_POOLED_BUFFER];
                }
                if (this.bao.getLimit() == 0) {
                    this.bao.setBuffer(this.pooledBuffer);
                }
                if (this.bao.getBuffer() == bytes) {
                    this.bao.setPosition(offset + length);
                }
                int pos = this.bao.getPosition();
                Compression.inflate(bytes, offset, length, this.bao);
                bytes = this.bao.getBuffer();
                offset = pos;
                length = this.bao.getPosition() - pos;
            }
        }
        catch (DataFormatException dataFormatException) {
            // empty catch block
        }
        this.bai.setInput(bytes, offset, length);
    }

    private void checkObjectHeader() throws IOException {
        for (byte b : ObjectIOImplUtil.STREAM_HEADER) {
            if (this.bai.readByte() == b) continue;
            throw new StreamCorruptedException("invalid stream header");
        }
    }

    private void dumpError(Class[] types, Throwable thrown) {
        if (!DUMP_ERRORS) {
            return;
        }
        try {
            ClassLoader cl;
            StringBuilder message = new StringBuilder("An error has occurred while deserializing object:\n");
            if (types != null) {
                message.append("  Object types: ").append(Arrays.toString(types)).append("\n");
            }
            if ((cl = this.serialContext.getClassLoader()) != null) {
                message.append("  Classloader: ").append(cl).append('\n');
            }
            if (this.dumpLength <= MAX_BYTES_TO_LOG) {
                message.append("  Bytes: [");
                for (int i = 0; i < this.dumpLength; ++i) {
                    byte b = this.dumpBytes[this.dumpOffset + i];
                    message.append(DIGITS[b >> 4 & 0xF]).append(DIGITS[b & 0xF]).append(' ');
                }
                message.setCharAt(message.length() - 1, ']');
            } else {
                String fileName = "deserialization-" + new SimpleDateFormat("yyyyMMdd-HHmmss.SSS").format(new Date()) + ".dump";
                try {
                    try (FileOutputStream outputStream = new FileOutputStream(fileName);){
                        outputStream.write(this.dumpBytes, this.dumpOffset, this.dumpLength);
                    }
                    message.append("  Bytes were dumped into ").append(fileName);
                }
                catch (Throwable t) {
                    message.append("  Failed to dump bytes into ").append(fileName).append(" because of ").append(t.toString());
                }
            }
            log.error(message.toString(), thrown);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    protected void readStreamHeader() throws IOException {
    }

    protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        if (ClassUtil.isPrimitiveType(desc.getName())) {
            return ClassUtil.getTypeClass(desc.getName(), null);
        }
        try {
            this.serialContext.check(desc.getName());
        }
        catch (ClassNotFoundException e) {
            throw new InvalidClassException(e.getMessage());
        }
        try {
            return ClassUtil.getTypeClass(desc.getName(), this.serialContext.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return super.resolveClass(desc);
        }
    }
}

