/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.io;

import com.devexperts.io.BufferedInput;
import com.devexperts.io.BufferedOutput;
import com.devexperts.io.ByteArrayOutput;
import com.devexperts.io.Marshalled;
import com.devexperts.io.SerialClassContext;
import com.devexperts.io.SerializationMarshallerImpl;
import com.devexperts.io.TypedMarshallerImpl;
import java.io.IOException;
import java.io.InvalidClassException;

public abstract class Marshaller<T> {
    private volatile Marshalled<T> nullObjectMarshalled;
    private volatile Marshalled<T> nullBytesMarshalled;
    public static final Marshaller<Object> SERIALIZATION = new SerializationMarshallerImpl<Object>(SerializationMarshallerImpl.OBJECT_TYPE);

    protected Marshaller() {
    }

    public static <T> Marshaller<T> serialization(Class<T> clazz) {
        return new SerializationMarshallerImpl<T>(clazz);
    }

    public static Marshaller<Object> serialization() {
        return new SerializationMarshallerImpl<Object>(SerializationMarshallerImpl.OBJECT_TYPE);
    }

    public static <T> Typed<T> forClass(Class<? extends T> clazz) {
        return new TypedMarshallerImpl(true, clazz);
    }

    @SafeVarargs
    public static <T> Typed<T[]> forClasses(Class<? extends T> ... classes) {
        return new TypedMarshallerImpl<T[]>(false, classes);
    }

    public static Typed<?> forType(String type) {
        return new TypedMarshallerImpl(true, type);
    }

    public static Typed<Object[]> forTypes(String types) {
        return new TypedMarshallerImpl<Object[]>(false, types);
    }

    public void writeMarshalledLength(BufferedOutput out, int length) throws IOException {
        out.writeCompactInt(length);
    }

    public int readMarshalledLength(BufferedInput in) throws IOException {
        return in.readCompactInt();
    }

    public abstract void writeObjectTo(BufferedOutput var1, T var2) throws IOException;

    public abstract T readObjectFrom(BufferedInput var1, int var2, SerialClassContext var3) throws IOException;

    public boolean supportsNullObject() {
        return true;
    }

    public boolean representsNullObjectAsNullBytes() {
        return true;
    }

    public boolean equals(Object obj) {
        return obj != null && this.getClass().equals(obj.getClass());
    }

    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    Marshalled<T> getNullObjectMarshalled() {
        if (!this.supportsNullObject()) {
            throw new NullPointerException("Null object is not supported by " + this);
        }
        Marshalled<T> nullObjectMarshalled = this.nullObjectMarshalled;
        if (nullObjectMarshalled != null) {
            return nullObjectMarshalled;
        }
        return this.getNullObjectMarshalledSync();
    }

    private synchronized Marshalled<T> getNullObjectMarshalledSync() {
        Marshalled<Object> nullObjectMarshalled = this.nullObjectMarshalled;
        if (nullObjectMarshalled != null) {
            return nullObjectMarshalled;
        }
        if (this.representsNullObjectAsNullBytes()) {
            nullObjectMarshalled = this.getNullBytesMarshalledSync();
        } else {
            ByteArrayOutput out = new ByteArrayOutput();
            try {
                this.writeObjectTo(out, null);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to represent null object with " + this, e);
            }
            nullObjectMarshalled = new Marshalled<Object>(null, out.toByteArray(), this, null);
        }
        this.nullObjectMarshalled = nullObjectMarshalled;
        return this.nullObjectMarshalled;
    }

    Marshalled<T> getNullBytesMarshalled() {
        if (!this.supportsNullObject()) {
            throw new NullPointerException("Null object is not supported by " + this);
        }
        Marshalled<T> nullBytesMarshalled = this.nullBytesMarshalled;
        if (nullBytesMarshalled != null) {
            return nullBytesMarshalled;
        }
        return this.getNullBytesMarshalledSync();
    }

    private synchronized Marshalled<T> getNullBytesMarshalledSync() {
        Marshalled<Object> nullBytesMarshalled = this.nullBytesMarshalled;
        if (nullBytesMarshalled != null) {
            return nullBytesMarshalled;
        }
        this.nullBytesMarshalled = nullBytesMarshalled = new Marshalled<Object>(null, null, this, null);
        return this.nullBytesMarshalled;
    }

    public static abstract class Typed<T>
    extends Marshaller<T> {
        Typed() {
        }

        public abstract String getTypes();

        public abstract Class<?>[] getClasses(ClassLoader var1) throws InvalidClassException;

        @Override
        public abstract boolean equals(Object var1);

        @Override
        public abstract int hashCode();
    }
}

